/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.database.init.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.core.data.OrcsTypeSheet;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.plugin.core.util.ExtensionPoints;
import org.osgi.framework.Bundle;

public class OseeTypesSetup {
    private static final String DECLARING_PLUGIN_ID = "org.eclipse.osee.framework.skynet.core";
    private static final String OSEE_TYPES_ELEMENT = "OseeTypes";
    private static final String OSEE_TYPES_EXTENSION_ID = "org.eclipse.osee.framework.skynet.core.OseeTypes";

    public static List<OrcsTypeSheet> getOseeTypeExtensions() {
        LinkedList<OrcsTypeSheet> oseeTypes = new LinkedList<OrcsTypeSheet>();
        for (IConfigurationElement element : ExtensionPoints.getExtensionElements((String)OSEE_TYPES_EXTENSION_ID, (String)OSEE_TYPES_ELEMENT)) {
            OrcsTypeSheet sheet = new OrcsTypeSheet();
            String resourceName = element.getAttribute("resource");
            Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
            URL url = bundle.getEntry(resourceName);
            sheet.setName(element.getDeclaringExtension().getUniqueIdentifier());
            sheet.setId(element.getAttribute("id"));
            try {
                if (url == null) continue;
                sheet.setTypesSheet(Lib.inputStreamToString((InputStream)new BufferedInputStream(url.openStream())));
                oseeTypes.add(sheet);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        return oseeTypes;
    }

    public static String getOseeTypeModelByExtensions(Collection<String> uniqueIdsToImport) {
        StringBuilder unifiedModel = new StringBuilder(10000);
        for (OrcsTypeSheet sheet : OseeTypesSetup.getOseeTypeExtensions()) {
            if (!uniqueIdsToImport.contains(sheet.getName())) continue;
            unifiedModel.append("//////////////     ");
            unifiedModel.append(sheet.getName());
            unifiedModel.append("\n\n");
            unifiedModel.append(sheet.getTypesSheet().replaceAll("import\\s+\"", "// import \""));
        }
        return unifiedModel.toString();
    }
}

