/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.database.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.osee.framework.database.init.DefaultDbInitTasks;
import org.eclipse.osee.framework.database.init.DefaultOseeTypeDefinitions;
import org.eclipse.osee.framework.database.init.IDatabaseInitConfiguration;

public class DatabaseInitConfiguration
implements IDatabaseInitConfiguration {
    private final List<String> dbInitTasks = new ArrayList<String>();
    private final List<String> oseeTypeIds = new ArrayList<String>();

    public void addTask(String taskId) {
        this.dbInitTasks.add(taskId);
    }

    public void addOseeType(String oseeTypesExtensionIds) {
        this.oseeTypeIds.add(oseeTypesExtensionIds);
    }

    public void addOseeType(DefaultOseeTypeDefinitions typeDef) {
        this.addDefaultType(this.oseeTypeIds, typeDef);
    }

    @Override
    public List<String> getTaskExtensionIds() {
        ArrayList<String> initTasks = new ArrayList<String>();
        this.addDefaultTask(initTasks, DefaultDbInitTasks.BOOTSTRAP_TASK);
        initTasks.addAll(this.dbInitTasks);
        this.addDefaultTask(initTasks, DefaultDbInitTasks.DB_USER_CLEANUP);
        this.addDefaultTask(initTasks, DefaultDbInitTasks.BRANCH_DATA_IMPORT);
        return initTasks;
    }

    @Override
    public List<String> getOseeTypeExtensionIds() {
        LinkedHashSet<String> oseeTypes = new LinkedHashSet<String>();
        oseeTypes.addAll(this.oseeTypeIds);
        return new ArrayList<String>(oseeTypes);
    }

    private void addDefaultTask(Collection<String> initTasks, DefaultDbInitTasks task) {
        initTasks.add(task.getExtensionId());
    }

    private void addDefaultType(Collection<String> initTasks, DefaultOseeTypeDefinitions type) {
        initTasks.add(type.getExtensionId());
    }
}

