/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.blam;

import java.io.File;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.traceability.ITraceParser;
import org.eclipse.osee.define.ide.traceability.ITraceUnitResourceLocator;
import org.eclipse.osee.define.ide.traceability.TraceUnitExtensionManager;
import org.eclipse.osee.define.ide.utility.IResourceHandler;
import org.eclipse.osee.define.ide.utility.UriResourceContentFinder;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.type.MutableBoolean;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.IExceptionableRunnable;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorProvider;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorTab;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.html.ResultsEditorHtmlTab;
import org.eclipse.osee.framework.ui.skynet.results.table.IResultsXViewerRow;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsEditorTableTab;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsXViewerRow;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class RemoveTraceMarksFromTraceUnits
extends AbstractBlam {
    public String getName() {
        return "Remove Trace Marks from Resource";
    }

    public Collection<String> getCategories() {
        return Arrays.asList("Define.Trace");
    }

    public String getDescriptionUsage() {
        return "Removes trace marks from files selected.\n*** WARNING_OVERLAY: When \"Persist Changes\" is selected, files will be modified in place.\n There is no way to undo this operation - make sure you know what you are doing. ***\n ";
    }

    public String getXWidgetsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<xWidgets>");
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Select File Or Folder (file can have a list of folders separated by newlines)\"/>");
        builder.append("<XWidget xwidgetType=\"XFileSelectionDialog\" displayName=\"Select File\" />");
        builder.append("<XWidget xwidgetType=\"XDirectorySelectionDialog\" displayName=\"Select Folder\" />");
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Select Trace Types:\"/>");
        for (TraceUnitExtensionManager.TraceHandler handler : this.getTraceHandlers()) {
            builder.append(this.getOperationsCheckBoxes(handler.getName()));
        }
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Persist Changes\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Include Sub-Folders\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"File With Embedded Paths\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        builder.append("</xWidgets>");
        return builder.toString();
    }

    private TraceUnitExtensionManager.TraceHandler getCheckedTraceHandler(VariableMap variableMap) {
        ArrayList<TraceUnitExtensionManager.TraceHandler> toReturn = new ArrayList<TraceUnitExtensionManager.TraceHandler>();
        for (TraceUnitExtensionManager.TraceHandler handler : this.getTraceHandlers()) {
            if (!variableMap.getBoolean(handler.getName())) continue;
            toReturn.add(handler);
        }
        if (toReturn.isEmpty()) {
            throw new OseeArgumentException("Please select a trace type", new Object[0]);
        }
        if (toReturn.size() > 1) {
            throw new OseeArgumentException("Only (1) trace type can be selected per run. Please de-select other types.", new Object[0]);
        }
        return (TraceUnitExtensionManager.TraceHandler)toReturn.get(0);
    }

    private void checkPath(String filePath, String type) {
        if (!Strings.isValid((String)filePath)) {
            throw new OseeArgumentException("Please enter a valid %s path", new Object[]{type});
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new OseeArgumentException("%s path [%s] is not accessible", new Object[]{type, filePath});
        }
    }

    private URI getSourceURI(VariableMap variableMap) {
        String filePath = variableMap.getString("Select File");
        String folderPath = variableMap.getString("Select Folder");
        String pathToUse = null;
        if (Strings.isValid((String)folderPath) && Strings.isValid((String)filePath)) {
            throw new OseeArgumentException("Enter file or folder but not both", new Object[0]);
        }
        if (Strings.isValid((String)folderPath)) {
            this.checkPath(folderPath, "folder");
            pathToUse = folderPath;
        } else {
            this.checkPath(filePath, "file");
            pathToUse = filePath;
        }
        return new File(pathToUse).toURI();
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        try {
            URI source = this.getSourceURI(variableMap);
            TraceUnitExtensionManager.TraceHandler handler = this.getCheckedTraceHandler(variableMap);
            final boolean isInPlaceStorageAllowed = variableMap.getBoolean("Persist Changes");
            boolean isRecursionAllowed = variableMap.getBoolean("Include Sub-Folders");
            boolean isFileWithMultiplePaths = variableMap.getBoolean("File With Embedded Paths");
            monitor.beginTask(this.getName(), Integer.MAX_VALUE);
            final MutableBoolean isProcessingAllowed = new MutableBoolean(false);
            UIJob job = new UIJob(this.getName()){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    isProcessingAllowed.setValue(isInPlaceStorageAllowed ? MessageDialog.openConfirm((Shell)new Shell(), (String)super.getName(), (String)"Are you sure you want to remove trace marks from files?") : true);
                    return Status.OK_STATUS;
                }
            };
            Jobs.startJob((Job)job, (boolean)true);
            job.join();
            if (isProcessingAllowed.getValue()) {
                ITraceUnitResourceLocator locator = handler.getLocator();
                ITraceParser parser = handler.getParser();
                ReportCreator reportCreator = new ReportCreator(monitor);
                UriResourceContentFinder resourceFinder = new UriResourceContentFinder(Arrays.asList(source), isRecursionAllowed, isFileWithMultiplePaths);
                resourceFinder.addLocator(locator, new TraceRemover(isInPlaceStorageAllowed, locator, parser, reportCreator));
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, Integer.MAX_VALUE);
                resourceFinder.execute((IProgressMonitor)subMonitor);
                reportCreator.openReport();
            }
        }
        finally {
            monitor.done();
        }
    }

    private String getOperationsCheckBoxes(String value) {
        StringBuilder builder = new StringBuilder();
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"");
        builder.append(value);
        builder.append("\" labelAfter=\"true\" horizontalLabel=\"true\"/>");
        return builder.toString();
    }

    private List<TraceUnitExtensionManager.TraceHandler> getTraceHandlers() {
        ArrayList<TraceUnitExtensionManager.TraceHandler> handlers = new ArrayList<TraceUnitExtensionManager.TraceHandler>();
        try {
            for (TraceUnitExtensionManager.TraceHandler handler : TraceUnitExtensionManager.getInstance().getAllTraceHandlers()) {
                if (!handler.getParser().isTraceRemovalAllowed()) continue;
                handlers.add(handler);
            }
        }
        catch (Exception ex) {
            this.log(ex);
        }
        return handlers;
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }

    private final class ReportCreator {
        private List<IResultsXViewerRow> modifiedRows = null;
        private List<IResultsXViewerRow> noChangeRows = null;
        private final IProgressMonitor monitor;

        public ReportCreator(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void addModifiedItem(String name, CharBuffer original, CharBuffer modified) {
            String[] entries;
            if (this.modifiedRows == null) {
                this.modifiedRows = new ArrayList<IResultsXViewerRow>();
            }
            String delta = this.getDelta(original, modified);
            String[] stringArray = entries = delta.split("(\\n|;)");
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String diff = stringArray[n2];
                if (Strings.isValid((String)(diff = diff.trim()))) {
                    this.modifiedRows.add((IResultsXViewerRow)new ResultsXViewerRow(new String[]{name, diff}));
                }
                ++n2;
            }
        }

        private String getDelta(CharBuffer original, CharBuffer modified) {
            StringBuilder buffer = new StringBuilder();
            int originalLength = original.length();
            int modifiedLength = modified.length();
            int origIndex = 0;
            int modIndex = 0;
            while (origIndex < originalLength || modIndex < modifiedLength) {
                char modChar;
                char origChar = original.get(origIndex);
                if (origChar != (modChar = modified.get(modIndex))) {
                    buffer.append(origChar);
                    if (originalLength > modifiedLength) {
                        ++origIndex;
                    } else {
                        ++modIndex;
                    }
                } else {
                    ++origIndex;
                    ++modIndex;
                }
                if (this.monitor.isCanceled()) break;
            }
            return buffer.toString();
        }

        public void addNoChangeItem(String ... name) {
            if (this.noChangeRows == null) {
                this.noChangeRows = new ArrayList<IResultsXViewerRow>();
            }
            this.noChangeRows.add((IResultsXViewerRow)new ResultsXViewerRow(name));
        }

        private List<XViewerColumn> getNoChangeHeaders() {
            return this.createColumnHelper("Trace Unit Without Change");
        }

        private List<XViewerColumn> getModifiedHeaders() {
            return this.createColumnHelper("Modified Trace Unit", "Removed");
        }

        private List<XViewerColumn> createColumnHelper(String ... headers) {
            ArrayList<XViewerColumn> columns = new ArrayList<XViewerColumn>();
            String[] stringArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                columns.add(new XViewerColumn(name, name, 80, XViewerAlign.Left, true, SortDataType.String, false, ""));
                ++n2;
            }
            return columns;
        }

        public void openReport() {
            IExceptionableRunnable runnable = new IExceptionableRunnable(){

                public IStatus run(IProgressMonitor monitor) throws Exception {
                    ResultsEditor.open((IResultsEditorProvider)new IResultsEditorProvider(){

                        public String getEditorName() {
                            return RemoveTraceMarksFromTraceUnits.this.getName();
                        }

                        public List<IResultsEditorTab> getResultsEditorTabs() {
                            ArrayList<IResultsEditorTab> resultsTabs = new ArrayList<IResultsEditorTab>();
                            if (ReportCreator.this.modifiedRows != null && !ReportCreator.this.modifiedRows.isEmpty()) {
                                resultsTabs.add((IResultsEditorTab)new ResultsEditorTableTab("Modified Trace Units", ReportCreator.this.getModifiedHeaders(), (Collection)ReportCreator.this.modifiedRows));
                            }
                            if (ReportCreator.this.noChangeRows != null && !ReportCreator.this.noChangeRows.isEmpty()) {
                                resultsTabs.add((IResultsEditorTab)new ResultsEditorTableTab("Unmodified Items", ReportCreator.this.getNoChangeHeaders(), (Collection)ReportCreator.this.noChangeRows));
                            }
                            if (resultsTabs.isEmpty()) {
                                resultsTabs.add((IResultsEditorTab)new ResultsEditorHtmlTab(RemoveTraceMarksFromTraceUnits.this.getName(), RemoveTraceMarksFromTraceUnits.this.getName(), "No changes Reported"));
                            }
                            return resultsTabs;
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            Jobs.runInJob((String)RemoveTraceMarksFromTraceUnits.this.getName(), (IExceptionableRunnable)runnable, Activator.class, (String)"org.eclipse.osee.define.ide");
        }
    }

    private static final class TraceRemover
    implements IResourceHandler {
        private final ITraceParser traceParser;
        private final ITraceUnitResourceLocator traceUnitLocator;
        private final boolean isStorageAllowed;
        private final ReportCreator reportCreator;

        public TraceRemover(boolean isStorageAllowed, ITraceUnitResourceLocator traceUnitLocator, ITraceParser traceParser, ReportCreator reportCreator) {
            this.isStorageAllowed = isStorageAllowed;
            this.traceParser = traceParser;
            this.traceUnitLocator = traceUnitLocator;
            this.reportCreator = reportCreator;
        }

        @Override
        public void onResourceFound(URI uriPath, String name, CharBuffer fileBuffer) {
            ArtifactTypeToken traceUnitType = this.traceUnitLocator.getTraceUnitType(name, fileBuffer);
            if (!traceUnitType.equals("Unknown") && this.traceParser.isTraceRemovalAllowed()) {
                CharBuffer modifiedBuffer = this.traceParser.removeTraceMarks(fileBuffer);
                if (modifiedBuffer != null) {
                    this.reportCreator.addModifiedItem(name, fileBuffer, modifiedBuffer);
                    if (this.isStorageAllowed) {
                        try {
                            Lib.writeCharBufferToFile((CharBuffer)modifiedBuffer, (File)new File(uriPath));
                        }
                        catch (Exception ex) {
                            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                        }
                    }
                } else {
                    this.reportCreator.addNoChangeItem(name);
                }
            }
        }
    }
}

