/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.CharBackedInputStream;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.framework.plugin.core.util.AIFile;
import org.eclipse.osee.framework.skynet.core.OseeSystemArtifacts;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.utility.ViewIdUtility;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.branch.ViewApplicabilityUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XBranchSelectWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PublishSystemLevelSSDD
extends AbstractBlam {
    private static final String BRANCH = "Branch";
    private CharBackedInputStream charBak;
    private ISheetWriter excelWriter;
    private List<Artifact> sysReqs;
    private Artifact[] allSubsystems;
    private final HashCollection<Artifact, Artifact> subsystemToRequirements = new HashCollection();
    private XCombo branchViewWidget;
    private XBranchSelectWidget branchWidget;

    public String getName() {
        return "Publish System Level SSDD";
    }

    private void init() throws IOException {
        this.charBak = new CharBackedInputStream();
        this.excelWriter = new ExcelXmlWriter(this.charBak.getWriter());
        this.subsystemToRequirements.clear();
    }

    public String getXWidgetsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<xWidgets>");
        builder.append("<xWidgets><XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"Branch\" /></xWidgets>");
        builder.append("<XWidget xwidgetType=\"XCombo()\" displayName=\"Branch View\" horizontalLabel=\"true\"/>");
        builder.append("</xWidgets>");
        return builder.toString();
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Generating System Level SSDD", 100);
        BranchId branch = variableMap.getBranch(BRANCH);
        Object view = variableMap.getValue("Branch View");
        this.setViewId(view);
        this.init();
        ViewIdUtility.findExcludedArtifactsByView((ArtifactId)this.viewId, (BranchId)branch);
        monitor.subTask("Aquiring System Components");
        ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.Component, (BranchId)branch);
        monitor.subTask("Aquiring System Requirements");
        ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.SystemRequirementMsWord, (BranchId)branch);
        OseeSystemArtifacts.getDefaultHierarchyRootArtifact((BranchId)branch);
        this.sysReqs = ArtifactQuery.getArtifactFromId((ArtifactId)CoreArtifactTokens.SystemRequirementsFolder, (BranchId)branch).getDescendants();
        this.excludeArtifacts(this.sysReqs.iterator());
        this.getSubsystemList();
        monitor.subTask("5.2 System Requirement Allocation To Subsystems");
        this.writeSystemRequirementAllocationToSubsystems();
        Artifact[] artifactArray = this.allSubsystems;
        int n = this.allSubsystems.length;
        int n2 = 0;
        while (n2 < n) {
            Artifact subsystem = artifactArray[n2];
            this.writeSystemRequirementAllocationBySubsystem(subsystem);
            ++n2;
        }
        this.excelWriter.endWorkbook();
        IFile iFile = OseeData.getIFile((String)("SystemLevelSSDD_" + Lib.getDateTimeString() + ".xml"));
        AIFile.writeToFile((IFile)iFile, (InputStream)this.charBak);
        Program.launch((String)iFile.getLocation().toOSString());
    }

    private void getSubsystemList() {
        for (Artifact systemRequirement : this.sysReqs) {
            List relatedArtifacts = systemRequirement.getRelatedArtifacts(CoreRelationTypes.Allocation_Component);
            this.excludeArtifacts(relatedArtifacts.iterator());
            for (Artifact subsystem : relatedArtifacts) {
                this.subsystemToRequirements.put((Object)subsystem, (Object)systemRequirement);
            }
        }
        Set subsystemsSet = this.subsystemToRequirements.keySet();
        this.allSubsystems = new Artifact[subsystemsSet.size()];
        subsystemsSet.toArray(this.allSubsystems);
        Arrays.sort(this.allSubsystems);
    }

    private void writeSystemRequirementAllocationToSubsystems() throws IOException {
        this.excelWriter.startSheet("5.2", 200);
        this.excelWriter.writeCell((Object)CoreAttributeTypes.ParagraphNumber.getName());
        this.excelWriter.writeCell((Object)CoreArtifactTypes.Component.getName());
        Artifact[] artifactArray = this.allSubsystems;
        int n = this.allSubsystems.length;
        int n2 = 0;
        while (n2 < n) {
            Artifact subsystem = artifactArray[n2];
            this.excelWriter.writeCell((Object)subsystem.getName());
            ++n2;
        }
        this.excelWriter.endRow();
        this.excelWriter.writeRow(new Object[]{"5.2 System Requirement Allocation to Subsystems"});
        for (Artifact systemRequirement : this.sysReqs) {
            this.writeSystemRequirementAllocation(systemRequirement);
        }
        this.excelWriter.endSheet();
    }

    private void writeSystemRequirementAllocationBySubsystem(Artifact subsystem) throws IOException {
        this.excelWriter.startSheet(subsystem.getName(), 200);
        this.excelWriter.writeRow(new Object[]{"System Requirements Allocated to the " + subsystem.getName()});
        this.excelWriter.writeRow(new Object[]{CoreAttributeTypes.ParagraphNumber.getName(), CoreArtifactTypes.SystemRequirementMsWord.getName(), "Notes <rationale>"});
        for (Artifact systemRequirement : (List)this.subsystemToRequirements.getValues((Object)subsystem)) {
            List relatedArtifacts = systemRequirement.getRelatedArtifacts(CoreRelationTypes.Allocation_Component);
            this.excludeArtifacts(relatedArtifacts.iterator());
            for (Artifact component : relatedArtifacts) {
                if (!component.equals((Object)subsystem)) continue;
                String rationale = systemRequirement.getRelationRationale(component, CoreRelationTypes.Allocation_Component);
                if (rationale.equals("")) {
                    rationale = null;
                }
                this.excelWriter.writeRow(new Object[]{systemRequirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)""), systemRequirement.getName(), rationale});
            }
        }
        this.excelWriter.endSheet();
    }

    private void writeSystemRequirementAllocation(Artifact systemRequirement) throws IOException {
        this.excelWriter.writeCell(systemRequirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)""));
        this.excelWriter.writeCell((Object)systemRequirement.getName());
        List relatedArtifacts = systemRequirement.getRelatedArtifacts(CoreRelationTypes.Allocation_Component);
        this.excludeArtifacts(relatedArtifacts.iterator());
        ArrayList allocatedSubsystems = new ArrayList(relatedArtifacts);
        Collections.sort(allocatedSubsystems);
        for (Artifact allocatedSubsystem : allocatedSubsystems) {
            this.excelWriter.writeCell((Object)"X", Arrays.binarySearch(this.allSubsystems, allocatedSubsystem) + 2);
        }
        this.excelWriter.endRow();
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        if (xWidget.getLabel().equals(BRANCH)) {
            this.branchWidget = (XBranchSelectWidget)xWidget;
            this.branchWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    if (PublishSystemLevelSSDD.this.branchViewWidget != null) {
                        PublishSystemLevelSSDD.this.branchViewWidget.setEditable(true);
                        BranchToken branch = PublishSystemLevelSSDD.this.branchWidget.getSelection();
                        if (branch != null && branch.isValid()) {
                            PublishSystemLevelSSDD.this.branchViews = ViewApplicabilityUtil.getBranchViews((BranchId)ViewApplicabilityUtil.getParentBranch((BranchId)branch));
                            PublishSystemLevelSSDD.this.branchViewWidget.setDataStrings(PublishSystemLevelSSDD.this.branchViews.values());
                        }
                    }
                }
            });
        } else if (xWidget.getLabel().equals("Branch View")) {
            this.branchViewWidget = (XCombo)xWidget;
            this.branchViewWidget.setEditable(false);
        }
    }

    public String getDescriptionUsage() {
        return "Generate Traceability tables for the System Level SSDD";
    }

    public Collection<String> getCategories() {
        return Arrays.asList("Define.Publish");
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }
}

