/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.artifacts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.ote.define.internal.Activator;

public class OteArtifactFetcher<T extends Artifact> {
    private final ArtifactTypeToken oteArtifactType;

    protected OteArtifactFetcher(ArtifactTypeToken oteArtifactType) {
        this.oteArtifactType = oteArtifactType;
    }

    public T getNewArtifact(BranchToken branch) {
        this.checkForNull(branch);
        return (T)ArtifactTypeManager.addArtifact((ArtifactTypeToken)this.oteArtifactType, (BranchToken)branch);
    }

    public T searchForUniqueArtifactMatching(AttributeTypeId attributeType, String attributeValue, BranchId branch) {
        Conditions.checkNotNull((Object)attributeType, (String)"attributeType");
        Conditions.checkNotNull((Object)attributeValue, (String)"attributeValue");
        Conditions.checkNotNull((Object)branch, (String)"branch");
        return (T)ArtifactQuery.getArtifactFromTypeAndAttribute((ArtifactTypeId)this.oteArtifactType, (AttributeTypeId)attributeType, (String)attributeValue, (BranchId)branch);
    }

    public Set<T> getAllArtifacts(BranchId branch) {
        this.checkForNull(branch);
        HashSet<Artifact> toReturn = new HashSet<Artifact>();
        try {
            List artifacts = ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)this.oteArtifactType, (BranchId)branch);
            for (Artifact artifact : artifacts) {
                toReturn.add(artifact);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.logf(Activator.class, (Level)Level.WARNING, (Throwable)ex, (String)"Search for all artifacts failed [%s] on branch [%s]", (Object[])new Object[]{this.oteArtifactType.getName(), branch.getId()});
        }
        return toReturn;
    }

    public Map<String, T> getAllArtifactsIndexedByName(BranchId branch) {
        HashMap<String, Artifact> toReturn = new HashMap<String, Artifact>();
        Set<T> testScripts = this.getAllArtifacts(branch);
        for (Artifact artifact : testScripts) {
            toReturn.put(artifact.getName(), artifact);
        }
        return toReturn;
    }

    private void checkForNull(Object object) {
        if (object == null) {
            throw new OseeArgumentException("Object was null", new Object[0]);
        }
    }
}

