/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.core.patch.Hunk;
import org.eclipse.compare.internal.patch.HunkDiffNode;
import org.eclipse.compare.internal.patch.PatchCompareEditorInput;
import org.eclipse.compare.internal.patch.PatchDiffNode;
import org.eclipse.compare.internal.patch.PatchFileDiffNode;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchProjectDiffNode;
import org.eclipse.compare.internal.patch.RetargetPatchElementDialog;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PreviewPatchPage2
extends WizardPage {
    protected static final String PREVIEWPATCHPAGE_NAME = "PreviewPatchPage";
    private static final String EXPAND_PATCH_OPTIONS = "expandPatchOptions";
    private static final String GENERATE_REJECTS = "generateRejects";
    final WorkspacePatcher fPatcher;
    private final CompareConfiguration fConfiguration;
    private PatchCompareEditorInput fInput;
    private Combo fStripPrefixSegments;
    private Text fFuzzField;
    private Label addedRemovedLines;
    private Action fExcludeAction;
    private Action fIncludeAction;
    private Action fIgnoreWhiteSpace;
    private Action fReversePatch;
    private Action fMoveAction;
    protected boolean pageRecalculate = true;
    private IDialogSettings settings;
    private ExpandableComposite patchOptions;
    private Button generateRejects;
    private FormToolkit fToolkit;

    public PreviewPatchPage2(WorkspacePatcher patcher, CompareConfiguration configuration) {
        super(PREVIEWPATCHPAGE_NAME, PatchMessages.PreviewPatchPage_title, null);
        this.setDescription(PatchMessages.PreviewPatchPage2_8);
        Assert.isNotNull((Object)patcher);
        Assert.isNotNull((Object)configuration);
        this.fPatcher = patcher;
        this.fConfiguration = configuration;
        this.fConfiguration.addPropertyChangeListener(event -> {
            if (event.getProperty().equals("IGNORE_WHITESPACE")) {
                this.rebuildTree();
            }
        });
    }

    public void createControl(Composite parent) {
        this.fToolkit = new FormToolkit(parent.getDisplay());
        this.fToolkit.setBackground(Display.getDefault().getSystemColor(22));
        Form form = this.fToolkit.createForm(parent);
        Composite composite = form.getBody();
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)parent);
        this.fInput = new PatchCompareEditorInput(this.getPatcher(), this.getCompareConfiguration()){

            @Override
            protected void fillContextMenu(IMenuManager manager) {
                if (this.isShowAll()) {
                    manager.add((IAction)PreviewPatchPage2.this.fIncludeAction);
                }
                manager.add((IAction)PreviewPatchPage2.this.fExcludeAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)PreviewPatchPage2.this.fMoveAction);
            }
        };
        this.buildPatchOptionsGroup(form);
        try {
            this.fInput.run(null);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        Label label = new Label(composite, 0);
        label.setText(PatchMessages.PreviewPatchPage2_9);
        Control c = this.fInput.createContents(composite);
        this.initializeActions();
        this.fInput.contributeDiffViewerToolbarItems(this.getContributedActions(), this.getPatcher().isWorkspacePatch());
        this.fInput.getViewer().addSelectionChangedListener(event -> {
            ISelection s = event.getSelection();
            if (s != null && !s.isEmpty() && s instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)s;
                this.updateActions(ss);
            }
        });
        c.setLayoutData((Object)new GridData(1808));
        this.addedRemovedLines = new Label(composite, 0);
        this.addedRemovedLines.setLayoutData((Object)new GridData(770));
        this.setControl((Control)composite);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)composite);
    }

    private void updateActions(IStructuredSelection ss) {
        this.fExcludeAction.setEnabled(false);
        this.fIncludeAction.setEnabled(false);
        for (Object element : ss) {
            if (!(element instanceof PatchDiffNode)) continue;
            if (((PatchDiffNode)element).isEnabled()) {
                this.fExcludeAction.setEnabled(true);
                continue;
            }
            this.fIncludeAction.setEnabled(true);
        }
    }

    private void updateEnablements() {
        boolean atLeastOneIsEnabled = false;
        if (this.fInput != null) {
            atLeastOneIsEnabled = this.fInput.hasResultToApply();
        }
        this.setPageComplete(atLeastOneIsEnabled);
    }

    private Action[] getContributedActions() {
        return new Action[]{this.fIgnoreWhiteSpace};
    }

    private void initializeActions() {
        this.fMoveAction = new Action(PatchMessages.PreviewPatchPage2_RetargetAction, null){

            public void run() {
                IStructuredSelection ss;
                Shell shell = PreviewPatchPage2.this.getShell();
                ISelection selection = PreviewPatchPage2.this.fInput.getViewer().getSelection();
                PatchDiffNode node = null;
                if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).getFirstElement() instanceof PatchDiffNode) {
                    node = (PatchDiffNode)ss.getFirstElement();
                }
                if (node == null) {
                    return;
                }
                RetargetPatchElementDialog dialog = new RetargetPatchElementDialog(shell, PreviewPatchPage2.this.fPatcher, node);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    PreviewPatchPage2.this.rebuildTree();
                }
            }
        };
        this.fMoveAction.setToolTipText(PatchMessages.PreviewPatchPage2_RetargetTooltip);
        this.fMoveAction.setEnabled(true);
        this.fInput.getViewer().addSelectionChangedListener(event -> {
            IStructuredSelection sel = event.getStructuredSelection();
            Object obj = sel.getFirstElement();
            boolean enable = false;
            if (obj instanceof PatchProjectDiffNode) {
                enable = true;
            } else if (obj instanceof PatchFileDiffNode) {
                PatchFileDiffNode node = (PatchFileDiffNode)obj;
                enable = node.getDiffResult().getDiffProblem();
            } else if (obj instanceof HunkDiffNode) {
                enable = true;
            }
            this.fMoveAction.setEnabled(enable);
        });
        this.fExcludeAction = new Action(PatchMessages.PreviewPatchPage2_0){

            public void run() {
                ISelection selection = PreviewPatchPage2.this.fInput.getViewer().getSelection();
                if (selection instanceof TreeSelection) {
                    TreeSelection treeSelection = (TreeSelection)selection;
                    for (Object obj : treeSelection) {
                        if (!(obj instanceof PatchDiffNode)) continue;
                        PatchDiffNode node = (PatchDiffNode)obj;
                        node.setEnabled(false);
                    }
                    PreviewPatchPage2.this.updateActions((IStructuredSelection)treeSelection);
                }
                PreviewPatchPage2.this.fInput.getViewer().refresh();
            }
        };
        this.fExcludeAction.setEnabled(true);
        this.fIncludeAction = new Action(PatchMessages.PreviewPatchPage2_1){

            public void run() {
                ISelection selection = PreviewPatchPage2.this.fInput.getViewer().getSelection();
                if (selection instanceof TreeSelection) {
                    TreeSelection treeSelection = (TreeSelection)selection;
                    for (Object obj : treeSelection) {
                        if (!(obj instanceof PatchDiffNode)) continue;
                        PatchDiffNode node = (PatchDiffNode)obj;
                        node.setEnabled(true);
                    }
                    PreviewPatchPage2.this.updateActions((IStructuredSelection)treeSelection);
                }
                PreviewPatchPage2.this.fInput.getViewer().refresh();
            }
        };
        this.fIncludeAction.setEnabled(true);
        this.fIgnoreWhiteSpace = new Action(PatchMessages.PreviewPatchPage2_IgnoreWSAction, CompareUIPlugin.getImageDescriptor("etool16/ignorews_edit.png")){

            public void run() {
                try {
                    PreviewPatchPage2.this.getContainer().run(false, true, monitor -> {
                        monitor.beginTask(PatchMessages.PreviewPatchPage2_IgnoreWhitespace, -1);
                        if (this.isChecked() != PreviewPatchPage2.this.getPatcher().isIgnoreWhitespace()) {
                            if (PreviewPatchPage2.this.promptToRebuild(PatchMessages.PreviewPatchPage2_2)) {
                                if (PreviewPatchPage2.this.getPatcher().setIgnoreWhitespace(this.isChecked())) {
                                    PreviewPatchPage2.this.getCompareConfiguration().setProperty("IGNORE_WHITESPACE", this.isChecked());
                                }
                            } else {
                                PreviewPatchPage2.this.fIgnoreWhiteSpace.setChecked(!this.isChecked());
                            }
                        }
                        monitor.done();
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        this.fIgnoreWhiteSpace.setChecked(false);
        this.fIgnoreWhiteSpace.setToolTipText(PatchMessages.PreviewPatchPage2_IgnoreWSTooltip);
        this.fIgnoreWhiteSpace.setDisabledImageDescriptor(CompareUIPlugin.getImageDescriptor("dtool16/ignorews_edit.png"));
        this.fReversePatch = new Action(PatchMessages.PreviewPatchPage_ReversePatch_text){

            public void run() {
                try {
                    PreviewPatchPage2.this.getContainer().run(true, true, monitor -> {
                        monitor.beginTask(PatchMessages.PreviewPatchPage2_CalculateReverse, -1);
                        if (this.isChecked() != PreviewPatchPage2.this.getPatcher().isReversed()) {
                            if (PreviewPatchPage2.this.promptToRebuild(PatchMessages.PreviewPatchPage2_3)) {
                                if (PreviewPatchPage2.this.getPatcher().setReversed(this.isChecked())) {
                                    PreviewPatchPage2.this.rebuildTree();
                                }
                            } else {
                                PreviewPatchPage2.this.fReversePatch.setChecked(!this.isChecked());
                            }
                        }
                        monitor.done();
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        this.fReversePatch.setChecked(false);
        this.fReversePatch.setToolTipText(PatchMessages.PreviewPatchPage_ReversePatch_text);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fillSegmentCombo();
            if (this.getPatcher().isGitPatch()) {
                int ignore = this.getPatcher().calculateStripGitPrefixSegments();
                this.fStripPrefixSegments.select(ignore);
                this.getPatcher().setStripPrefixSegments(ignore);
            }
            this.rebuildTree();
            this.updateEnablements();
            this.addedRemovedLines.setText(this.countLines());
            this.getCompareConfiguration().getContainer().getNavigator().selectChange(true);
            this.getContainer().updateButtons();
            this.getShell().getDefaultButton().setFocus();
        }
    }

    private boolean promptToRebuild(String promptToConfirm) {
        Control ctrl = this.getControl();
        boolean[] result = new boolean[1];
        if (ctrl != null && !ctrl.isDisposed()) {
            Runnable runnable = () -> {
                if (!ctrl.isDisposed()) {
                    try {
                        this.fInput.saveChanges(null);
                    }
                    catch (CoreException e) {
                        CompareUIPlugin.log(e);
                    }
                    blArray[0] = this.fInput.confirmRebuild(promptToConfirm);
                }
            };
            if (Display.getCurrent() == null) {
                ctrl.getDisplay().syncExec(runnable);
            } else {
                runnable.run();
            }
        }
        return result[0];
    }

    private void rebuildTree() {
        Control ctrl = this.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            Runnable runnable = () -> {
                if (!ctrl.isDisposed()) {
                    this.fInput.buildTree();
                    this.updateEnablements();
                }
            };
            if (Display.getCurrent() == null) {
                ctrl.getDisplay().syncExec(runnable);
            } else {
                runnable.run();
            }
        }
    }

    private void fillSegmentCombo() {
        if (this.getPatcher().isWorkspacePatch()) {
            this.fStripPrefixSegments.setEnabled(false);
        } else {
            this.fStripPrefixSegments.setEnabled(true);
            int length = 99;
            if (this.fStripPrefixSegments != null && this.pageRecalculate) {
                if (this.fStripPrefixSegments.getItemCount() > 1) {
                    this.fStripPrefixSegments.remove(1, this.fStripPrefixSegments.getItemCount() - 1);
                }
                if ((length = this.getPatcher().calculatePrefixSegmentCount()) != 99) {
                    int k = 1;
                    while (k < length) {
                        this.fStripPrefixSegments.add(Integer.toString(k));
                        ++k;
                    }
                    this.fStripPrefixSegments.select(0);
                    this.getPatcher().setStripPrefixSegments(0);
                    this.pageRecalculate = false;
                }
            }
        }
    }

    private void buildPatchOptionsGroup(final Form form) {
        Composite parent = form.getBody();
        this.patchOptions = this.fToolkit.createExpandableComposite(parent, 18);
        this.patchOptions.setText(PatchMessages.PreviewPatchPage_PatchOptions_title);
        this.patchOptions.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        this.patchOptions.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.patchOptions.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.layout();
            }
        });
        Composite c = new Composite((Composite)this.patchOptions, 0);
        this.patchOptions.setClient((Control)c);
        this.patchOptions.setExpanded(true);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        c.setLayout((Layout)gl);
        c.setLayoutData((Object)new GridData(768));
        this.createStripSegmentCombo(c);
        this.createShowMatchedToggle(c);
        this.createFuzzFactorChooser(c);
        this.createReversePatchToggle(c);
        this.createShowRemovedToggle(c);
        this.createGenerateRejectsToggle(c);
        final WorkspacePatcher patcher = this.getPatcher();
        if (this.fStripPrefixSegments != null) {
            this.fStripPrefixSegments.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (patcher.getStripPrefixSegments() != PreviewPatchPage2.this.getStripPrefixSegments() && PreviewPatchPage2.this.promptToRebuild(PatchMessages.PreviewPatchPage2_4) && patcher.setStripPrefixSegments(PreviewPatchPage2.this.getStripPrefixSegments())) {
                        PreviewPatchPage2.this.rebuildTree();
                    }
                }
            });
        }
        this.fFuzzField.addModifyListener(e -> {
            if (patcher.getFuzz() != this.getFuzzFactor()) {
                if (this.promptToRebuild(PatchMessages.PreviewPatchPage2_5)) {
                    if (patcher.setFuzz(this.getFuzzFactor())) {
                        this.rebuildTree();
                    }
                } else {
                    this.fFuzzField.setText(Integer.toString(patcher.getFuzz()));
                }
            }
        });
    }

    private void createFuzzFactorChooser(Composite parent) {
        final WorkspacePatcher patcher = this.getPatcher();
        Composite pair = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        pair.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        pair.setLayoutData((Object)gd);
        Label l = new Label(pair, 0);
        l.setText(PatchMessages.PreviewPatchPage_FuzzFactor_text);
        l.setToolTipText(PatchMessages.PreviewPatchPage_FuzzFactor_tooltip);
        gd = new GridData(548);
        l.setLayoutData((Object)gd);
        this.fFuzzField = new Text(pair, 2048);
        this.fFuzzField.setText("0");
        gd = new GridData(132);
        gd.widthHint = 30;
        this.fFuzzField.setLayoutData((Object)gd);
        Button b = new Button(pair, 8);
        b.setText(PatchMessages.PreviewPatchPage_GuessFuzz_text);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PreviewPatchPage2.this.promptToRebuild(PatchMessages.PreviewPatchPage2_6)) {
                    patcher.setFuzz(-1);
                    int fuzz = PreviewPatchPage2.this.guessFuzzFactor(patcher);
                    if (fuzz >= 0) {
                        PreviewPatchPage2.this.fFuzzField.setText(Integer.toString(fuzz));
                    }
                }
            }
        });
        gd = new GridData(4);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = b.computeSize(-1, -1, true);
        gd.widthHint = Math.max(widthHint, minSize.x);
        b.setLayoutData((Object)gd);
    }

    private void createGenerateRejectsToggle(Composite pair) {
        this.generateRejects = new Button(pair, 32);
        this.generateRejects.setText(PatchMessages.HunkMergePage_GenerateRejectFile);
        GridData gd = new GridData(548);
        this.generateRejects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewPatchPage2.this.getPatcher().setGenerateRejectFile(PreviewPatchPage2.this.generateRejects.getSelection());
            }
        });
        this.generateRejects.setSelection(false);
        this.generateRejects.setLayoutData((Object)gd);
    }

    private void createShowRemovedToggle(Composite pair) {
        final Button showRemoved = new Button(pair, 32);
        showRemoved.setText(PatchMessages.PreviewPatchPage2_7);
        GridData gd = new GridData(548);
        showRemoved.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewPatchPage2.this.fInput.setShowAll(showRemoved.getSelection());
                PreviewPatchPage2.this.fInput.updateTree();
            }
        });
        showRemoved.setSelection(this.fInput.isShowAll());
        showRemoved.setLayoutData((Object)gd);
    }

    private void createReversePatchToggle(Composite pair) {
        final Button reversePatch = new Button(pair, 32);
        reversePatch.setText(PatchMessages.PreviewPatchPage_ReversePatch_text);
        GridData gd = new GridData(548);
        reversePatch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PreviewPatchPage2.this.fReversePatch != null) {
                    PreviewPatchPage2.this.fReversePatch.setChecked(reversePatch.getSelection());
                    PreviewPatchPage2.this.fReversePatch.run();
                    if (PreviewPatchPage2.this.fReversePatch.isChecked() != reversePatch.getSelection()) {
                        reversePatch.setSelection(PreviewPatchPage2.this.fReversePatch.isChecked());
                    }
                }
            }
        });
        reversePatch.setSelection(this.getPatcher().isReversed());
        reversePatch.setLayoutData((Object)gd);
    }

    private void createStripSegmentCombo(Composite parent) {
        WorkspacePatcher patcher = this.getPatcher();
        Composite pair = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        pair.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        pair.setLayoutData((Object)gd);
        Label l = new Label(pair, 0);
        l.setText(PatchMessages.PreviewPatchPage_IgnoreSegments_text);
        gd = new GridData(36);
        l.setLayoutData((Object)gd);
        this.fStripPrefixSegments = new Combo(pair, 76);
        int prefixCnt = patcher.getStripPrefixSegments();
        String prefix = Integer.toString(prefixCnt);
        this.fStripPrefixSegments.add(prefix);
        this.fStripPrefixSegments.setText(prefix);
        gd = new GridData(548);
        this.fStripPrefixSegments.setLayoutData((Object)gd);
    }

    private void createShowMatchedToggle(Composite parent) {
        final Button showMatched = new Button(parent, 32);
        showMatched.setText(PatchMessages.PreviewPatchPage2_ShowMatched);
        GridData gd = new GridData(548);
        showMatched.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewPatchPage2.this.fInput.setShowMatched(showMatched.getSelection());
                PreviewPatchPage2.this.rebuildTree();
            }
        });
        showMatched.setSelection(this.fInput.isShowMatched());
        showMatched.setLayoutData((Object)gd);
    }

    public int getFuzzFactor() {
        int fuzzFactor = 0;
        if (this.fFuzzField != null) {
            String s = this.fFuzzField.getText();
            try {
                fuzzFactor = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return fuzzFactor;
    }

    public int getStripPrefixSegments() {
        int stripPrefixSegments = 0;
        if (this.fStripPrefixSegments != null) {
            String s = this.fStripPrefixSegments.getText();
            try {
                stripPrefixSegments = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return stripPrefixSegments;
    }

    private int guessFuzzFactor(WorkspacePatcher patcher) {
        int[] result = new int[]{-1};
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, monitor -> {
                int n = patcher.guessFuzzFactor(monitor);
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }

    public void ensureContentsSaved() {
        try {
            this.fInput.saveChanges((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    public WorkspacePatcher getPatcher() {
        return this.fPatcher;
    }

    public CompareConfiguration getCompareConfiguration() {
        return this.fConfiguration;
    }

    private void restoreWidgetValues() {
        IDialogSettings dialogSettings = CompareUI.getPlugin().getDialogSettings();
        this.settings = dialogSettings.getSection(PREVIEWPATCHPAGE_NAME);
        if (this.settings == null) {
            this.settings = dialogSettings.addNewSection(PREVIEWPATCHPAGE_NAME);
        }
        if (this.settings != null) {
            if (this.settings.get(EXPAND_PATCH_OPTIONS) != null) {
                this.patchOptions.setExpanded(this.settings.getBoolean(EXPAND_PATCH_OPTIONS));
            }
            if (this.settings.get(GENERATE_REJECTS) != null) {
                this.generateRejects.setSelection(this.settings.getBoolean(GENERATE_REJECTS));
                this.getPatcher().setGenerateRejectFile(this.generateRejects.getSelection());
            }
        }
    }

    void saveWidgetValues() {
        this.settings.put(EXPAND_PATCH_OPTIONS, this.patchOptions.isExpanded());
        this.settings.put(GENERATE_REJECTS, this.generateRejects.getSelection());
    }

    private String countLines() {
        int added = 0;
        int removed = 0;
        IPreferenceStore store = CompareUIPlugin.getDefault().getPreferenceStore();
        String addedLinesRegex = store.getString("org.eclipse.compare.AddedLinesRegex");
        String removedLinesRegex = store.getString("org.eclipse.compare.RemovedLinesRegex");
        if ((addedLinesRegex == null || "".equals(addedLinesRegex)) && (removedLinesRegex == null || "".equals(removedLinesRegex))) {
            this.fPatcher.countLines();
            FilePatch2[] fileDiffs = this.fPatcher.getDiffs();
            int i = 0;
            while (i < fileDiffs.length) {
                added += fileDiffs[i].getAddedLines();
                removed += fileDiffs[i].getRemovedLines();
                ++i;
            }
        } else {
            Pattern addedPattern = Pattern.compile(addedLinesRegex);
            Pattern removedPattern = Pattern.compile(removedLinesRegex);
            FilePatch2[] fileDiffs = this.fPatcher.getDiffs();
            int i = 0;
            while (i < fileDiffs.length) {
                IHunk[] hunks = fileDiffs[i].getHunks();
                int j = 0;
                while (j < hunks.length) {
                    String[] lines = ((Hunk)hunks[j]).getLines();
                    int k = 0;
                    while (k < lines.length) {
                        String line = lines[k];
                        if (addedPattern.matcher(line).find()) {
                            ++added;
                        }
                        if (removedPattern.matcher(line).find()) {
                            ++removed;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return NLS.bind((String)PatchMessages.PreviewPatchPage2_AddedRemovedLines, (Object[])new String[]{String.valueOf(added), String.valueOf(removed)});
    }

    public void dispose() {
        this.fToolkit.dispose();
        super.dispose();
    }
}

