/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.folding;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldedPosition;
import org.eclipse.xtext.ui.editor.folding.FoldedPosition;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.folding.IFoldingStructureProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;

public class DefaultFoldingStructureProvider
implements IFoldingStructureProvider,
IXtextModelListener {
    @Inject
    private IFoldingRegionProvider foldingRegionProvider;
    private XtextEditor editor;
    private ProjectionViewer viewer;
    private ProjectionChangeListener projectionListener;

    @Override
    public void install(XtextEditor editor, ProjectionViewer viewer) {
        Assert.isNotNull((Object)editor);
        Assert.isNotNull((Object)viewer);
        this.uninstall();
        this.editor = editor;
        this.viewer = viewer;
        this.projectionListener = new ProjectionChangeListener(viewer);
    }

    @Override
    public void initialize() {
        this.calculateProjectionAnnotationModel(true);
    }

    @Override
    public void uninstall() {
        if (this.isInstalled()) {
            this.handleProjectionDisabled();
            this.projectionListener.dispose();
            this.projectionListener = null;
            this.editor = null;
        }
    }

    protected final boolean isInstalled() {
        return this.editor != null;
    }

    @Override
    public void modelChanged(XtextResource resource) {
        if (resource == null) {
            return;
        }
        boolean existingSyntaxErrors = Iterables.any((Iterable)resource.getErrors(), (Predicate)new Predicate<Resource.Diagnostic>(){

            public boolean apply(Resource.Diagnostic diagnostic) {
                return diagnostic instanceof XtextSyntaxDiagnostic;
            }
        });
        if (!existingSyntaxErrors) {
            this.calculateProjectionAnnotationModel(false);
        }
    }

    protected void handleProjectionEnabled() {
        this.handleProjectionDisabled();
        if (this.isInstalled()) {
            this.initialize();
            IXtextDocument document = this.editor.getDocument();
            if (document != null) {
                document.addModelListener(this);
            }
        }
    }

    protected void handleProjectionDisabled() {
        IXtextDocument document;
        if (this.editor != null && (document = this.editor.getDocument()) != null) {
            document.removeModelListener(this);
        }
    }

    protected void calculateProjectionAnnotationModel(boolean allowCollapse) {
        ProjectionAnnotationModel projectionAnnotationModel = this.viewer.getProjectionAnnotationModel();
        if (projectionAnnotationModel != null) {
            LinkedHashSet foldedPositions = Sets.newLinkedHashSet(this.foldingRegionProvider.getFoldingRegions(this.editor.getDocument()));
            Annotation[] newRegions = this.mergeFoldingRegions(foldedPositions, projectionAnnotationModel);
            this.updateFoldingRegions(allowCollapse, projectionAnnotationModel, foldedPositions, newRegions);
        }
    }

    protected Annotation[] mergeFoldingRegions(Collection<FoldedPosition> foldedPositions, ProjectionAnnotationModel projectionAnnotationModel) {
        ArrayList<Annotation> deletions = new ArrayList<Annotation>();
        Iterator iterator = projectionAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof ProjectionAnnotation) || foldedPositions.remove(position = projectionAnnotationModel.getPosition(annotation))) continue;
            deletions.add(annotation);
        }
        return deletions.toArray(new Annotation[deletions.size()]);
    }

    protected void updateFoldingRegions(boolean allowCollapse, ProjectionAnnotationModel model, Collection<FoldedPosition> foldedPositions, Annotation[] deletions) {
        HashMap additionsMap = Maps.newHashMap();
        for (FoldedPosition foldedPosition : foldedPositions) {
            this.addProjectionAnnotation(allowCollapse, foldedPosition, additionsMap);
        }
        if (deletions.length != 0 || additionsMap.size() != 0) {
            model.modifyAnnotations(deletions, (Map)additionsMap, new Annotation[0]);
        }
    }

    protected void addProjectionAnnotation(boolean allowCollapse, Position foldingRegion, Map<ProjectionAnnotation, Position> additionsMap) {
        boolean collapse = allowCollapse && foldingRegion instanceof DefaultFoldedPosition && ((DefaultFoldedPosition)foldingRegion).isInitiallyFolded();
        ProjectionAnnotation projectionAnnotation = this.createProjectionAnnotation(collapse, foldingRegion);
        additionsMap.put(projectionAnnotation, foldingRegion);
    }

    protected ProjectionAnnotation createProjectionAnnotation(boolean isCollapsed, Position foldedRegion) {
        return new ProjectionAnnotation(isCollapsed);
    }

    public class ProjectionChangeListener
    implements IProjectionListener {
        private ProjectionViewer projectionViewer;

        public ProjectionChangeListener(ProjectionViewer viewer) {
            Assert.isLegal((viewer != null ? 1 : 0) != 0);
            this.projectionViewer = viewer;
            this.projectionViewer.addProjectionListener((IProjectionListener)this);
        }

        public void dispose() {
            if (this.projectionViewer != null) {
                this.projectionViewer.removeProjectionListener((IProjectionListener)this);
                this.projectionViewer = null;
            }
        }

        public void projectionEnabled() {
            DefaultFoldingStructureProvider.this.handleProjectionEnabled();
        }

        public void projectionDisabled() {
            DefaultFoldingStructureProvider.this.handleProjectionDisabled();
        }
    }
}

