/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.ActionUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.BooleanPrefAction;
import org.eclipse.egit.ui.internal.dialogs.HyperlinkSourceViewer;
import org.eclipse.egit.ui.internal.history.CommitNavigationListener;
import org.eclipse.egit.ui.internal.history.FormatJob;
import org.eclipse.egit.ui.internal.history.GitCommitReference;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension2;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

class CommitMessageViewer
extends HyperlinkSourceViewer {
    static final String HEADER_CONTENT_TYPE = "__egit_commit_msg_header";
    static final String FOOTER_CONTENT_TYPE = "__egit_commit_msg_footer";
    private final ListenerList navListeners = new ListenerList();
    private final IPropertyChangeListener listener;
    private final IPropertyChangeListener themeListener;
    private Repository db;
    private PlotCommit<?> commit;
    private boolean fill;
    private FormatJob formatJob;
    private final IWorkbenchPartSite partSite;
    private List<Ref> allRefs;
    private ListenerHandle refsChangedListener;
    private BooleanPrefAction showTagSequencePrefAction;
    private BooleanPrefAction showBranchSequencePrefAction;
    private BooleanPrefAction wrapCommentsPrefAction;
    private BooleanPrefAction fillParagraphsPrefAction;

    CommitMessageViewer(Composite parent, IWorkbenchPartSite partSite) {
        super(parent, null, 8);
        this.partSite = partSite;
        StyledText t = this.getTextWidget();
        t.setFont(UIUtils.getFont("org.eclipse.egit.ui.CommitMessageFont"));
        this.setTextDoubleClickStrategy((ITextDoubleClickStrategy)new DefaultTextDoubleClickStrategy(), "__dftl_partition_content_type");
        this.activatePlugins();
        this.listener = event -> {
            String property = event.getProperty();
            if ("resourcehistory_fill_comment_paragraph".equals(property)) {
                this.setFill((Boolean)event.getNewValue());
            } else if ("HistoryView_ShowTagSequence".equals(property) || "HistoryView_ShowBranchSequence".equals(property) || "date_format".equals(property) || "date_format_choice".equals(property)) {
                this.format();
            }
        };
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.addPropertyChangeListener(this.listener);
        this.fill = store.getBoolean("resourcehistory_fill_comment_paragraph");
        this.themeListener = event -> {
            String property = event.getProperty();
            if ("CHANGE_CURRENT_THEME".equals(property) || "org.eclipse.egit.ui.CommitMessageFont".equals(property)) {
                Font themeFont = UIUtils.getFont("org.eclipse.egit.ui.CommitMessageFont");
                this.async(() -> this.setFont(themeFont));
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeListener);
        IAction selectAll = ActionUtils.createGlobalAction(ActionFactory.SELECT_ALL, () -> this.doOperation(7), () -> this.canDoOperation(7));
        IAction copy = ActionUtils.createGlobalAction(ActionFactory.COPY, () -> this.doOperation(4), () -> this.canDoOperation(4));
        ActionUtils.setGlobalActions(this.getControl(), copy, selectAll);
        MenuManager mgr = new MenuManager();
        Control c = this.getControl();
        c.setMenu(mgr.createContextMenu(c));
        IPersistentPreferenceStore pstore = (IPersistentPreferenceStore)store;
        this.showBranchSequencePrefAction = new BooleanPrefAction(pstore, "HistoryView_ShowBranchSequence", UIText.ResourceHistory_ShowBranchSequence){

            @Override
            protected void apply(boolean value) {
            }
        };
        mgr.add((IAction)this.showBranchSequencePrefAction);
        this.showTagSequencePrefAction = new BooleanPrefAction(pstore, "HistoryView_ShowTagSequence", UIText.ResourceHistory_ShowTagSequence){

            @Override
            protected void apply(boolean value) {
            }
        };
        mgr.add((IAction)this.showTagSequencePrefAction);
        this.wrapCommentsPrefAction = new BooleanPrefAction(pstore, "resourcehistory_show_comment_wrap", UIText.ResourceHistory_toggleCommentWrap){

            @Override
            protected void apply(boolean value) {
            }
        };
        mgr.add((IAction)this.wrapCommentsPrefAction);
        this.fillParagraphsPrefAction = new BooleanPrefAction(pstore, "resourcehistory_fill_comment_paragraph", UIText.ResourceHistory_toggleCommentFill){

            @Override
            protected void apply(boolean value) {
            }
        };
        mgr.add((IAction)this.fillParagraphsPrefAction);
    }

    void addDoneListenerToFormatJob() {
        this.formatJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                StyledText text = CommitMessageViewer.this.getTextWidget();
                if (text == null || text.isDisposed()) {
                    return;
                }
                final FormatJob.FormatResult result = ((FormatJob)event.getJob()).getFormatResult();
                text.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CommitMessageViewer.this.applyFormatJobResultInUI(result);
                    }
                });
            }
        });
    }

    @Override
    protected void handleJFacePreferencesChange(PropertyChangeEvent event) {
        if ("org.eclipse.jface.textfont".equals(event.getProperty())) {
            Font jFaceFont;
            Font themeFont = UIUtils.getFont("org.eclipse.egit.ui.CommitMessageFont");
            if (themeFont.equals((Object)(jFaceFont = JFaceResources.getTextFont()))) {
                this.setFont(jFaceFont);
            }
        } else {
            super.handleJFacePreferencesChange(event);
        }
    }

    @Override
    protected void handleDispose() {
        if (this.formatJob != null) {
            this.formatJob.cancel();
            this.formatJob = null;
        }
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.listener);
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.themeListener);
        if (this.refsChangedListener != null) {
            this.refsChangedListener.remove();
        }
        this.refsChangedListener = null;
        this.showBranchSequencePrefAction.dispose();
        this.showTagSequencePrefAction.dispose();
        this.wrapCommentsPrefAction.dispose();
        this.fillParagraphsPrefAction.dispose();
        super.handleDispose();
    }

    void addCommitNavigationListener(CommitNavigationListener l) {
        this.navListeners.add((Object)l);
    }

    void removeCommitNavigationListener(CommitNavigationListener l) {
        this.navListeners.remove((Object)l);
    }

    public void setInput(Object input) {
        if (input == this.commit) {
            return;
        }
        this.commit = (PlotCommit)input;
        if (this.refsChangedListener != null) {
            this.refsChangedListener.remove();
            this.refsChangedListener = null;
        }
        if (this.db != null) {
            this.allRefs = CommitMessageViewer.getBranches(this.db);
            this.refsChangedListener = this.db.getListenerList().addRefsChangedListener(new RefsChangedListener(){

                public void onRefsChanged(RefsChangedEvent event) {
                    CommitMessageViewer.this.allRefs = CommitMessageViewer.getBranches(CommitMessageViewer.this.db);
                }
            });
        }
        this.format();
    }

    public Object getInput() {
        return this.commit;
    }

    void setRepository(Repository repository) {
        this.db = repository;
    }

    private static List<Ref> getBranches(Repository repo) {
        ArrayList<Ref> ref = new ArrayList<Ref>();
        try {
            RefDatabase refDb = repo.getRefDatabase();
            ref.addAll(refDb.getRefsByPrefix("refs/heads/"));
            ref.addAll(refDb.getRefsByPrefix("refs/remotes/"));
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        return ref;
    }

    private Repository getRepository() {
        if (this.db == null) {
            throw new IllegalStateException("Repository has not been set");
        }
        return this.db;
    }

    private void format() {
        if (this.db == null || this.commit == null) {
            this.setDocument((IDocument)new Document(""));
            return;
        }
        if (this.formatJob != null && this.formatJob.getState() != 0) {
            this.formatJob.cancel();
        }
        this.scheduleFormatJob();
    }

    private void scheduleFormatJob() {
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)AdapterUtils.adapt((Object)this.partSite, IWorkbenchSiteProgressService.class);
        if (siteService == null) {
            return;
        }
        FormatJob.FormatRequest formatRequest = new FormatJob.FormatRequest(this.getRepository(), this.commit, this.fill, this.allRefs);
        this.formatJob = new FormatJob(formatRequest);
        this.addDoneListenerToFormatJob();
        siteService.schedule((Job)this.formatJob, 0L, true);
    }

    private void applyFormatJobResultInUI(FormatJob.FormatResult formatResult) {
        StyledText text = this.getTextWidget();
        if (!UIUtils.isUsable((Control)text)) {
            return;
        }
        this.setDocument((IDocument)new CommitDocument(formatResult));
    }

    private void setFill(boolean fill) {
        this.fill = fill;
        this.format();
    }

    private class CommitDocument
    extends Document {
        private final List<IHyperlink> hyperlinks;
        private final int headerEnd;
        private final int footerStart;

        public CommitDocument(FormatJob.FormatResult format) {
            super(format.getCommitInfo());
            this.headerEnd = format.getHeaderEnd();
            this.footerStart = format.getFooterStart();
            List<GitCommitReference> knownLinks = format.getKnownLinks();
            this.hyperlinks = new ArrayList<IHyperlink>(knownLinks.size());
            for (GitCommitReference o : knownLinks) {
                this.hyperlinks.add(new ObjectHyperlink(o));
            }
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new CommitPartitionTokenScanner(), new String[]{"__dftl_partition_content_type", CommitMessageViewer.HEADER_CONTENT_TYPE, CommitMessageViewer.FOOTER_CONTENT_TYPE});
            partitioner.connect((IDocument)this);
            this.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }

        public List<IHyperlink> getKnownHyperlinks() {
            return this.hyperlinks;
        }

        public int getHeaderEnd() {
            return this.headerEnd;
        }

        public int getFooterStart() {
            return this.footerStart;
        }
    }

    private static class CommitPartitionTokenScanner
    implements IPartitionTokenScanner {
        private static final IToken HEADER = new Token((Object)"__egit_commit_msg_header");
        private static final IToken BODY = new Token((Object)"__dftl_partition_content_type");
        private static final IToken FOOTER = new Token((Object)"__egit_commit_msg_footer");
        private int headerEnd;
        private int footerStart;
        private int currentOffset;
        private int end;
        private int tokenStart;

        private CommitPartitionTokenScanner() {
        }

        public void setRange(IDocument document, int offset, int length) {
            if (document instanceof CommitDocument) {
                CommitDocument d = (CommitDocument)document;
                this.headerEnd = d.getHeaderEnd();
                this.footerStart = d.getFooterStart();
            } else {
                this.headerEnd = 0;
                this.footerStart = document.getLength();
            }
            this.currentOffset = offset;
            this.end = offset + length;
            this.tokenStart = -1;
        }

        public IToken nextToken() {
            this.tokenStart = this.currentOffset;
            if (this.currentOffset < this.end) {
                if (this.currentOffset < this.headerEnd) {
                    this.currentOffset = Math.min(this.headerEnd, this.end);
                    return HEADER;
                }
                if (this.currentOffset < this.footerStart) {
                    this.currentOffset = Math.min(this.footerStart, this.end);
                    return BODY;
                }
                this.currentOffset = this.end;
                return FOOTER;
            }
            return Token.EOF;
        }

        public int getTokenOffset() {
            return this.tokenStart;
        }

        public int getTokenLength() {
            return this.currentOffset - this.tokenStart;
        }

        public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
            this.setRange(document, offset, length);
        }
    }

    static class KnownHyperlinksDetector
    implements IHyperlinkDetector,
    IHyperlinkDetectorExtension2 {
        KnownHyperlinksDetector() {
        }

        public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
            IDocument document = textViewer.getDocument();
            if (document instanceof CommitDocument) {
                List<IHyperlink> knownLinks = ((CommitDocument)document).getKnownHyperlinks();
                ArrayList<IHyperlink> result = new ArrayList<IHyperlink>();
                for (IHyperlink link : knownLinks) {
                    IRegion linkRegion = link.getHyperlinkRegion();
                    if (!TextUtilities.overlaps((IRegion)linkRegion, (IRegion)region)) continue;
                    result.add(link);
                }
                if (!result.isEmpty()) {
                    return result.toArray(new IHyperlink[result.size()]);
                }
            }
            return null;
        }

        public int getStateMask() {
            return -1;
        }
    }

    private class ObjectHyperlink
    implements IHyperlink {
        private final GitCommitReference link;

        public ObjectHyperlink(GitCommitReference link) {
            this.link = link;
        }

        public IRegion getHyperlinkRegion() {
            return this.link.getRegion();
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return this.link.getTarget().name();
        }

        public void open() {
            Object[] objectArray = CommitMessageViewer.this.navListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object l = objectArray[n2];
                ((CommitNavigationListener)l).showCommit(this.link.getTarget());
                ++n2;
            }
        }
    }
}

