/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.client.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.eclipse.osee.activity.api.ActivityLogEndpoint;
import org.eclipse.osee.define.api.DataRightsEndpoint;
import org.eclipse.osee.define.api.DefineBranchEndpointApi;
import org.eclipse.osee.define.api.GitEndpoint;
import org.eclipse.osee.define.api.ImportEndpoint;
import org.eclipse.osee.define.api.RenderEndpoint;
import org.eclipse.osee.framework.core.OseeApiBase;
import org.eclipse.osee.framework.core.access.IAccessControlService;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.server.ide.api.SessionEndpoint;
import org.eclipse.osee.framework.server.ide.api.client.ClientEndpoint;
import org.eclipse.osee.mail.api.MailEndpoint;
import org.eclipse.osee.orcs.rest.client.OseeClient;
import org.eclipse.osee.orcs.rest.client.QueryBuilder;
import org.eclipse.osee.orcs.rest.client.internal.search.PredicateFactory;
import org.eclipse.osee.orcs.rest.client.internal.search.PredicateFactoryImpl;
import org.eclipse.osee.orcs.rest.client.internal.search.QueryBuilderImpl;
import org.eclipse.osee.orcs.rest.client.internal.search.QueryExecutor;
import org.eclipse.osee.orcs.rest.client.internal.search.QueryOptions;
import org.eclipse.osee.orcs.rest.model.ApplicabilityEndpoint;
import org.eclipse.osee.orcs.rest.model.ApplicabilityUiEndpoint;
import org.eclipse.osee.orcs.rest.model.ArtifactEndpoint;
import org.eclipse.osee.orcs.rest.model.BranchEndpoint;
import org.eclipse.osee.orcs.rest.model.DatastoreEndpoint;
import org.eclipse.osee.orcs.rest.model.IndexerEndpoint;
import org.eclipse.osee.orcs.rest.model.OrcsWriterEndpoint;
import org.eclipse.osee.orcs.rest.model.ResourcesEndpoint;
import org.eclipse.osee.orcs.rest.model.TransactionEndpoint;
import org.eclipse.osee.orcs.rest.model.TypesEndpoint;
import org.eclipse.osee.orcs.rest.model.search.artifact.Predicate;
import org.eclipse.osee.orcs.rest.model.search.artifact.RequestType;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchRequest;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResponse;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResult;

public class OseeClientImpl
extends OseeApiBase
implements OseeClient,
QueryExecutor {
    private PredicateFactory predicateFactory;

    public void start(Map<String, Object> properties) {
        this.predicateFactory = new PredicateFactoryImpl();
    }

    public void stop() {
        this.predicateFactory = null;
    }

    @Override
    public QueryBuilder createQueryBuilder(BranchId branch) {
        QueryOptions options = new QueryOptions();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        return new QueryBuilderImpl(branch, predicates, options, this.predicateFactory, this);
    }

    @Override
    public int getCount(BranchId branch, List<Predicate> predicates, QueryOptions options) {
        SearchResponse result = this.performSearch(RequestType.COUNT, branch, predicates, options);
        return result.getTotal();
    }

    @Override
    public SearchResult getResults(RequestType request, BranchId branch, List<Predicate> predicates, QueryOptions options) {
        SearchResponse result = this.performSearch(request, branch, predicates, options);
        return result;
    }

    private SearchResponse performSearch(RequestType requestType, BranchId branch, List<Predicate> predicates, QueryOptions options) {
        Conditions.checkNotNull((Object)requestType, (String)"RequestType");
        int fromTx = 0;
        if (options.isHistorical()) {
            fromTx = options.getFromTransaction().getId().intValue();
        }
        boolean includeDeleted = false;
        if (options.areDeletedIncluded()) {
            includeDeleted = true;
        }
        SearchRequest params = new SearchRequest(branch, predicates, requestType, fromTx, includeDeleted);
        WebTarget target = this.jaxRsApi().newTarget("orcs/branch/" + branch.getIdString() + "/artifact/search/v1");
        return (SearchResponse)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)params), SearchResponse.class);
    }

    @Override
    public BranchEndpoint getBranchEndpoint() {
        return this.getOrcsEndpoint(BranchEndpoint.class);
    }

    @Override
    public TransactionEndpoint getTransactionEndpoint() {
        return this.getOrcsEndpoint(TransactionEndpoint.class);
    }

    @Override
    public TypesEndpoint getTypesEndpoint() {
        return this.getOrcsEndpoint(TypesEndpoint.class);
    }

    @Override
    public IndexerEndpoint getIndexerEndpoint() {
        return this.getOrcsEndpoint(IndexerEndpoint.class);
    }

    @Override
    public ClientEndpoint getClientEndpoint() {
        return (ClientEndpoint)this.jaxRsApi().newProxy("ide", ClientEndpoint.class);
    }

    @Override
    public ResourcesEndpoint getResourcesEndpoint() {
        return this.getOrcsEndpoint(ResourcesEndpoint.class);
    }

    @Override
    public DatastoreEndpoint getDatastoreEndpoint() {
        return this.getOrcsEndpoint(DatastoreEndpoint.class);
    }

    @Override
    public RenderEndpoint getRenderEndpoint() {
        return this.getDefineEndpoint(RenderEndpoint.class);
    }

    @Override
    public DataRightsEndpoint getDataRightsEndpoint() {
        return this.getDefineEndpoint(DataRightsEndpoint.class);
    }

    @Override
    public ImportEndpoint getImportEndpoint() {
        return this.getDefineEndpoint(ImportEndpoint.class);
    }

    @Override
    public OrcsWriterEndpoint getOrcsWriterEndpoint() {
        return this.getOrcsEndpoint(OrcsWriterEndpoint.class);
    }

    @Override
    public ApplicabilityEndpoint getApplicabilityEndpoint(BranchId branch) {
        return this.getOrcsBranchEndpoint(ApplicabilityEndpoint.class, branch);
    }

    @Override
    public ApplicabilityUiEndpoint getApplicabilityUiEndpoint() {
        return this.getOrcsEndpoint(ApplicabilityUiEndpoint.class);
    }

    @Override
    public ArtifactEndpoint getArtifactEndpoint(BranchId branch) {
        return this.getOrcsBranchEndpoint(ArtifactEndpoint.class, branch);
    }

    @Override
    public ActivityLogEndpoint getActivityLogEndpoint() {
        return (ActivityLogEndpoint)this.jaxRsApi().newProxy("", ActivityLogEndpoint.class);
    }

    @Override
    public DefineBranchEndpointApi getDefineBranchEndpoint() {
        return this.getDefineEndpoint(DefineBranchEndpointApi.class);
    }

    @Override
    public MailEndpoint getMailEndpoint() {
        return this.getOrcsEndpoint(MailEndpoint.class);
    }

    private <T> T getOrcsBranchEndpoint(Class<T> clazz, BranchId branch) {
        return (T)this.jaxRsApi().newProxy("orcs/branch/" + branch.getIdString(), clazz);
    }

    private <T> T getDefineEndpoint(Class<T> clazz) {
        return (T)this.jaxRsApi().newProxy("define", clazz);
    }

    private <T> T getOrcsEndpoint(Class<T> clazz) {
        return (T)this.jaxRsApi().newProxy("orcs", clazz);
    }

    @Override
    public SessionEndpoint getSessionEndpoint() {
        return (SessionEndpoint)this.jaxRsApi().newProxy("ide", SessionEndpoint.class);
    }

    @Override
    public GitEndpoint getGitEndpoint() {
        return this.getDefineEndpoint(GitEndpoint.class);
    }

    @Override
    public String loadAttributeValue(Integer attrId, TransactionId transactionId, ArtifactToken artifact) {
        String url = String.format("orcs/branch/%s/artifact/%s/attribute/%s/version/%s/text", artifact.getBranchIdString(), artifact.getIdString(), attrId, transactionId.getIdString());
        WebTarget target = this.jaxRsApi().newTarget(url);
        return (String)target.request(new String[]{"text/plain"}).get(String.class);
    }

    public IAccessControlService getAccessControlService() {
        throw new UnsupportedOperationException("Not supported yet");
    }
}

