/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public abstract class WorldSearchItem {
    private final String name;
    protected static final Set<Artifact> EMPTY_SET = new HashSet<Artifact>();
    protected boolean cancelled = false;
    private LoadView loadView;
    private final KeyedImage oseeImage;

    public WorldSearchItem(String name, LoadView loadView, boolean cancelled, KeyedImage oseeImage) {
        this.name = name;
        this.loadView = loadView;
        this.cancelled = cancelled;
        this.oseeImage = oseeImage;
    }

    public WorldSearchItem(String name, LoadView loadView, KeyedImage oseeImage) {
        this(name, loadView, false, oseeImage);
    }

    public WorldSearchItem(WorldSearchItem worldSearchItem, KeyedImage oseeImage) {
        this(worldSearchItem.name, worldSearchItem.loadView, worldSearchItem.cancelled, oseeImage);
    }

    public abstract WorldSearchItem copy();

    public String getName() {
        return this.name;
    }

    public String getSelectedName(SearchType searchType) {
        return this.getName();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public LoadView getLoadView() {
        return this.loadView;
    }

    public void setLoadView(LoadView loadView) {
        this.loadView = loadView;
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return ex.getLocalizedMessage();
        }
    }

    public Image getImage() {
        return this.oseeImage == null ? null : ImageManager.getImage((KeyedImage)this.oseeImage);
    }

    public KeyedImage getOseeImage() {
        return this.oseeImage;
    }

    public static enum LoadView {
        TaskEditor,
        WorldEditor,
        None;

    }

    public static enum SearchType {
        Search,
        ReSearch;

    }
}

