/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.Collection;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldUISearchItem;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.UserListDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public abstract class UserSearchItem
extends WorldUISearchItem {
    protected AtsUser user;
    protected AtsUser selectedUser;
    private Active active = Active.Active;
    private boolean useCurrentUser = true;

    public UserSearchItem(String name, AtsUser user) {
        super(name);
        this.user = user;
    }

    public UserSearchItem(String name, AtsUser user, KeyedImage oseeImage) {
        super(name, oseeImage);
        this.user = user;
    }

    public UserSearchItem(UserSearchItem userSearchItem) {
        this(userSearchItem, null);
    }

    public UserSearchItem(UserSearchItem userSearchItem, KeyedImage oseeImage) {
        super(userSearchItem, oseeImage);
        this.user = userSearchItem.user;
        this.selectedUser = userSearchItem.selectedUser;
        this.useCurrentUser = userSearchItem.useCurrentUser;
    }

    protected AtsUser getUser() {
        if (this.user == null && this.useCurrentUser) {
            this.user = AtsApiService.get().getUserService().getCurrentUser();
        }
        return this.user;
    }

    @Override
    public String getSelectedName(WorldSearchItem.SearchType searchType) {
        return String.format("%s - %s", super.getSelectedName(searchType), this.getUserSearchName());
    }

    public String getUserSearchName() {
        if (this.getUser() != null) {
            return this.getUser().getName();
        }
        if (this.selectedUser != null) {
            return this.selectedUser.getName();
        }
        return "";
    }

    @Override
    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        if (this.isCancelled()) {
            return EMPTY_SET;
        }
        if (this.getUser() != null) {
            return this.searchIt(this.getUser());
        }
        return this.searchIt();
    }

    protected Collection<Artifact> searchIt(AtsUser user) {
        return EMPTY_SET;
    }

    private Collection<Artifact> searchIt() {
        if (this.isCancelled()) {
            return EMPTY_SET;
        }
        if (this.selectedUser != null) {
            return this.searchIt(this.selectedUser);
        }
        return EMPTY_SET;
    }

    @Override
    public void performUI(WorldSearchItem.SearchType searchType) {
        super.performUI(searchType);
        if (this.getUser() != null) {
            return;
        }
        if (searchType == WorldSearchItem.SearchType.ReSearch && this.selectedUser != null) {
            return;
        }
        UserListDialog ld = new UserListDialog(Displays.getActiveShell(), "Select User", this.active);
        int result = ld.open();
        if (result == 0) {
            this.selectedUser = AtsApiService.get().getUserService().getUserById((ArtifactId)ld.getSelection());
            return;
        }
        this.cancelled = true;
    }

    public void setSelectedUser(AtsUser selectedUser) {
        this.selectedUser = selectedUser;
    }

    public AtsUser getDefaultUser() {
        return this.getUser();
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserSearchItem) {
            UserSearchItem wsi = (UserSearchItem)obj;
            try {
                if (!this.getClass().equals(obj.getClass()) || !wsi.getName().equals(this.getName()) || wsi.getLoadView() != this.getLoadView()) {
                    return false;
                }
            }
            catch (OseeCoreException oseeCoreException) {
                return false;
            }
            return this.getDefaultUser() == null || wsi.getDefaultUser() == null || wsi.getDefaultUser().equals((Object)this.getDefaultUser());
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getName().hashCode() + (this.getDefaultUser() != null ? this.getDefaultUser().hashCode() : 0) * 13;
        }
        catch (OseeCoreException oseeCoreException) {
            return 0;
        }
    }

    @Override
    public WorldSearchItem copy() {
        return null;
    }

    @Override
    public Image getImage() {
        Image image = super.getImage();
        if (image != null) {
            return image;
        }
        return ImageManager.getImage((KeyedImage)FrameworkImage.USER);
    }

    public void setActive(Active active) {
        this.active = active;
    }

    public void setUseCurrentUser(boolean useCurrentUser) {
        this.useCurrentUser = useCurrentUser;
    }
}

