/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.ats.api.query.IAtsQuery;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldUISearchItem;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class ShowOpenWorkflowsByReviewType
extends WorldUISearchItem {
    private final boolean showFinished;
    private final boolean showWorkflow;
    private final WorkItemType workItemType;

    public ShowOpenWorkflowsByReviewType(String displayName, WorkItemType workItemType, boolean showFinished, boolean showWorkflow, KeyedImage oseeImage) {
        super(displayName, oseeImage);
        Conditions.checkNotNull((Object)workItemType, (String)"workItemType");
        this.workItemType = workItemType;
        this.showFinished = showFinished;
        this.showWorkflow = showWorkflow;
        Conditions.assertTrue((boolean)Arrays.asList(WorkItemType.Review, WorkItemType.DecisionReview, WorkItemType.PeerReview).contains(workItemType), (String)"WorkItemType must be a review type, not %s", (Object[])new Object[]{workItemType.getDisplayName()});
    }

    public ShowOpenWorkflowsByReviewType(ShowOpenWorkflowsByReviewType showOpenWorkflowsByArtifactType) {
        super(showOpenWorkflowsByArtifactType);
        this.showFinished = showOpenWorkflowsByArtifactType.showFinished;
        this.showWorkflow = showOpenWorkflowsByArtifactType.showWorkflow;
        this.workItemType = showOpenWorkflowsByArtifactType.workItemType;
    }

    @Override
    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        IAtsQuery query = AtsApiService.get().getQueryService().createQuery(this.workItemType, new WorkItemType[0]);
        if (!this.showFinished) {
            query.andStateType(new StateType[]{StateType.Working});
        }
        if (this.showWorkflow) {
            return Collections.castAll((Collection)query.createFilter().getTeamWorkflows());
        }
        return Collections.castAll((Collection)query.getResultArtifacts().getList());
    }

    @Override
    public WorldUISearchItem copy() {
        return new ShowOpenWorkflowsByReviewType(this);
    }
}

