/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.query.AtsSearchUserType;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.search.widget.ActionableItemSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.InsertionActivitySearchWidget;
import org.eclipse.osee.ats.ide.search.widget.InsertionSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.ProgramSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.ReviewTypeSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.StateNameSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.StateTypeSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.TeamDefinitionSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.TitleSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.UserSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.UserTypeSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.VersionSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.WorkItemTypeSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.WorkPackageSearchWidget;
import org.eclipse.osee.ats.ide.util.widgets.dialog.VersionLabelProvider;
import org.eclipse.osee.ats.ide.world.IWorldEditorParameterProvider;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IDynamicWidgetLayoutListener;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class WorldEditorParameterSearchItem
extends WorldSearchItem
implements IWorldEditorParameterProvider,
IDynamicWidgetLayoutListener,
IXWidgetOptionResolver {
    private XNavigateComposite.TableLoadOption[] tableLoadOptions;
    protected final Map<String, XWidget> xWidgets = new HashMap<String, XWidget>();
    protected StringBuilder xmlSb;
    private final Pattern displayName = Pattern.compile("displayName=\"(.*?)\"");
    private String shortName = "";
    private final List<String> widgetOrder = new LinkedList<String>();
    private static List<WorkItemType> GOAL_SPRINT_BACKLOG_WORKITEMTYPES = Arrays.asList(WorkItemType.AgileBacklog, WorkItemType.AgileSprint, WorkItemType.Goal);
    private static List<WorkItemType> TEAM_DEF_WORKITEMTYPES = null;
    private TitleSearchWidget title;
    private StateTypeSearchWidget stateType;
    private UserSearchWidget user;
    private WorkItemTypeSearchWidget workItemType;
    private TeamDefinitionSearchWidget teamDef;
    private ActionableItemSearchWidget ai;
    private VersionSearchWidget version;
    private StateNameSearchWidget stateName;
    private ProgramSearchWidget program;
    private InsertionSearchWidget insertion;
    private InsertionActivitySearchWidget insertionFeature;
    private WorkPackageSearchWidget workPackage;
    private UserTypeSearchWidget userType;
    private ReviewTypeSearchWidget reviewType;

    static {
        TEAM_DEF_WORKITEMTYPES = new LinkedList<WorkItemType>();
        WorkItemType[] workItemTypeArray = WorkItemType.values();
        int n = workItemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorkItemType type = workItemTypeArray[n2];
            if (!GOAL_SPRINT_BACKLOG_WORKITEMTYPES.contains(type)) {
                TEAM_DEF_WORKITEMTYPES.add(type);
            }
            ++n2;
        }
    }

    public WorldEditorParameterSearchItem(String name, KeyedImage oseeImage) {
        super(name, WorldSearchItem.LoadView.WorldEditor, oseeImage);
    }

    public WorldEditorParameterSearchItem(WorldSearchItem worldSearchItem, KeyedImage oseeImage) {
        super(worldSearchItem, oseeImage);
    }

    @Override
    public String getParameterXWidgetXml() {
        String xml = String.valueOf(this.xmlSb.toString()) + "</xWidgets>";
        return xml;
    }

    public Result isParameterSelectionValid() {
        try {
            if (this.getUserType() != null && this.getUserType().get() == AtsSearchUserType.Assignee && this.getAi() != null && this.getAi().get() != null && !this.getAi().get().isEmpty() && this.getTeamDef() != null && this.getTeamDef().get() != null && !this.getTeamDef().get().isEmpty()) {
                return new Result("Actionable Item(s) and Team Definition(s) are not compatible selections.");
            }
            if (this.workItemType != null && this.workItemType.get().isEmpty()) {
                return new Result("You must select a workflow type.");
            }
            if (this.teamDef != null && this.teamDef.get() != null && this.teamDef.get().isEmpty() && this.ai != null && this.ai.get().isEmpty() && this.isTeamDefWorkItemTypesSelected()) {
                return new Result("You must select either Actionable Item(s) or Team Definition(s).");
            }
            return Result.TrueResult;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return new Result("Exception: " + ex.getLocalizedMessage());
        }
    }

    private synchronized List<WorkItemType> getTeamDefWorkItemTypes() {
        return TEAM_DEF_WORKITEMTYPES;
    }

    private boolean isTeamDefWorkItemTypesSelected() {
        List<WorkItemType> teamDefWorkItemTypes = this.getTeamDefWorkItemTypes();
        boolean sel = !Collections.setIntersection(teamDefWorkItemTypes, this.workItemType.get()).isEmpty();
        return sel;
    }

    @Override
    public void run(WorldEditor worldEditor, WorldSearchItem.SearchType searchType, boolean forcePend) {
        boolean pend = Arrays.asList(this.tableLoadOptions).contains(XNavigateComposite.TableLoadOption.ForcePend) || forcePend;
        worldEditor.getWorldComposite().getXViewer().setForcePend(pend);
    }

    public String[] getWidgetOptions(XWidgetRendererItem widgetData) {
        return null;
    }

    @Override
    public void setCustomizeData(CustomizeData customizeData) {
    }

    @Override
    public void setTableLoadOptions(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        this.tableLoadOptions = tableLoadOptions;
    }

    public void setupSearch() {
    }

    public void checkOrStartXmlSb() {
        if (this.xmlSb == null) {
            this.xmlSb = new StringBuilder("<xWidgets>");
        }
    }

    public void addWidgetXml(String widgetXml) {
        this.checkOrStartXmlSb();
        this.xmlSb.append(widgetXml);
        String displayName = this.getDisplayName(widgetXml);
        this.xWidgets.put(displayName, null);
        this.widgetOrder.add(displayName);
    }

    private String getDisplayName(String widgetXml) {
        Matcher matcher = this.displayName.matcher(widgetXml);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new OseeArgumentException("WidgetXml must include displayName; Not found in [%s]", new Object[]{widgetXml});
    }

    public void widgetCreated(XWidget widget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        this.xWidgets.put(widget.getLabel(), widget);
        if (widget.getLabel().equals("Version")) {
            this.getVersion().setup(widget);
            this.getVersion().setupTeamDef((XWidget)this.getTeamDef().getWidget());
        } else if (widget.getLabel().equals("State Name")) {
            this.getStateName().setup(widget);
        } else if (widget.getLabel().equals("State Type")) {
            this.getStateType().setup(widget);
            this.getStateType().set(StateType.Working);
        } else if (widget.getLabel().equals("Program")) {
            this.getProgram().setup(widget);
        } else if (widget.getLabel().equals("Insertion")) {
            this.getInsertion().setup(widget);
            this.getInsertion().setProgramWidget(this.getProgram());
        } else if (widget.getLabel().equals("Insertion Activity")) {
            this.getInsertionActivity().setup(widget);
            this.getInsertionActivity().setInsertionWidget(this.getInsertion());
        } else if (widget.getLabel().equals("Work Package")) {
            this.getWorkPackage().setup(widget);
            this.getWorkPackage().setInsertionActivityWidget(this.getInsertionActivity());
        } else if (widget.getLabel().equals("User")) {
            this.getUser().setup(widget);
        } else if (widget.getLabel().equals("User Type")) {
            this.getUserType().setup(widget);
        } else if (widget.getLabel().equals("Version")) {
            this.getVersion().setup(widget);
        } else if (widget.getLabel().equals("Review Type")) {
            this.getReviewType().setup(widget);
        }
    }

    @Override
    public String getSelectedName(WorldSearchItem.SearchType searchType) {
        return Strings.truncate((String)this.getShortName(), (int)80, (boolean)true);
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getShortNamePrefix() {
        return "";
    }

    public void widgetCreating(XWidget widget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        if (widget.getLabel().equals("Version")) {
            widget.setLabelProvider((ILabelProvider)new VersionLabelProvider());
        } else if (widget.getLabel().equals("State Name")) {
            widget.setUseToStringSorter(true);
        } else if (widget.getLabel().equals("Program")) {
            widget.setUseToStringSorter(true);
        } else if (widget.getLabel().equals("Insertion")) {
            widget.setUseToStringSorter(true);
        } else if (widget.getLabel().equals("Insertion Activity")) {
            widget.setUseToStringSorter(true);
        } else if (widget.getLabel().equals("Work Package")) {
            widget.setUseToStringSorter(true);
        } else if (widget.getLabel().equals("User")) {
            widget.setUseToStringSorter(true);
        }
    }

    @Override
    public IDynamicWidgetLayoutListener getDynamicWidgetLayoutListener() {
        return null;
    }

    @Override
    public IAtsVersion getTargetedVersionArtifact() {
        return null;
    }

    @Override
    public void createParametersSectionCompleted(IManagedForm managedForm, Composite mainComp) {
    }

    public String getBeginComposite(int beginComposite) {
        return beginComposite > 0 ? String.format(" beginComposite=\"%d\" ", beginComposite) : "";
    }

    public Map<String, XWidget> getxWidgets() {
        return this.xWidgets;
    }

    public TitleSearchWidget getTitle() {
        if (this.title == null) {
            this.title = new TitleSearchWidget(this);
        }
        return this.title;
    }

    public StateTypeSearchWidget getStateType() {
        if (this.stateType == null) {
            this.stateType = new StateTypeSearchWidget(this);
        }
        return this.stateType;
    }

    public UserSearchWidget getUser() {
        if (this.user == null) {
            this.user = new UserSearchWidget(this);
        }
        return this.user;
    }

    public boolean isReviewSearch() {
        return false;
    }

    public WorkItemTypeSearchWidget getWorkItemType() {
        if (this.workItemType == null) {
            this.workItemType = new WorkItemTypeSearchWidget(this);
            this.workItemType.setReviewSearch(this.isReviewSearch());
        }
        return this.workItemType;
    }

    public TeamDefinitionSearchWidget getTeamDef() {
        if (this.teamDef == null) {
            this.teamDef = new TeamDefinitionSearchWidget(this);
        }
        return this.teamDef;
    }

    public ActionableItemSearchWidget getAi() {
        if (this.ai == null) {
            this.ai = new ActionableItemSearchWidget(this);
        }
        return this.ai;
    }

    public VersionSearchWidget getVersion() {
        if (this.version == null) {
            this.version = new VersionSearchWidget(this);
        }
        return this.version;
    }

    public StateNameSearchWidget getStateName() {
        if (this.stateName == null) {
            this.stateName = new StateNameSearchWidget(this);
        }
        return this.stateName;
    }

    public ProgramSearchWidget getProgram() {
        if (this.program == null) {
            this.program = new ProgramSearchWidget(this);
        }
        return this.program;
    }

    public InsertionSearchWidget getInsertion() {
        if (this.insertion == null) {
            this.insertion = new InsertionSearchWidget(this);
        }
        return this.insertion;
    }

    public InsertionActivitySearchWidget getInsertionActivity() {
        if (this.insertionFeature == null) {
            this.insertionFeature = new InsertionActivitySearchWidget(this);
        }
        return this.insertionFeature;
    }

    public WorkPackageSearchWidget getWorkPackage() {
        if (this.workPackage == null) {
            this.workPackage = new WorkPackageSearchWidget(this);
        }
        return this.workPackage;
    }

    public UserTypeSearchWidget getUserType() {
        if (this.userType == null) {
            this.userType = new UserTypeSearchWidget(this);
        }
        return this.userType;
    }

    public ReviewTypeSearchWidget getReviewType() {
        if (this.reviewType == null) {
            this.reviewType = new ReviewTypeSearchWidget(this);
        }
        return this.reviewType;
    }

    @Override
    public void createToolbar(IToolBarManager toolBarManager) {
    }
}

