/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.teamwf;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.action.ActionArtifactRollup;
import org.eclipse.osee.ats.ide.workflow.review.ReviewManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.IATSStateMachineArtifact;

public class TeamWorkFlowArtifact
extends AbstractWorkflowArtifact
implements IAtsTeamWorkflow,
IATSStateMachineArtifact {
    private static final Set<Integer> teamArtsWithNoAction = new HashSet<Integer>();
    private IAtsTeamDefinition teamDef;

    public TeamWorkFlowArtifact(Long id, String guid, BranchToken branch, ArtifactTypeToken artifactType) {
        super(id, guid, branch, artifactType);
    }

    public TeamWorkFlowArtifact(ArtifactTypeToken artifactType) {
        super(Lib.generateId(), null, CoreBranches.COMMON, artifactType);
    }

    @Override
    public void getSmaArtifactsOneLevel(AbstractWorkflowArtifact smaArtifact, Set<Artifact> artifacts) {
        super.getSmaArtifactsOneLevel(smaArtifact, artifacts);
        try {
            artifacts.addAll(ReviewManager.getReviews(this));
            for (IAtsTask task : AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)this)) {
                artifacts.add(AtsApiService.get().getQueryServiceIde().getArtifact(task));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    @Override
    public void save(IAtsChangeSet changes) {
        super.save(changes);
        try {
            IAtsAction parentAction = this.getParentAction();
            ActionArtifactRollup rollup = new ActionArtifactRollup(parentAction);
            rollup.resetAttributesOffChildren();
            changes.add((Object)parentAction);
        }
        catch (Exception ex) {
            OseeLog.logf(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex, (String)"Can't reset Action parent of children for [%s]", (Object[])new Object[]{this.toStringWithId()});
        }
    }

    public String getDescription() {
        try {
            return (String)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Description, "");
        }
        catch (Exception ex) {
            return "Error: " + ex.getLocalizedMessage();
        }
    }

    @Override
    public String getEditorTitle() {
        try {
            if (AtsApiService.get().getVersionService().isTeamUsesVersions(this.getTeamDefinition())) {
                IAtsVersion version = AtsApiService.get().getVersionService().getTargetedVersion((IAtsWorkItem)this);
                return String.format("%s: [%s] - %s", this.getTeamName(), version != null ? version : "Un-Targeted", this.getName());
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return super.getEditorTitle();
    }

    public void setTeamDefinition(IAtsTeamDefinition teamDef) {
        this.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.TeamDefinitionReference, teamDef);
    }

    public IAtsTeamDefinition getTeamDefinition() {
        if (this.teamDef == null) {
            ArtifactId artId = AtsApiService.get().getAttributeResolver().getSoleArtifactIdReference((IAtsObject)this, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, ArtifactId.SENTINEL);
            if (artId.isInvalid()) {
                throw new OseeArgumentException("TeamWorkflow [%s] has no Team Definition associated.", new Object[]{this.getAtsId()});
            }
            this.teamDef = (IAtsTeamDefinition)AtsApiService.get().getConfigService().getConfigurations().getIdToTeamDef().get(artId.getId());
            if (this.teamDef == null) {
                this.teamDef = (IAtsTeamDefinition)AtsApiService.get().getQueryService().getConfigItem(artId);
            }
            Conditions.checkNotNull((Object)this.teamDef, (String)String.format("TeamDef null for Team WF %s", this.toStringWithId()));
        }
        return this.teamDef;
    }

    public String getTeamName() {
        try {
            if (!this.isDeleted()) {
                return this.getTeamDefinition().getName();
            }
            return "(Deleted)";
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return "!Error";
        }
    }

    @Override
    public TeamWorkFlowArtifact getParentTeamWorkflow() {
        this.parentTeamArt = this;
        return this.parentTeamArt;
    }

    @Override
    public Artifact getParentAtsArtifact() {
        return (Artifact)this.getParentAction().getStoreObject();
    }

    @Override
    public IAtsAction getParentAction() {
        if (this.parentAction != null) {
            return this.parentAction;
        }
        List arts = this.getRelatedArtifacts(AtsRelationTypes.ActionToWorkflow_Action);
        if (arts.isEmpty()) {
            if (!teamArtsWithNoAction.contains(this.getArtId())) {
                if (!AtsUtil.isInTest()) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)String.format("Team Workflow has no parent Action [%s]", this.toStringWithId()));
                }
                teamArtsWithNoAction.add(this.getArtId());
            }
        } else if (arts.size() > 1) {
            throw new OseeStateException("Team [%s] has multiple parent Actions", new Object[]{this.toStringWithId()});
        }
        if (arts.size() > 0) {
            this.parentAction = (IAtsAction)arts.iterator().next();
        }
        return this.parentAction;
    }

    @Override
    public AbstractWorkflowArtifact getParentAWA() {
        return null;
    }

    @Override
    public double getManHrsPerDayPreference() {
        try {
            return this.getHoursPerWorkDayFromItemAndChildren(this.getTeamDefinition());
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return super.getManHrsPerDayPreference();
        }
    }

    private double getHoursPerWorkDayFromItemAndChildren(IAtsTeamDefinition teamDef) {
        try {
            double manDayHours = 0.0;
            Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(this.getTeamDefinition());
            if (artifact != null) {
                manDayHours = (Double)artifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.HoursPerWorkDay, (Object)0.0);
            }
            if (manDayHours == 0.0 && AtsApiService.get().getTeamDefinitionService().getParentTeamDef(teamDef) != null) {
                return this.getHoursPerWorkDayFromItemAndChildren((IAtsTeamDefinition)AtsApiService.get().getTeamDefinitionService().getParentTeamDef(teamDef));
            }
            return 8.0;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return 0.0;
        }
    }

    public BranchToken getWorkingBranchForceCacheUpdate() {
        return AtsApiService.get().getBranchService().getWorkingBranch((IAtsTeamWorkflow)this, true);
    }

    public BranchToken getWorkingBranch() {
        return AtsApiService.get().getBranchService().getWorkingBranch((IAtsTeamWorkflow)this);
    }

    public Set<IAtsActionableItem> getActionableItems() {
        return AtsApiService.get().getActionableItemService().getActionableItems((IAtsWorkItem)this);
    }
}

