/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.task.AtsTaskEndpointApi;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.JaxAtsTaskFactory;
import org.eclipse.osee.ats.api.task.JaxAtsTasks;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskDataFactory;
import org.eclipse.osee.ats.api.task.NewTaskDatas;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskNameProviderToken;
import org.eclipse.osee.ats.api.task.create.IAtsChangeReportTaskNameProvider;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.task.AbstractAtsTaskServiceCore;
import org.eclipse.osee.ats.core.task.ChangeReportTaskNameProviderService;
import org.eclipse.osee.ats.core.workflow.Task;
import org.eclipse.osee.ats.ide.column.RelatedToStateColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.workflow.task.IAtsTaskServiceIde;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.model.event.DefaultBasicIdRelation;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidRelation;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.relation.RelationEventType;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryComboComboDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryComboDialog;

public class AtsTaskService
extends AbstractAtsTaskServiceCore
implements IAtsTaskServiceIde {
    private final AtsApiIde atsClient;
    private final AtsApi atsApi;

    public AtsTaskService(AtsApiIde atsClient) {
        super((AtsApi)atsClient);
        this.atsClient = atsClient;
        this.atsApi = atsClient;
    }

    public Collection<IAtsTask> createTasks(NewTaskDatas newTaskDatas) {
        LinkedList<IAtsTask> tasks = new LinkedList<IAtsTask>();
        AtsTaskEndpointApi taskEp = this.atsApi.getServerEndpoints().getTaskEp();
        JaxAtsTasks jaxTasks = taskEp.create(newTaskDatas);
        newTaskDatas.setResults(jaxTasks.getResults());
        if (newTaskDatas.getResults().isErrors()) {
            return tasks;
        }
        ArtifactEvent artifactEvent = new ArtifactEvent((BranchId)this.atsApi.getAtsBranch());
        for (NewTaskData newTaskData : newTaskDatas.getTaskDatas()) {
            this.processForEvents(newTaskData, jaxTasks, tasks, artifactEvent);
        }
        OseeEventManager.kickPersistEvent(this.getClass(), (ArtifactEvent)artifactEvent);
        return tasks;
    }

    private void processForEvents(NewTaskData newTaskData, JaxAtsTasks jaxTasks, List<IAtsTask> tasks, ArtifactEvent artifactEvent) {
        Artifact teamWf = this.atsClient.getQueryServiceIde().getArtifact(newTaskData.getTeamWfId());
        LinkedList<Long> artIds = new LinkedList<Long>();
        teamWf.reloadAttributesAndRelations();
        for (JaxAtsTask task : jaxTasks.getTasks()) {
            String guid = ArtifactQuery.getGuidFromId((long)task.getId(), (BranchId)this.atsApi.getAtsBranch());
            artifactEvent.addArtifact(new EventBasicGuidArtifact(EventModType.Added, (BranchId)this.atsApi.getAtsBranch(), AtsArtifactTypes.Task, guid));
            artIds.add(task.getId());
            RelationLink relation = this.getRelation(teamWf, task);
            if (relation == null) continue;
            Artifact taskArt = this.atsClient.getQueryServiceIde().getArtifact(task.getId());
            DefaultBasicIdRelation guidRelation = new DefaultBasicIdRelation((BranchId)this.atsApi.getAtsBranch(), AtsRelationTypes.TeamWfToTask_Task.getGuid(), relation.getId(), relation.getGammaId(), teamWf.getBasicGuidArtifact(), taskArt.getBasicGuidArtifact());
            artifactEvent.getRelations().add(new EventBasicGuidRelation(RelationEventType.Added, ArtifactId.valueOf((Long)newTaskData.getTeamWfId()), ArtifactId.valueOf((Long)task.getId()), guidRelation));
        }
        for (Long id : artIds) {
            tasks.add(this.atsApi.getWorkItemService().getTask(this.atsApi.getQueryService().getArtifact(id)));
        }
    }

    private RelationLink getRelation(Artifact teamWf, JaxAtsTask task) {
        for (RelationLink relation : teamWf.getRelationsAll(DeletionFlag.EXCLUDE_DELETED)) {
            if (!relation.getArtifactB().equals(task.getId())) continue;
            return relation;
        }
        return null;
    }

    public Collection<IAtsTask> createTasks(IAtsTeamWorkflow teamWf, List<String> titles, List<AtsUser> assignees, Date createdDate, AtsUser createdBy, String relatedToState, String taskWorkDef, Map<AttributeTypeToken, List<Object>> attributes, IAtsChangeSet changes) {
        throw new UnsupportedOperationException("Not Supported on Client");
    }

    public Collection<IAtsTask> createTasks(NewTaskData newTaskData, IAtsChangeSet changes, XResultData results) {
        throw new UnsupportedOperationException("Not Supported on Client");
    }

    @Override
    public TaskArtifact createNewTaskWithDialog(IAtsTeamWorkflow teamWf) {
        TaskArtifact taskArt = null;
        try {
            List<String> validStates;
            EntryComboDialog ed = null;
            EntryComboComboDialog ed2 = null;
            Collection taskWorkDefs = this.atsApi.getTaskService().calculateTaskWorkDefs(teamWf);
            if (taskWorkDefs.size() == 0 || taskWorkDefs.size() == 1) {
                ed = new EntryComboDialog("Create New Task", "Enter Task Title", RelatedToStateColumn.RELATED_TO_STATE_SELECTION);
                validStates = RelatedToStateColumn.getValidInWorkStates((TeamWorkFlowArtifact)teamWf.getStoreObject());
                ed.setOptions(validStates);
            } else {
                ed2 = new EntryComboComboDialog("Create New Task", "Enter Task Title and Select Task Work Definition", RelatedToStateColumn.RELATED_TO_STATE_SELECTION, "Select Task Work Definition");
                ed = ed2;
                validStates = RelatedToStateColumn.getValidInWorkStates((TeamWorkFlowArtifact)teamWf.getStoreObject());
                ed2.setOptions(validStates);
                ed2.setOptions2(taskWorkDefs);
                ed2.setCombo2Required(true);
            }
            if (ed.open() == 0) {
                NewTaskData newTaskData = NewTaskDataFactory.get((String)"Create New Task", (String)this.atsApi.getUserService().getCurrentUser().getUserId(), (Long)teamWf.getId());
                String title = ed.getEntry();
                JaxAtsTask task = JaxAtsTaskFactory.get((NewTaskData)newTaskData, (String)title, (AtsUser)this.atsApi.getUserService().getCurrentUser(), (Date)new Date());
                task.setId(Lib.generateArtifactIdAsInt());
                if (ed2 != null) {
                    task.setTaskWorkDef(((IAtsWorkDefinition)ed2.getSelection2()).getIdString());
                } else if (taskWorkDefs.size() == 1) {
                    task.setTaskWorkDef(((IAtsWorkDefinition)taskWorkDefs.iterator().next()).getIdString());
                }
                if (Strings.isValid((String)ed.getSelection())) {
                    task.setRelatedToState(ed.getSelection());
                }
                this.atsApi.getTaskService().createTasks(new NewTaskDatas(newTaskData));
                taskArt = (TaskArtifact)this.atsApi.getQueryService().getArtifact(task.getId());
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return taskArt;
    }

    public Collection<IAtsTask> createTasks(NewTaskData newTaskData, IAtsChangeSet changes, XResultData rd, Map<Long, IAtsTeamWorkflow> idToTeamWf) {
        throw new UnsupportedOperationException("Not supported on ide client");
    }

    public ChangeReportTaskData createTasks(ChangeReportTaskData changeReportTaskData) {
        ChangeReportTaskData crtd = this.atsApi.getServerEndpoints().getTaskEp().create(changeReportTaskData);
        this.reloadTasksIfNecessary(crtd);
        return crtd;
    }

    private void reloadTasksIfNecessary(ChangeReportTaskData crtd) {
        if (crtd.getTransaction().isValid()) {
            ArrayList<Artifact> toReload = new ArrayList<Artifact>();
            for (ArtifactId id : crtd.getIds()) {
                Artifact cachedArt = ArtifactCache.getActive((ArtifactId)id, (BranchId)this.atsApi.getAtsBranch());
                if (cachedArt == null) continue;
                toReload.add(cachedArt);
            }
            if (!toReload.isEmpty()) {
                ArtifactQuery.reloadArtifacts(toReload);
            }
        }
    }

    public ChangeReportTaskData createTasks(ArtifactToken hostTeamWf, AtsTaskDefToken taskDefToken, ArtifactToken asUser) {
        ChangeReportTaskData data = new ChangeReportTaskData();
        data.setTaskDefToken(taskDefToken);
        data.setHostTeamWf(hostTeamWf);
        data.setAsUser(this.atsApi.getUserService().getCurrentUser());
        ChangeReportTaskData crtd = this.atsApi.getServerEndpoints().getTaskEp().create(data);
        this.reloadTasksIfNecessary(crtd);
        return crtd;
    }

    public ChangeReportTaskData createTasks(ChangeReportTaskData changeReportTaskData, IAtsChangeSet changes) {
        throw new UnsupportedOperationException();
    }

    public IAtsChangeReportTaskNameProvider getChangeReportOptionNameProvider(ChangeReportTaskNameProviderToken token) {
        return ChangeReportTaskNameProviderService.getChangeReportOptionNameProvider((ChangeReportTaskNameProviderToken)token);
    }

    public IAtsTask getTask(ArtifactToken artifact) {
        IAtsTask task = null;
        if (artifact instanceof IAtsTask) {
            task = (IAtsTask)artifact;
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
            task = new Task(this.atsApi.getLogger(), this.atsApi, artifact);
        } else {
            throw new OseeArgumentException("Artifact %s must be of type Task", new Object[]{artifact.toStringWithId()});
        }
        return task;
    }
}

