/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.CommandGroup;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.util.RendererOption;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.MenuCmdDef;
import org.eclipse.osee.framework.ui.skynet.render.DefaultArtifactRenderer;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class AtsTaskEditorRenderer
extends DefaultArtifactRenderer {
    private static final String Option_TASK_WORLD_EDITOR = "task.world.editor.option";

    public AtsTaskEditorRenderer(Map<RendererOption, Object> rendererOptions) {
        super(rendererOptions);
    }

    public AtsTaskEditorRenderer() {
        this(new HashMap<RendererOption, Object>());
    }

    public String getName() {
        return "ATS Task Editor";
    }

    public int getApplicabilityRating(PresentationType presentationType, Artifact artifact, Map<RendererOption, Object> rendererOptions) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task}) && !artifact.isHistorical() && !presentationType.matches(new PresentationType[]{PresentationType.GENERALIZED_EDIT, PresentationType.PRODUCE_ATTRIBUTE})) {
            if (Option_TASK_WORLD_EDITOR.equals(rendererOptions.get(RendererOption.OPEN_OPTION))) {
                return 70;
            }
            return 50;
        }
        return -1;
    }

    public void addMenuCommandDefinitions(ArrayList<MenuCmdDef> commands, Artifact artifact) {
        commands.add(new MenuCmdDef(CommandGroup.EDIT, PresentationType.SPECIALIZED_EDIT, "ATS Task Editor", (KeyedImage)AtsImage.TASK, RendererOption.OPEN_OPTION.getKey(), Option_TASK_WORLD_EDITOR));
    }

    public AtsTaskEditorRenderer newInstance() {
        return new AtsTaskEditorRenderer();
    }

    public AtsTaskEditorRenderer newInstance(Map<RendererOption, Object> rendererOptions) {
        return new AtsTaskEditorRenderer(rendererOptions);
    }

    public void open(List<Artifact> artifacts, PresentationType presentationType) {
        AtsEditors.openInAtsTaskEditor("Tasks", artifacts);
    }
}

