/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.review;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.actions.OpenWorkflowByIdAction;
import org.eclipse.osee.ats.ide.actions.ValidatePeerDefectsAction;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.SearchNavigateItem;
import org.eclipse.osee.ats.ide.workflow.review.GenerateReviewParticipationReport;
import org.eclipse.osee.ats.ide.workflow.review.NewPeerToPeerReviewItem;
import org.eclipse.osee.ats.ide.workflow.review.ReviewPerspective;
import org.eclipse.osee.ats.ide.world.search.AtsSearchReviewSearchItem;
import org.eclipse.osee.ats.ide.world.search.MyReviewSearchItem;
import org.eclipse.osee.ats.ide.world.search.ShowOpenWorkflowsByReviewType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.OpenPerspectiveNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.IXNavigateCommonItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateCommonItems;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateViewItems;
import org.eclipse.osee.framework.ui.skynet.util.DbConnectionUtility;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class ReviewNavigateViewItems
implements XNavigateViewItems,
IXNavigateCommonItem {
    private static final ReviewNavigateViewItems instance = new ReviewNavigateViewItems();
    private final List<XNavigateItem> items = new CopyOnWriteArrayList<XNavigateItem>();
    private boolean ensurePopulatedRanOnce = false;

    public static ReviewNavigateViewItems getInstance() {
        return instance;
    }

    public List<XNavigateItem> getSearchNavigateItems() {
        this.ensurePopulated();
        return this.items;
    }

    private synchronized void ensurePopulated() {
        if (!this.ensurePopulatedRanOnce) {
            if (DbConnectionUtility.areOSEEServicesAvailable().isFalse()) {
                return;
            }
            this.ensurePopulatedRanOnce = true;
            try {
                this.addOseePeerSectionChildren(null);
                XNavigateCommonItems.addCommonNavigateItems(this.items, Arrays.asList(this.getSectionId()));
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    }

    public void addOseePeerSectionChildren(XNavigateItem item) {
        this.items.add(new SearchNavigateItem(item, new MyReviewSearchItem()));
        this.items.add(new SearchNavigateItem(item, new AtsSearchReviewSearchItem()));
        this.items.add((XNavigateItem)new XNavigateItemAction(item, (Action)new OpenWorkflowByIdAction("Open Review by ID"), (KeyedImage)AtsImage.REVIEW));
        this.items.add(new SearchNavigateItem(item, new ShowOpenWorkflowsByReviewType("Show Open " + WorkItemType.DecisionReview.name() + "s", WorkItemType.DecisionReview, false, false, AtsImage.DECISION_REVIEW)));
        this.items.add(new SearchNavigateItem(item, new ShowOpenWorkflowsByReviewType("Show Workflows Waiting " + WorkItemType.DecisionReview.name() + "s", WorkItemType.DecisionReview, false, true, AtsImage.DECISION_REVIEW)));
        this.items.add(new SearchNavigateItem(item, new ShowOpenWorkflowsByReviewType("Show Open " + WorkItemType.PeerReview.name() + "s", WorkItemType.PeerReview, false, false, AtsImage.PEER_REVIEW)));
        this.items.add(new SearchNavigateItem(item, new ShowOpenWorkflowsByReviewType("Show Workflows Waiting " + WorkItemType.PeerReview.name() + "s", WorkItemType.PeerReview, false, true, AtsImage.PEER_REVIEW)));
        this.items.add((XNavigateItem)new NewPeerToPeerReviewItem(item));
        this.items.add((XNavigateItem)new GenerateReviewParticipationReport(item));
        if (AtsApiService.get().getUserService().isAtsAdmin()) {
            this.items.add((XNavigateItem)new XNavigateItemAction(item, (Action)new ValidatePeerDefectsAction(), (KeyedImage)AtsImage.PEER_REVIEW));
        }
    }

    public void createCommonSection(List<XNavigateItem> items, List<String> excludeSectionIds) {
        try {
            XNavigateItem reviewItem = new XNavigateItem(null, "OSEE Review", (KeyedImage)AtsImage.REVIEW);
            new OpenPerspectiveNavigateItem(reviewItem, "Review", ReviewPerspective.ID, (KeyedImage)AtsImage.REVIEW);
            this.addOseePeerSectionChildren(reviewItem);
            items.add(reviewItem);
        }
        catch (OseeCoreException oseeCoreException) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Can't create OSEE Review section");
        }
    }

    public String getSectionId() {
        return "Peer";
    }
}

