/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.review;

import java.util.logging.Level;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.osee.ats.help.ui.AtsHelpContext;
import org.eclipse.osee.ats.ide.actions.OpenWorkflowByIdAction;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateComposite;
import org.eclipse.osee.ats.ide.workflow.review.ReviewNavigateViewItems;
import org.eclipse.osee.ats.ide.workflow.review.ReviewNavigateViewItemsOperation;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.data.HelpContext;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationBuilder;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.HelpUtil;
import org.eclipse.osee.framework.ui.plugin.xnavigate.IXNavigateEventListener;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.OseeStatusContributionItemFactory;
import org.eclipse.osee.framework.ui.skynet.action.CollapseAllAction;
import org.eclipse.osee.framework.ui.skynet.action.ExpandAllAction;
import org.eclipse.osee.framework.ui.skynet.util.DbConnectionExceptionComposite;
import org.eclipse.osee.framework.ui.skynet.util.LoadingComposite;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class ReviewNavigateView
extends ViewPart
implements IXNavigateEventListener {
    public static final String VIEW_ID = "org.eclipse.osee.ats.ide.review.ReviewNavigateView";
    private static final String INPUT = "filter";
    private static final String FILTER_STR = "filterStr";
    private String savedFilterStr;
    private AtsNavigateComposite xNavComp;
    private Composite parent;
    private LoadingComposite loadingComposite;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        if (DbConnectionExceptionComposite.dbConnectionIsOk((Composite)parent)) {
            this.loadingComposite = new LoadingComposite(parent);
            this.refreshData();
        }
    }

    public void refresh(XNavigateItem item) {
        if (this.xNavComp != null && Widgets.isAccessible((Widget)this.xNavComp.getFilteredTree()) && Widgets.isAccessible((Widget)this.xNavComp.getFilteredTree().getViewer().getTree())) {
            this.xNavComp.getFilteredTree().getViewer().refresh((Object)item);
        }
    }

    public void refreshData() {
        OperationBuilder builder = Operations.createBuilder((String)"Load Review Navigator");
        builder.addOp((IOperation)new ReviewNavigateViewItemsOperation());
        Operations.executeAsJob((IOperation)builder.build(), (boolean)false, (int)30, (IJobChangeListener)new ReloadJobChangeAdapter(this));
    }

    private void addExtensionPointListenerBecauseOfWorkspaceLoading() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        extensionRegistry.addListener(new IRegistryEventListener(){

            public void added(IExtension[] extensions) {
                ReviewNavigateView.this.xNavComp.refresh();
            }

            public void added(IExtensionPoint[] extensionPoints) {
                ReviewNavigateView.this.xNavComp.refresh();
            }

            public void removed(IExtension[] extensions) {
                ReviewNavigateView.this.xNavComp.refresh();
            }

            public void removed(IExtensionPoint[] extensionPoints) {
                ReviewNavigateView.this.xNavComp.refresh();
            }
        }, "org.eclipse.osee.framework.ui.skynet.BlamOperation");
    }

    private String getWhoAmI() {
        try {
            String userName = AtsApiService.get().getUserService().getCurrentUser().getName();
            return String.format("%s - %s:%s", userName, ClientSessionManager.getDataStoreName(), ClientSessionManager.getDataStoreLoginName());
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return "Exception: " + ex.getLocalizedMessage();
        }
    }

    protected void createToolBar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)new CollapseAllAction(this.xNavComp.getFilteredTree().getViewer()));
        toolbarManager.add((IAction)new ExpandAllAction(this.xNavComp.getFilteredTree().getViewer()));
        toolbarManager.add((IAction)new OpenWorkflowByIdAction("Open Review by ID"));
        this.getViewSite().getActionBars().updateActionBars();
        toolbarManager.update(true);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (DbConnectionExceptionComposite.dbConnectionIsOk()) {
            memento = memento.createChild(INPUT);
            if (this.xNavComp != null && this.xNavComp.getFilteredTree().getFilterControl() != null && !this.xNavComp.getFilteredTree().isDisposed()) {
                String filterStr = this.xNavComp.getFilteredTree().getFilterControl().getText();
                memento.putString(FILTER_STR, filterStr);
            }
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (DbConnectionExceptionComposite.dbConnectionIsOk()) {
            try {
                if (memento != null && (memento = memento.getChild(INPUT)) != null) {
                    this.savedFilterStr = memento.getString(FILTER_STR);
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.WARNING, (String)"NavigateView error on init", (Throwable)ex);
            }
        }
    }

    public void setFocus() {
        if (this.loadingComposite != null && !this.loadingComposite.isDisposed()) {
            this.loadingComposite.setFocus();
        }
    }

    private final class ReloadJobChangeAdapter
    extends JobChangeAdapter {
        private final ReviewNavigateView navView;

        private ReloadJobChangeAdapter(ReviewNavigateView navView) {
            this.navView = navView;
        }

        public void done(IJobChangeEvent event) {
            UIJob job = new UIJob("Load Review Navigator"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        ReviewNavigateView.this.showBusy(false);
                        if (Widgets.isAccessible((Widget)ReviewNavigateView.this.loadingComposite)) {
                            ReviewNavigateView.this.loadingComposite.dispose();
                        }
                        if (DbConnectionExceptionComposite.dbConnectionIsOk((Composite)ReviewNavigateView.this.parent) && Widgets.isAccessible((Widget)ReviewNavigateView.this.parent)) {
                            ReviewNavigateView.this.xNavComp = new AtsNavigateComposite(ReviewNavigateViewItems.getInstance(), ReviewNavigateView.this.parent, 0, ReviewNavigateView.this.savedFilterStr);
                            HelpUtil.setHelp((Control)ReviewNavigateView.this.xNavComp, (HelpContext)AtsHelpContext.NAVIGATOR);
                            ReviewNavigateView.this.createToolBar();
                            Label label = new Label((Composite)ReviewNavigateView.this.xNavComp, 0);
                            String str = ReviewNavigateView.this.getWhoAmI();
                            if (AtsApiService.get().getUserService().isAtsAdmin()) {
                                str = String.valueOf(str) + " - Admin";
                            }
                            if (!str.equals("")) {
                                if (AtsApiService.get().getUserService().isAtsAdmin()) {
                                    label.setForeground(Displays.getSystemColor((int)3));
                                } else {
                                    label.setForeground(Displays.getSystemColor((int)9));
                                }
                            }
                            label.setText(str);
                            label.setToolTipText(str);
                            GridData gridData = new GridData(0x1000000, 0x1000000, true, false);
                            gridData.heightHint = 15;
                            label.setLayoutData((Object)gridData);
                            ReviewNavigateView.this.xNavComp.refresh();
                            ReviewNavigateView.this.xNavComp.getFilteredTree().getFilterControl().setFocus();
                            ReviewNavigateView.this.parent.getParent().layout(true);
                            ReviewNavigateView.this.parent.layout(true);
                            OseeStatusContributionItemFactory.addTo((ViewPart)ReloadJobChangeAdapter.this.navView, (boolean)false);
                            ReviewNavigateView.this.addExtensionPointListenerBecauseOfWorkspaceLoading();
                        }
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                    return Status.OK_STATUS;
                }
            };
            Operations.scheduleJob((Job)job, (boolean)false, (int)20, null);
        }
    }
}

