/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.walker;

import java.util.logging.Level;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.walker.IActionWalkerItem;
import org.eclipse.osee.ats.ide.workflow.review.ReviewManager;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public class ReviewWrapper
implements IActionWalkerItem {
    private final TeamWorkFlowArtifact teamArt;

    public ReviewWrapper(TeamWorkFlowArtifact teamArt) {
        this.teamArt = teamArt;
    }

    public String toString() {
        try {
            return String.format(String.valueOf(ReviewManager.getReviews(this.teamArt).size()) + " Reviews", new Object[0]);
        }
        catch (OseeCoreException ex) {
            return "Exception: " + ex.getLocalizedMessage();
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.teamArt == null ? 0 : this.teamArt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReviewWrapper other = (ReviewWrapper)obj;
        return !(this.teamArt == null ? other.teamArt != null : !this.teamArt.equals((Object)other.teamArt));
    }

    @Override
    public Image getImage() {
        return ImageManager.getImage((KeyedImage)AtsImage.REVIEW);
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public void handleDoubleClick() {
        try {
            AtsEditors.openInAtsWorldEditor("Reviews", ReviewManager.getReviews(this.teamArt));
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

