/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.task;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskTeamWfData;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinitionBuilder;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XButton;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;

public class XCreateChangeReportTasksXButton
extends XButton
implements ArtifactWidget {
    public static final Object WIDGET_ID = XCreateChangeReportTasksXButton.class.getSimpleName();
    private TeamWorkFlowArtifact hostTeamWf;
    private final List<AtsTaskDefToken> taskDefTokens = new ArrayList<AtsTaskDefToken>();
    boolean creating = false;
    boolean debug = false;
    boolean reportOnly = false;
    private final XModifiedListener listener = new XModifiedListener(){
        String fName;
        {
            this.fName = XCreateChangeReportTasksXButton.this.getLabel();
        }

        public void widgetModified(XWidget widget) {
            XCreateChangeReportTasksXButton.this.debug = false;
            XCreateChangeReportTasksXButton.this.reportOnly = false;
            XCreateChangeReportTasksXButton.this.createUpdateTasks(this.fName);
        }

        public void handleRightClick(XWidget widget) {
            XCreateChangeReportTasksXButton.this.debug = true;
            XCreateChangeReportTasksXButton.this.reportOnly = true;
            XCreateChangeReportTasksXButton.this.createUpdateTasks(this.fName);
        }
    };

    public XCreateChangeReportTasksXButton(String name, AtsTaskDefToken ... taskDefTokens) {
        super(name);
        AtsTaskDefToken[] atsTaskDefTokenArray = taskDefTokens;
        int n = taskDefTokens.length;
        int n2 = 0;
        while (n2 < n) {
            AtsTaskDefToken taskDefToken = atsTaskDefTokenArray[n2];
            this.taskDefTokens.add(taskDefToken);
            ++n2;
        }
        Conditions.assertNotNullOrEmpty(this.taskDefTokens, (String)"taskDefToken must not be null", (Object[])new Object[0]);
        this.setImage(ImageManager.getImage((KeyedImage)AtsImage.PLAY_GREEN));
        this.setToolTip(String.format("Click to Create/Update Change Report Tasks from [%s]", name));
        this.addXModifiedListener(this.listener);
    }

    protected void createUpdateTasks(String name) {
        if (this.creating) {
            AWorkbench.popup((String)"Creating Tasks, Please Wait");
            return;
        }
        this.creating = true;
        String useName = name;
        if (this.reportOnly) {
            useName = String.valueOf(useName) + " (ReportOnly)";
        }
        if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)useName, (String)(String.valueOf(useName) + "?"))) {
            this.creating = false;
            return;
        }
        final String fName = name;
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                XCreateChangeReportTasksXButton.this.setLabel(String.valueOf(fName) + " - Creating...");
                XCreateChangeReportTasksXButton.this.bComp.layout(true);
                XCreateChangeReportTasksXButton.this.parent.layout(true);
            }
        });
        final TeamWorkFlowArtifact teamWf = this.hostTeamWf;
        Job job = new Job(name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    for (AtsTaskDefToken taskDefToken : XCreateChangeReportTasksXButton.this.taskDefTokens) {
                        CreateTasksDefinitionBuilder taskSetDefinition = AtsApiService.get().getTaskSetDefinitionProviderService().getTaskSetDefinition(taskDefToken);
                        if (taskSetDefinition == null || !taskSetDefinition.getCreateTasksDef().getHelper().isApplicable((IAtsWorkItem)teamWf, (AtsApi)AtsApiService.get())) continue;
                        ChangeReportTaskData crtd = new ChangeReportTaskData();
                        crtd.setOperationName(this.getName());
                        crtd.setTaskDefToken(taskDefToken);
                        crtd.setHostTeamWf((ArtifactToken)XCreateChangeReportTasksXButton.this.hostTeamWf);
                        crtd.setAsUser(AtsApiService.get().getUserService().getCurrentUser());
                        crtd.setDebug(XCreateChangeReportTasksXButton.this.debug);
                        crtd.setReportOnly(XCreateChangeReportTasksXButton.this.reportOnly);
                        crtd = AtsApiService.get().getTaskService().createTasks(crtd);
                        XResultDataUI.report((XResultData)crtd.getResults(), (String)this.getName());
                        if (crtd.getTransaction() == null || !crtd.getTransaction().isValid()) continue;
                        final ChangeReportTaskData fData = crtd;
                        Thread reload = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChangeReportTaskTeamWfData crttwd : fData.getChangeReportDatas()) {
                                    ArtifactQuery.reloadArtifactFromId((ArtifactId)crttwd.getDestTeamWf(), (BranchId)AtsApiService.get().getAtsBranch());
                                }
                            }
                        });
                        reload.start();
                    }
                }
                catch (Throwable throwable) {
                    Displays.ensureInDisplayThread((Runnable)new Runnable(fName){
                        private final /* synthetic */ String val$fName;
                        {
                            this.val$fName = string;
                        }

                        @Override
                        public void run() {
                            XCreateChangeReportTasksXButton.this.setLabel(this.val$fName);
                            (this).XCreateChangeReportTasksXButton.this.creating = false;
                        }
                    });
                    throw throwable;
                }
                Displays.ensureInDisplayThread((Runnable)new /* invalid duplicate definition of identical inner class */);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public TeamWorkFlowArtifact getArtifact() {
        return this.hostTeamWf;
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void revert() {
    }

    public void saveToArtifact() {
    }

    public void setArtifact(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            this.hostTeamWf = (TeamWorkFlowArtifact)artifact;
        }
        super.setEditable(true);
    }
}

