/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XPromptChange;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.util.EnumStringSingleSelectionDialog;
import org.eclipse.osee.ats.api.review.ReviewRole;
import org.eclipse.osee.ats.api.review.UserRole;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.role.UserRoleContentProvider;
import org.eclipse.osee.ats.ide.util.widgets.role.UserRoleXViewerFactory;
import org.eclipse.osee.ats.ide.util.widgets.role.XUserRoleViewer;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.UserListDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class UserRoleXViewer
extends XViewer {
    private final XUserRoleViewer xUserRoleViewer;
    private final IAtsWorkDefinition workDefinition;

    public UserRoleXViewer(Composite parent, int style, XUserRoleViewer xUserRoleViewer, IAtsWorkDefinition workDefinition) {
        super(parent, style, (IXViewerFactory)new UserRoleXViewerFactory());
        this.xUserRoleViewer = xUserRoleViewer;
        this.workDefinition = workDefinition;
    }

    protected void createSupportWidgets(Composite parent) {
        super.createSupportWidgets(parent);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ((UserRoleContentProvider)UserRoleXViewer.this.getContentProvider()).clear();
            }
        });
        this.createMenuActions();
    }

    public void createMenuActions() {
        this.setColumnMultiEditEnabled(true);
        MenuManager mm = this.getMenuManager();
        mm.createContextMenu(this.getControl());
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UserRoleXViewer.this.updateMenuActionsForTable();
            }
        });
    }

    public void updateEditMenuActions() {
    }

    public void updateMenuActionsForTable() {
        MenuManager mm = this.getMenuManager();
        this.updateEditMenuActions();
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new Separator());
    }

    public void add(Collection<UserRole> userRoles) {
        ((UserRoleContentProvider)this.getContentProvider()).add(userRoles);
    }

    public void set(Collection<? extends UserRole> userRoles) {
        if ((UserRoleContentProvider)this.getContentProvider() != null) {
            ((UserRoleContentProvider)this.getContentProvider()).set(userRoles);
        }
    }

    public void clear() {
        ((UserRoleContentProvider)this.getContentProvider()).clear();
    }

    public void dispose() {
        this.getLabelProvider().dispose();
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        if (!this.xUserRoleViewer.isEditable()) {
            return;
        }
        ArrayList<UserRole> userRoles = new ArrayList<UserRole>();
        for (TreeItem item : treeItems) {
            userRoles.add((UserRole)item.getData());
        }
        try {
            this.promptChangeDate((XViewerColumn)treeColumn.getData(), userRoles, this.isColumnMultiEditEnabled());
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public boolean handleLeftClickInIconArea(TreeColumn treeColumn, TreeItem treeItem) {
        return this.handleAltLeftClick(treeColumn, treeItem);
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        if (!this.xUserRoleViewer.isEditable()) {
            return false;
        }
        try {
            XViewerColumn aCol = (XViewerColumn)treeColumn.getData();
            UserRole userRole = (UserRole)treeItem.getData();
            ArrayList<UserRole> userRoles = new ArrayList<UserRole>();
            userRoles.add(userRole);
            if (!(aCol.equals((Object)UserRoleXViewerFactory.Completed_Col) || aCol.equals((Object)UserRoleXViewerFactory.Hours_Spent_Col) || aCol.equals((Object)UserRoleXViewerFactory.Num_Minor_Col) || aCol.equals((Object)UserRoleXViewerFactory.Num_Major_Col) || aCol.equals((Object)UserRoleXViewerFactory.Num_Issues_Col) || aCol.equals((Object)UserRoleXViewerFactory.User_Col) || aCol.equals((Object)UserRoleXViewerFactory.Role_Col))) {
                throw new OseeStateException("Unhandled user role column", new Object[0]);
            }
            this.promptChangeDate(aCol, userRoles, false);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    private boolean setHoursSpent(Collection<UserRole> userRoles, String hours) {
        boolean modified = false;
        for (UserRole userRole : userRoles) {
            userRole.setHoursSpent(Double.valueOf(hours.equals("") ? 0.0 : new Double(hours)));
            if (modified) continue;
            modified = true;
        }
        return modified;
    }

    private boolean setCompleted(Collection<UserRole> userRoles) {
        boolean modified = false;
        for (UserRole userRole : userRoles) {
            if (userRole.getHoursSpent() == null) {
                AWorkbench.popup((String)"ERROR", (String)"Must enter Hours Spent");
                return false;
            }
            userRole.setCompleted(!userRole.isCompleted());
            if (modified) continue;
            modified = true;
        }
        return modified;
    }

    private boolean setUser(Collection<UserRole> userRoles, User user) {
        boolean modified = false;
        for (UserRole userRole : userRoles) {
            AtsUser atsUser = AtsApiService.get().getUserService().getUserByUserId(userRole.getUserId());
            if (user == null || !atsUser.notEqual((Id)user)) continue;
            userRole.setUserId(atsUser.getUserId());
            if (modified) continue;
            modified = true;
        }
        return modified;
    }

    private boolean setRole(Collection<UserRole> userRoles, String role) {
        boolean modified = false;
        for (UserRole userRole : userRoles) {
            userRole.setRole(this.workDefinition.fromName(role));
            if (modified) continue;
            modified = true;
        }
        return modified;
    }

    public boolean promptChangeDate(XViewerColumn xCol, Collection<UserRole> userRoles, boolean columnMultiEdit) {
        boolean modified = false;
        if (userRoles != null && !userRoles.isEmpty()) {
            UserRole userRole = (UserRole)userRoles.toArray()[0];
            if (xCol.equals((Object)UserRoleXViewerFactory.Hours_Spent_Col)) {
                String hours = XPromptChange.promptChangeFloat((String)xCol.getName(), (double)(columnMultiEdit ? 0.0 : (userRole.getHoursSpent() == null ? 0.0 : userRole.getHoursSpent())));
                if (hours != null) {
                    modified = this.setHoursSpent(userRoles, hours);
                }
            } else if (xCol.equals((Object)UserRoleXViewerFactory.Num_Minor_Col) || xCol.equals((Object)UserRoleXViewerFactory.Num_Major_Col) || xCol.equals((Object)UserRoleXViewerFactory.Num_Issues_Col)) {
                AWorkbench.popup((String)"ERROR", (String)"Field is calculated");
            } else if (xCol.equals((Object)UserRoleXViewerFactory.Completed_Col)) {
                modified = this.setCompleted(userRoles);
            } else if (xCol.equals((Object)UserRoleXViewerFactory.User_Col)) {
                UserListDialog ld = new UserListDialog(Displays.getActiveShell(), "Select New User", Active.Active);
                int result = ld.open();
                if (result == 0) {
                    modified = this.setUser(userRoles, ld.getSelection());
                }
            } else if (xCol.equals((Object)UserRoleXViewerFactory.Role_Col)) {
                ArrayList<String> roleStrValues = new ArrayList<String>();
                for (ReviewRole role : this.xUserRoleViewer.getArtifact().getWorkDefinition().getReviewRoles()) {
                    roleStrValues.add(role.toString());
                }
                EnumStringSingleSelectionDialog enumDialog = XPromptChange.promptChangeSingleSelectEnumeration((String)xCol.getName(), roleStrValues, columnMultiEdit ? null : userRole.getRole().getName());
                if (enumDialog != null && enumDialog.getResult()[0] != null) {
                    modified = this.setRole(userRoles, (String)enumDialog.getResult()[0]);
                }
            }
            if (modified) {
                return this.executeTransaction(userRoles);
            }
        }
        return false;
    }

    public boolean executeTransaction(Collection<UserRole> userRoles) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Modify Review Roles");
        for (UserRole userRole : userRoles) {
            this.xUserRoleViewer.getUserRoleMgr().addOrUpdateUserRole(userRole);
            this.update(userRole, null);
        }
        this.xUserRoleViewer.getUserRoleMgr().saveToArtifact(changes);
        changes.execute();
        this.xUserRoleViewer.refresh();
        this.xUserRoleViewer.notifyXModifiedListeners();
        return true;
    }

    public XUserRoleViewer getXUserRoleViewer() {
        return this.xUserRoleViewer;
    }
}

