/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.role;

import java.util.logging.Level;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.review.ReviewDefectItem;
import org.eclipse.osee.ats.api.review.UserRole;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.core.review.ReviewDefectManager;
import org.eclipse.osee.ats.core.review.UserRoleManager;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectSeverityToImage;
import org.eclipse.osee.ats.ide.util.widgets.role.UserRoleXViewer;
import org.eclipse.osee.ats.ide.util.widgets.role.UserRoleXViewerFactory;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.skynet.ArtifactImageManager;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public class UserRoleLabelProvider
extends XViewerLabelProvider {
    private final UserRoleXViewer xViewer;

    public UserRoleLabelProvider(UserRoleXViewer xViewer) {
        super((XViewer)xViewer);
        this.xViewer = xViewer;
    }

    public Image getColumnImage(Object element, XViewerColumn dCol, int columnIndex) {
        UserRole roleItem = (UserRole)element;
        try {
            AtsUser user = UserRoleManager.getUser((UserRole)roleItem, (AtsApi)AtsApiService.get());
            if (dCol.equals((Object)UserRoleXViewerFactory.User_Col)) {
                User user2 = UserManager.getUserByArtId((ArtifactId)user.getArtifactId());
                return ArtifactImageManager.getImage((Artifact)user2);
            }
            if (dCol.equals((Object)UserRoleXViewerFactory.Role_Col)) {
                return ImageManager.getImage((KeyedImage)AtsImage.ROLE);
            }
            if (dCol.equals((Object)UserRoleXViewerFactory.Hours_Spent_Col)) {
                return ImageManager.getImage((KeyedImage)FrameworkImage.CLOCK);
            }
            if (dCol.equals((Object)UserRoleXViewerFactory.Completed_Col)) {
                return ImageManager.getImage((KeyedImage)(roleItem.isCompleted() ? PluginUiImage.CHECKBOX_ENABLED : PluginUiImage.CHECKBOX_DISABLED));
            }
            if (dCol.equals((Object)UserRoleXViewerFactory.Num_Major_Col)) {
                return DefectSeverityToImage.getImage(ReviewDefectItem.Severity.Major);
            }
            if (dCol.equals((Object)UserRoleXViewerFactory.Num_Minor_Col)) {
                return DefectSeverityToImage.getImage(ReviewDefectItem.Severity.Minor);
            }
            if (dCol.equals((Object)UserRoleXViewerFactory.Num_Issues_Col)) {
                return DefectSeverityToImage.getImage(ReviewDefectItem.Severity.Issue);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return null;
    }

    public String getColumnText(Object element, XViewerColumn aCol, int columnIndex) {
        UserRole userRole = (UserRole)element;
        AtsUser user = UserRoleManager.getUser((UserRole)userRole, (AtsApi)AtsApiService.get());
        if (aCol.equals((Object)UserRoleXViewerFactory.User_Col)) {
            return user.getName();
        }
        if (aCol.equals((Object)UserRoleXViewerFactory.Hours_Spent_Col)) {
            return userRole.getHoursSpent() == null ? "" : AtsUtil.doubleToI18nString((double)userRole.getHoursSpent(), (boolean)false);
        }
        if (aCol.equals((Object)UserRoleXViewerFactory.Role_Col)) {
            return userRole.getRole().getName();
        }
        if (aCol.equals((Object)UserRoleXViewerFactory.Completed_Col)) {
            return String.valueOf(userRole.isCompleted());
        }
        if (aCol.equals((Object)UserRoleXViewerFactory.Num_Major_Col)) {
            ReviewDefectManager defectMgr = new ReviewDefectManager((ArtifactToken)this.xViewer.getXUserRoleViewer().getReviewArt(), (AtsApi)AtsApiService.get());
            return String.valueOf(defectMgr.getNumMajor(user));
        }
        if (aCol.equals((Object)UserRoleXViewerFactory.Num_Minor_Col)) {
            ReviewDefectManager defectMgr = new ReviewDefectManager((ArtifactToken)this.xViewer.getXUserRoleViewer().getReviewArt(), (AtsApi)AtsApiService.get());
            return String.valueOf(defectMgr.getNumMinor(user));
        }
        if (aCol.equals((Object)UserRoleXViewerFactory.Num_Issues_Col)) {
            ReviewDefectManager defectMgr = new ReviewDefectManager((ArtifactToken)this.xViewer.getXUserRoleViewer().getReviewArt(), (AtsApi)AtsApiService.get());
            return String.valueOf(defectMgr.getNumIssues(user));
        }
        return "unhandled column";
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

