/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AtsObjectNameReverseSorter;
import org.eclipse.osee.ats.ide.util.widgets.dialog.VersionLabelProvider;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class VersionListDialog
extends FilteredTreeDialog {
    XCheckBox showReleased = new XCheckBox("Show Released Versions");
    private final Collection<IAtsVersion> verArts;

    public VersionListDialog(String title, String message, Collection<IAtsVersion> verArts) {
        super(title, message, (IContentProvider)new VersionContentProvider(false), (IBaseLabelProvider)new VersionLabelProvider(), (ViewerComparator)new AtsObjectNameReverseSorter());
        this.verArts = verArts;
        this.setInput(verArts);
    }

    protected Control createDialogArea(Composite container) {
        Control control = super.createDialogArea(container);
        Composite comp = new Composite(control.getParent(), 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(1808));
        this.showReleased.createWidgets(comp, 2);
        this.showReleased.set(false);
        this.showReleased.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionContentProvider versionContentProvider;
                versionContentProvider.setShowReleased(!(versionContentProvider = (VersionContentProvider)VersionListDialog.this.getTreeViewer().getViewer().getContentProvider()).getShowReleased());
                VersionListDialog.this.setInput(VersionListDialog.this.verArts);
                VersionListDialog.this.getTreeViewer().getViewer().refresh();
            }
        });
        return control;
    }

    public static class VersionContentProvider
    extends ArrayTreeContentProvider {
        boolean showReleased = false;

        public VersionContentProvider(boolean showReleased) {
            this.showReleased = showReleased;
        }

        public boolean getShowReleased() {
            return this.showReleased;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                Collection list = (Collection)inputElement;
                LinkedList<IAtsVersion> verArts = new LinkedList<IAtsVersion>();
                IAtsVersion[] iAtsVersionArray = list.toArray(new IAtsVersion[list.size()]);
                int n = iAtsVersionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAtsVersion obj;
                    IAtsVersion verArt = obj = iAtsVersionArray[n2];
                    if (this.showReleased || !this.showReleased && !verArt.isReleased()) {
                        verArts.add(verArt);
                    }
                    ++n2;
                }
                return verArts.toArray(new IAtsVersion[verArts.size()]);
            }
            return super.getElements(inputElement);
        }

        public void setShowReleased(boolean showReleased) {
            this.showReleased = showReleased;
        }
    }
}

