/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.widgets.dialog.VersionTreeDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelCmdValueSelection;

public class XHyperlabelVersionSelection
extends XHyperlinkLabelCmdValueSelection {
    public static final String WIDGET_ID = XHyperlabelVersionSelection.class.getSimpleName();
    Collection<Version> selectedVersions = new HashSet<Version>();
    Collection<IAtsVersion> versions;
    VersionTreeDialog dialog = null;
    IAtsTeamDefinition teamDef;

    public XHyperlabelVersionSelection(String label) {
        super(label, true, Integer.valueOf(80));
    }

    public XHyperlabelVersionSelection(String label, IAtsTeamDefinition teamDef) {
        super(label, true, Integer.valueOf(80));
        this.teamDef = teamDef;
    }

    public Collection<Version> getSelectedVersions() {
        return this.selectedVersions;
    }

    public Object getData() {
        return this.getSelectedVersions();
    }

    public String getCurrentValue() {
        return Collections.toString((String)",", this.selectedVersions);
    }

    public void setSelectedVersions(Collection<Version> selectedVersions) {
        this.selectedVersions = selectedVersions;
        this.refresh();
        this.notifyXModifiedListeners();
    }

    public boolean handleClear() {
        this.selectedVersions.clear();
        this.notifyXModifiedListeners();
        return true;
    }

    public boolean handleSelection() {
        try {
            this.dialog = this.versions == null ? new VersionTreeDialog(Active.Both) : new VersionTreeDialog(Active.Both, this.versions);
            int result = this.dialog.open();
            if (result == 0) {
                this.selectedVersions.clear();
                for (Version obj : this.dialog.getResultVersions()) {
                    this.selectedVersions.add(obj);
                }
                this.notifyXModifiedListeners();
            }
            return true;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return false;
        }
    }

    public void setVersions(Collection<IAtsVersion> versions) {
        this.versions = versions;
        if (this.dialog != null) {
            this.dialog.setInput(versions);
        }
    }

    public boolean isEmpty() {
        return this.selectedVersions.isEmpty();
    }
}

