/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.ide.column.FoundInVersionColumnUI;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlabelVersionSelection;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;

public class XFoundInVersionWidget
extends XHyperlabelVersionSelection
implements ArtifactWidget {
    public static final String WIDGET_ID = XFoundInVersionWidget.class.getSimpleName();
    public static RelationTypeSide FOUND_VERSION_RELATION = AtsRelationTypes.TeamWorkflowToFoundInVersion_Version;
    public Collection<Version> selectedVersions = new HashSet<Version>();
    private Artifact artifact;

    public XFoundInVersionWidget(String label) {
        super(label);
    }

    public XFoundInVersionWidget() {
        this("Found In Version");
    }

    private RelationTypeSide getRelation() {
        return FOUND_VERSION_RELATION;
    }

    @Override
    public String getCurrentValue() {
        this.selectedVersions = Collections.castAll((Collection)this.getArtifact().getRelatedArtifacts(this.getRelation()));
        return Collections.toString((String)",", this.selectedVersions);
    }

    @Override
    public boolean handleClear() {
        this.selectedVersions.clear();
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Update Found-In-Version");
        changes.unrelateAll((Object)this.getArtifact(), this.getRelation());
        changes.executeIfNeeded();
        this.notifyXModifiedListeners();
        return true;
    }

    @Override
    public boolean handleSelection() {
        try {
            if (FoundInVersionColumnUI.getInstance().promptChangeVersion((TeamWorkFlowArtifact)this.getArtifact())) {
                this.notifyXModifiedListeners();
                this.refresh();
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.selectedVersions.isEmpty();
    }

    public void setArtifact(Artifact art) {
        if (art instanceof TeamWorkFlowArtifact) {
            this.artifact = art;
        }
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void revert() {
    }

    public void saveToArtifact() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }
}

