/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.AgileEndpointApi;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxAgileFeatureGroup;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.agile.AgileFeatureGroupColumn;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelCmdValueSelection;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeDialog;

public class XAgileFeatureHyperlinkWidget
extends XHyperlinkLabelCmdValueSelection {
    Collection<IAgileFeatureGroup> features = new HashSet<IAgileFeatureGroup>();
    IAtsTeamWorkflow teamWf;
    public static final String WIDGET_ID = XAgileFeatureHyperlinkWidget.class.getSimpleName();
    AtsApi atsApi = AtsApiService.get();

    public XAgileFeatureHyperlinkWidget() {
        super("Agile Feature", true, Integer.valueOf(50));
    }

    public String getCurrentValue() {
        return Collections.toString((String)", ", this.features);
    }

    public boolean handleSelection() {
        IAgileTeam agileTeam = this.atsApi.getAgileService().getAgileTeam((IAtsWorkItem)this.teamWf);
        AgileEndpointApi agileEp = this.atsApi.getServerEndpoints().getAgileEndpoint();
        FilteredCheckboxTreeDialog<JaxAgileFeatureGroup> dialog = AgileFeatureGroupColumn.openSelectionDialog(agileEp, agileTeam.getId(), java.util.Collections.singleton((AbstractWorkflowArtifact)this.teamWf));
        if (dialog != null) {
            for (JaxAgileFeatureGroup grp : dialog.getChecked()) {
                for (IAgileFeatureGroup feature : this.atsApi.getAgileService().getAgileFeatureGroups(agileTeam)) {
                    if (!grp.getId().equals(feature.getId())) continue;
                    this.features.add(feature);
                }
            }
        }
        return dialog != null;
    }

    public boolean handleClear() {
        this.features.clear();
        return true;
    }

    public void setTeamWf(IAtsTeamWorkflow teamWf) {
        this.teamWf = teamWf;
    }

    public Collection<IAgileFeatureGroup> getFeatures() {
        return this.features;
    }

    public void setSelected(Collection<IAgileFeatureGroup> currFeatures) {
        this.features.clear();
        this.features.addAll(currFeatures);
    }
}

