/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.internal;

import java.util.Collection;
import org.eclipse.osee.ats.api.data.AtsUserGroups;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.users.AbstractAtsUserService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.skynet.core.UserManager;

public class AtsUserServiceClientImpl
extends AbstractAtsUserService {
    Boolean atsAdmin = null;
    private AtsUser currentUser;

    public void setCurrentUser(AtsUser currentUser) {
        this.currentUser = currentUser;
    }

    public void clearCaches() {
        this.currentUser = null;
        this.atsAdmin = null;
    }

    public AtsUser getCurrentUser() {
        if (this.currentUser == null) {
            this.currentUser = UserManager.isBootstrap() ? this.configurationService.getUserByUserId(AtsCoreUsers.BOOTSTRAP_USER.getUserId()) : this.configurationService.getUserByLoginId(System.getProperty("user.name"));
        }
        return this.currentUser;
    }

    public AtsUser getCurrentUserNoCache() {
        this.currentUser = null;
        return this.getCurrentUser();
    }

    public AtsUser getUserById(ArtifactId userId) {
        return (AtsUser)this.configurationService.getConfigurations().getIdToUser().get(userId.getId());
    }

    public String getCurrentUserId() {
        return UserManager.getUser().getUserId();
    }

    public boolean isAtsAdmin(boolean useCache) {
        if (!useCache) {
            this.getCurrentUser().getUserGroups().contains(AtsUserGroups.AtsAdmin);
        }
        return this.isAtsAdmin();
    }

    public boolean isAtsAdmin() {
        if (this.atsAdmin == null) {
            this.atsAdmin = this.getCurrentUser().getUserGroups().contains(AtsUserGroups.AtsAdmin);
        }
        return this.atsAdmin;
    }

    public Collection<AtsUser> getUsers() {
        return this.configurationService.getConfigurations().getUsers();
    }
}

