/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IExecuteListener;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.core.util.AbstractAtsChangeSet;
import org.eclipse.osee.ats.core.util.AtsRelationChange;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.search.AtsArtifactQuery;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class AtsChangeSet
extends AbstractAtsChangeSet {
    public AtsChangeSet(String comment) {
        this(comment, (BranchId)AtsApiService.get().getAtsBranch(), AtsApiService.get().getUserService().getCurrentUser());
    }

    public AtsChangeSet(String comment, AtsUser asUser) {
        this(comment, (BranchId)AtsApiService.get().getAtsBranch(), asUser);
    }

    public AtsChangeSet(String comment, BranchId branch, AtsUser asUser) {
        super(comment, branch, asUser);
    }

    public TransactionId execute() {
        TransactionId transactionRecord;
        Conditions.checkNotNull((Object)this.comment, (String)"comment");
        if (this.isEmpty() && this.execptionIfEmpty) {
            throw new OseeArgumentException("objects/deleteObjects cannot be empty", new Object[0]);
        }
        if (this.branch == null) {
            this.branch = AtsApiService.get().getAtsBranch();
        }
        SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)this.branch, (String)this.comment);
        try {
            for (IAtsObject atsObject : new ArrayList(this.atsObjects)) {
                if (atsObject instanceof IAtsWorkItem) {
                    IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
                    IAtsStateManager stateMgr = workItem.getStateMgr();
                    Conditions.assertNotNull((Object)stateMgr, (String)"StateManager", (Object[])new Object[0]);
                    if (stateMgr.isDirty()) {
                        AtsApiService.get().getStateFactory().writeToStore(this.asUser, workItem, (IAtsChangeSet)this);
                    }
                    if (workItem.getLog().isDirty()) {
                        AtsApiService.get().getLogFactory().writeToStore(workItem, AtsApiService.get().getAttributeResolver(), (IAtsChangeSet)this);
                    }
                }
                transaction.addArtifact(AtsApiService.get().getQueryServiceIde().getArtifact(atsObject));
            }
            for (ArtifactId artifact : this.artifacts) {
                if (!(artifact instanceof Artifact)) continue;
                transaction.addArtifact(AtsApiService.get().getQueryServiceIde().getArtifact(artifact));
            }
            for (AtsRelationChange rel : this.relations) {
                this.execute(rel, transaction);
            }
            for (ArtifactId artifact : this.deleteArtifacts) {
                if (!(artifact instanceof Artifact)) continue;
                AtsApiService.get().getQueryServiceIde().getArtifact(artifact).deleteAndPersist(transaction);
            }
            for (IAtsObject atsObject : this.deleteAtsObjects) {
                AtsApiService.get().getQueryServiceIde().getArtifact(atsObject).deleteAndPersist(transaction);
            }
            transactionRecord = transaction.execute();
        }
        catch (Exception ex) {
            transaction.cancel();
            throw OseeCoreException.wrap((Throwable)ex);
        }
        for (IExecuteListener listener : this.listeners) {
            listener.changesStored((IAtsChangeSet)this);
        }
        AtsApiService.get().getNotificationService().sendNotifications(this.getNotifications());
        for (IAtsObject atsObject : new ArrayList(this.atsObjects)) {
            if (!(atsObject instanceof IAtsWorkItem)) continue;
            AtsApiService.get().getWorkDefinitionService().internalClearWorkDefinition((IAtsWorkItem)atsObject);
        }
        return transactionRecord;
    }

    private void execute(AtsRelationChange relChange, SkynetTransaction transaction) {
        Conditions.checkNotNull((Object)relChange, (String)"relChange");
        Conditions.checkNotNull((Object)relChange.getRelationSide(), (String)"relationSide");
        Object obj = relChange.getObject();
        Artifact art = this.getArtifact(obj);
        Conditions.checkNotNull((Object)art, (String)"artifact");
        Collection objects = relChange.getObjects();
        Conditions.checkNotNullOrEmpty((Collection)objects, (String)"objects");
        HashSet<Artifact> arts = new HashSet<Artifact>();
        for (Object obj2 : objects) {
            Artifact art2 = this.getArtifact(obj2);
            Conditions.checkNotNull((Object)art2, (String)"toArtifact");
            arts.add(art2);
        }
        for (Artifact artifact : arts) {
            List relatedArtifacts = art.getRelatedArtifacts(relChange.getRelationSide());
            if (relChange.getOperation() == AtsRelationChange.RelationOperation.Add && !relatedArtifacts.contains(artifact)) {
                art.addRelation(relChange.getRelationSide(), artifact);
                continue;
            }
            if (relChange.getOperation() != AtsRelationChange.RelationOperation.Delete || !relatedArtifacts.contains(artifact)) continue;
            art.deleteRelation(relChange.getRelationSide(), artifact);
        }
        art.persist(transaction);
    }

    private Artifact getArtifact(Object obj) {
        Artifact art = null;
        if (obj instanceof Artifact) {
            art = AtsApiService.get().getQueryServiceIde().getArtifact(obj);
        } else if (obj instanceof IAtsObject) {
            IAtsObject atsObject = (IAtsObject)obj;
            ArtifactToken storeObject = atsObject.getStoreObject();
            if (storeObject != null) {
                art = this.getArtifact(storeObject);
            }
            if (art == null) {
                art = AtsArtifactQuery.getArtifactFromIdOrNull(atsObject.getId());
            }
        } else if (obj instanceof ArtifactId) {
            art = AtsArtifactQuery.getArtifactFromIdOrNull(((ArtifactId)obj).getId());
        }
        if (art == null && obj instanceof Id) {
            IAtsObject atsObject;
            ArtifactId storedArt = this.getStoredArtifact((Id)obj);
            if (storedArt != null && storedArt instanceof Artifact) {
                art = (Artifact)storedArt;
            }
            if (art == null && (atsObject = this.getStoredAtsObject((Id)obj)) != null && atsObject.getStoreObject() instanceof Artifact) {
                art = (Artifact)atsObject.getStoreObject();
            }
        }
        return art;
    }

    public static TransactionId execute(String comment, Object object, Object ... objects) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(comment);
        changes.add(object);
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            changes.add(obj);
            ++n2;
        }
        return changes.execute();
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeToken attributeType) {
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(workItem);
        artifact.deleteSoleAttribute((AttributeTypeId)attributeType);
        this.add(artifact);
    }

    public void setSoleAttributeValue(IAtsWorkItem workItem, AttributeTypeToken attributeType, String value) {
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(workItem);
        artifact.setSoleAttributeValue((AttributeTypeId)attributeType, (Object)value);
        this.add(artifact);
    }

    public void setSoleAttributeValue(IAtsObject atsObject, AttributeTypeToken attributeType, Object value) {
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(atsObject);
        artifact.setSoleAttributeValue((AttributeTypeId)attributeType, value);
        this.add(artifact);
    }

    public void addAttribute(IAtsObject atsObject, AttributeTypeToken attributeType, Object value) {
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(atsObject);
        artifact.addAttribute((AttributeTypeId)attributeType, value);
        this.add(artifact);
    }

    public void deleteAttribute(IAtsObject atsObject, AttributeTypeToken attributeType, Object value) {
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(atsObject);
        artifact.deleteAttribute((AttributeTypeId)attributeType, value);
        this.add(artifact);
    }

    public <T> void setValue(IAtsWorkItem workItem, IAttribute<T> attr, AttributeTypeId attributeType, T value) {
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(workItem);
        Attribute attribute = (Attribute)attr;
        attribute.setValue(value);
        this.add(artifact);
    }

    public <T> void deleteAttribute(IAtsWorkItem workItem, IAttribute<T> attr) {
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(workItem);
        Attribute attribute = (Attribute)attr;
        attribute.delete();
        this.add(artifact);
    }

    public boolean isAttributeTypeValid(IAtsWorkItem workItem, AttributeTypeId attributeType) {
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(workItem);
        return artifact.getAttributeTypes().contains(attributeType);
    }

    public void deleteAttributes(IAtsObject atsObject, AttributeTypeToken attributeType) {
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(atsObject);
        artifact.deleteAttributes((AttributeTypeId)attributeType);
        this.add(artifact);
    }

    public ArtifactToken createArtifact(ArtifactTypeToken artifactType, String name, Long artifactId) {
        Artifact artifact = ArtifactTypeManager.addArtifact((ArtifactTypeToken)artifactType, (BranchToken)AtsApiService.get().getAtsBranch(), (String)name, (Long)artifactId);
        this.add(artifact);
        return artifact;
    }

    public ArtifactToken createArtifact(ArtifactTypeToken artifactType, String name) {
        Artifact artifact = ArtifactTypeManager.addArtifact((ArtifactTypeToken)artifactType, (BranchToken)AtsApiService.get().getAtsBranch(), (String)name);
        this.add(artifact);
        return artifact;
    }

    public void relate(Object object1, RelationTypeSide relationSide, Object object2) {
        Artifact artifact = this.getArtifact(object1);
        Artifact artifact2 = this.getArtifact(object2);
        artifact.addRelation(relationSide, artifact2);
        this.add(artifact);
        this.add(artifact2);
    }

    public void unrelateAll(Object object, RelationTypeSide relationType) {
        Artifact artifact = this.getArtifact(object);
        artifact.deleteRelations(relationType);
        this.add(artifact);
    }

    public void setRelations(Object object, RelationTypeSide relationSide, Collection<? extends Object> objects) {
        Artifact artifact = this.getArtifact(object);
        HashSet<Artifact> artifacts = new HashSet<Artifact>(objects.size());
        for (Object object2 : objects) {
            Artifact art = this.getArtifact(object2);
            if (art == null) continue;
            artifacts.add(art);
            this.add(art);
        }
        artifact.setRelations(relationSide, artifacts);
        this.add(artifact);
    }

    public void setRelationsAndOrder(Object object, RelationTypeSide relationSide, Collection<? extends Object> objects) {
        Artifact artifact = this.getArtifact(object);
        HashSet<Artifact> artifacts = new HashSet<Artifact>(objects.size());
        for (Object object2 : objects) {
            Artifact art = this.getArtifact(object2);
            if (art == null) continue;
            artifacts.add(art);
            this.add(art);
        }
        artifact.setRelations(RelationSorter.USER_DEFINED, relationSide, artifacts);
        this.add(artifact);
    }

    public <T> void setAttribute(IAtsWorkItem workItem, AttributeId attributeId, T value) {
        Conditions.checkExpressionFailOnTrue((boolean)attributeId.isInvalid(), (String)"Can not set attribute by id that has not be persisted.  Attribute Id [%s] Work Item [%s]", (Object[])new Object[]{attributeId, workItem.toStringWithId()});
        Artifact artifact = this.getArtifact(workItem);
        Conditions.checkNotNull((Object)artifact, (String)"artifact");
        boolean found = false;
        for (Attribute attribute : artifact.getAttributes()) {
            if (!attributeId.equals(attribute)) continue;
            attribute.setValue(value);
            found = true;
            break;
        }
        if (!found) {
            throw new OseeStateException("Attribute Id %d does not exist on Artifact %s", new Object[]{attributeId, workItem});
        }
        this.add(artifact);
    }

    public void deleteArtifact(ArtifactId artifact) {
        Artifact art = this.getArtifact(artifact);
        art.delete();
        this.add(art);
    }

    public void setAttributeValues(IAtsObject atsObject, AttributeTypeToken attrType, List<Object> values) {
        Artifact artifact = this.getArtifact(atsObject);
        artifact.setAttributeFromValues((AttributeTypeId)attrType, values);
        this.add(artifact);
    }

    public void setAttributeValues(ArtifactId artifact, AttributeTypeToken attrType, List<Object> values) {
        AtsApiService.get().getQueryServiceIde().getArtifact(artifact).setAttributeFromValues((AttributeTypeId)attrType, values);
        this.add(artifact);
    }

    public <T> void setAttribute(ArtifactId artifact, AttributeId attrId, T value) {
        Conditions.checkExpressionFailOnTrue((boolean)attrId.isInvalid(), (String)"Can not set attribute by id that has not been persisted.  Attribute Id [%s] ArtifactId [%s]", (Object[])new Object[]{attrId, artifact.toString()});
        boolean found = false;
        for (Attribute attribute : this.getArtifact(artifact).getAttributes()) {
            if (!attrId.equals(attribute)) continue;
            attribute.setFromString(String.valueOf(value));
            found = true;
            break;
        }
        if (!found) {
            throw new OseeStateException("Attribute Id %s does not exist on Artifact %s", new Object[]{attrId, artifact});
        }
        this.add(artifact);
    }

    public void deleteAttribute(ArtifactId userArt, IAttribute<?> attr) {
        Artifact artifact = this.getArtifact(userArt);
        artifact.deleteAttribute(attr);
        this.add(artifact);
    }

    public void setSoleAttributeValue(ArtifactId artifact, AttributeTypeToken attrType, Object value) {
        Artifact art = this.getArtifact(artifact);
        art.setSoleAttributeValue((AttributeTypeId)attrType, value);
        this.add(artifact);
    }

    public void unrelate(ArtifactId artifact, RelationTypeSide relationSide, ArtifactId artifact2) {
        Artifact art = this.getArtifact(artifact);
        Artifact art2 = this.getArtifact(artifact2);
        art.deleteRelation(relationSide, art2);
        this.add(art);
        this.add(art2);
    }

    public void addAttribute(ArtifactId artifact, AttributeTypeToken attrType, Object value) {
        Artifact art = this.getArtifact(artifact);
        art.addAttribute((AttributeTypeId)attrType, value);
        this.add(art);
    }

    public void setSoleAttributeFromString(ArtifactId artifact, AttributeTypeGeneric<?> attributeType, String value) {
        Artifact art = this.getArtifact(artifact);
        art.setSoleAttributeFromString(attributeType, value);
        this.add(art);
    }

    public void setSoleAttributeFromStream(ArtifactId artifact, AttributeTypeGeneric<?> attributeType, InputStream inputStream) {
        Artifact art = this.getArtifact(artifact);
        art.setSoleAttributeFromStream(attributeType, inputStream);
        this.add(art);
    }

    public void unrelateFromAll(RelationTypeSide relationSide, ArtifactId artifact) {
        Artifact art = this.getArtifact(artifact);
        art.deleteRelations(relationSide);
    }

    public void addArtifactReferencedAttribute(ArtifactId artifact, AttributeTypeToken attributeType, ArtifactId artifactRef) {
        Artifact art = this.getArtifact(artifact);
        art.addAttributeFromString((AttributeTypeId)attributeType, artifactRef.getIdString());
    }

    public void deleteAttributes(ArtifactId artifact, AttributeTypeToken attributeType) {
        Artifact art = this.getArtifact(artifact);
        art.deleteAttributes((AttributeTypeId)attributeType);
        this.add(art);
    }

    public void setAttributeValuesAsStrings(IAtsObject atsObject, AttributeTypeToken attributeType, List<String> values) {
        LinkedList<Object> objValues = new LinkedList<Object>();
        for (String value : values) {
            if (attributeType.isString()) {
                try {
                    objValues.add(value);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid date value [%v]; must be long date", new Object[]{value});
                }
            }
            if (attributeType.isDate()) {
                try {
                    Date date = new Date(Long.valueOf(value));
                    objValues.add(date);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid date value [%v]; must be long date", new Object[]{value});
                }
            }
            if (attributeType.isDouble()) {
                try {
                    Double double1 = Double.valueOf(value);
                    objValues.add(double1);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid double value [%v]", new Object[]{value});
                }
            }
            if (attributeType.isInteger()) {
                try {
                    Integer integer = Integer.valueOf(value);
                    objValues.add(integer);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid integer value [%v]", new Object[]{value});
                }
            }
            if (attributeType.isLong()) {
                try {
                    Long longVal = Long.valueOf(value);
                    objValues.add(longVal);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid long value [%v]", new Object[]{value});
                }
            }
            if (attributeType.isBoolean()) {
                try {
                    Boolean bool = Boolean.valueOf(value);
                    objValues.add(bool);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid boolean value [%v]", new Object[]{value});
                }
            }
            throw new OseeArgumentException("Unsupported attribute value [%v] for type [%s]", new Object[]{attributeType, value});
        }
        this.setAttributeValues(atsObject, attributeType, objValues);
    }

    public ArtifactToken createArtifact(ArtifactTypeToken artifactType, String name, Long artifactId, String guid) {
        Artifact artifact = ArtifactTypeManager.addArtifact((ArtifactTypeToken)artifactType, (BranchToken)AtsApiService.get().getAtsBranch(), (String)name, (String)guid, (Long)artifactId);
        this.add(artifact);
        return artifact;
    }

    public ArtifactToken createArtifact(ArtifactToken parent, ArtifactTypeToken artType, String name) {
        Artifact artifact = ArtifactTypeManager.addArtifact((ArtifactTypeToken)artType, (BranchToken)AtsApiService.get().getAtsBranch(), (String)name);
        this.addChild((ArtifactId)parent, (ArtifactId)artifact);
        this.add(artifact);
        return artifact;
    }

    public void deleteRelation(RelationId relId) {
        if (relId instanceof RelationLink) {
            RelationLink relation = (RelationLink)relId;
            SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)CoreBranches.COMMON, (String)"Delete Relation");
            relation.delete(false, transaction);
            transaction.addArtifact(relation.getArtifactA());
            transaction.execute();
        }
    }
}

