/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.Import;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.RelatedToStateColumn;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XListDropViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ImportTasksFromSimpleList
extends AbstractBlam {
    public static final String ASSIGNEES = "Assignees";
    public static final String TASK_IMPORT_TITLES = "Task Import Titles";
    public static final String TEAM_WORKFLOW = "Team Workflow (drop here)";
    private TeamWorkFlowArtifact taskableStateMachineArtifact;
    private XCombo stateCombo;

    public String getName() {
        return "Import Tasks From Simple List";
    }

    public void runOperation(final VariableMap variableMap, IProgressMonitor monitor) {
        final String commitComment = ((Object)((Object)this)).getClass().getSimpleName();
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    List artifacts = variableMap.getArtifacts(ImportTasksFromSimpleList.TEAM_WORKFLOW);
                    ArrayList<AtsUser> assignees = new ArrayList<AtsUser>();
                    for (Artifact art : variableMap.getArtifacts(ImportTasksFromSimpleList.ASSIGNEES)) {
                        if (!(art instanceof User)) continue;
                        AtsUser atsUser = AtsApiService.get().getUserService().getUserById((ArtifactId)art);
                        assignees.add(atsUser);
                    }
                    ArrayList<String> titles = new ArrayList<String>();
                    String[] stringArray = variableMap.getString(ImportTasksFromSimpleList.TASK_IMPORT_TITLES).split("\n");
                    int n = stringArray.length;
                    int atsUser = 0;
                    while (atsUser < n) {
                        String title = stringArray[atsUser];
                        if (!(title = title.replaceAll("\r", "")).equals("")) {
                            titles.add(title);
                        }
                        ++atsUser;
                    }
                    if (artifacts.isEmpty()) {
                        AWorkbench.popup((String)"ERROR", (String)"Must drag in Team Workflow to add tasks.");
                        return;
                    }
                    if (artifacts.size() > 1) {
                        AWorkbench.popup((String)"ERROR", (String)"Only drag ONE Team Workflow.");
                        return;
                    }
                    Artifact artifact = (Artifact)artifacts.iterator().next();
                    if (!artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                        AWorkbench.popup((String)"ERROR", (String)"Artifact MUST be Team Workflow");
                        return;
                    }
                    if (titles.isEmpty()) {
                        AWorkbench.popup((String)"ERROR", (String)"Must enter title(s).");
                        return;
                    }
                    try {
                        if (assignees.isEmpty()) {
                            assignees.add(AtsCoreUsers.UNASSIGNED_USER);
                        }
                        IAtsTeamWorkflow teamWf = AtsApiService.get().getWorkItemService().getTeamWf((ArtifactToken)artifact);
                        AtsApiService.get().getTaskService().createTasks(teamWf, titles, assignees, null, AtsApiService.get().getUserService().getCurrentUser(), null, null, null, commitComment);
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                        return;
                    }
                    artifact.reloadAttributesAndRelations();
                    WorkflowEditor.editArtifact(artifact);
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        if (xWidget.getLabel().equals(TEAM_WORKFLOW) && this.taskableStateMachineArtifact != null) {
            final XListDropViewer viewer = (XListDropViewer)xWidget;
            viewer.setInput(Arrays.asList(new Object[]{this.taskableStateMachineArtifact}));
            xWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    List artifacts = viewer.getArtifacts();
                    if (artifacts.isEmpty() || !(artifacts.iterator().next() instanceof TeamWorkFlowArtifact)) {
                        ImportTasksFromSimpleList.this.taskableStateMachineArtifact = null;
                    } else {
                        ImportTasksFromSimpleList.this.taskableStateMachineArtifact = (TeamWorkFlowArtifact)((Object)artifacts.iterator().next());
                    }
                    try {
                        ImportTasksFromSimpleList.this.refreshStateCombo();
                    }
                    catch (OseeStateException ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            });
        } else if (xWidget.getLabel().equals(RelatedToStateColumn.RELATED_TO_STATE_SELECTION)) {
            this.stateCombo = (XCombo)xWidget;
            this.refreshStateCombo();
        }
    }

    private void refreshStateCombo() {
        if (this.stateCombo != null && this.taskableStateMachineArtifact != null) {
            List<String> names = RelatedToStateColumn.getValidInWorkStates(this.taskableStateMachineArtifact);
            this.stateCombo.setDataStrings(names.toArray(new String[names.size()]));
        }
    }

    public String getXWidgetsXml() {
        StringBuffer buffer = new StringBuffer("<xWidgets>");
        buffer.append("<XWidget xwidgetType=\"XListDropViewer\" displayName=\"Team Workflow (drop here)\" />");
        buffer.append("<XWidget xwidgetType=\"XText\" fill=\"Vertically\" height=\"80\" displayName=\"Task Import Titles\" />");
        buffer.append("<XWidget xwidgetType=\"XCombo()\" beginComposite=\"2\" labelAfter=\"true\" height=\"80\" displayName=\"" + RelatedToStateColumn.RELATED_TO_STATE_SELECTION + "\" />");
        buffer.append("<XWidget xwidgetType=\"XHyperlabelMemberSelection\" displayName=\"Assignees\" />");
        buffer.append("</xWidgets>");
        return buffer.toString();
    }

    public String getDescriptionUsage() {
        return "Import tasks from spreadsheet into given Team Workflow.  Assignee for tasks will be current user unless otherwise specified.";
    }

    public void setTaskableStateMachineArtifact(TeamWorkFlowArtifact taskableStateMachineArtifact) {
        this.taskableStateMachineArtifact = taskableStateMachineArtifact;
    }

    public Collection<String> getCategories() {
        return Arrays.asList("ATS");
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }
}

