/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.team.CreateTeamData;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.ai.ModifyActionableItems;
import org.eclipse.osee.ats.core.config.ITeamDefinitionUtility;
import org.eclipse.osee.ats.core.config.TeamDefinitionUtility;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.operation.WorkflowsActiveAisContentProvider;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.util.AtsObjectLabelProvider;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AITreeContentProvider;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AtsObjectNameSorter;
import org.eclipse.osee.ats.ide.workflow.duplicate.DuplicateWorkflowAction;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.XListDropViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTree;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ModifyActionableItemsBlam
extends AbstractBlam {
    private static final String TEAM_WORKFLOW = "Team Workflow (drop here)";
    private TeamWorkFlowArtifact defaultTeamWorkflow;
    private FilteredCheckboxTree wfTree;
    private FilteredCheckboxTree otherTree;
    private FilteredCheckboxTree newTree;
    private XListDropViewer dropViewer;
    private XText resultsText;
    private Set<IAtsActionableItem> currAIsForAllWfs;
    private List<IAtsActionableItem> currWorkflowDesiredAIs;
    private List<IAtsActionableItem> newAIs;
    private WorkflowsActiveAisContentProvider wfAiProvider;

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        if (xWidget.getLabel().equals(TEAM_WORKFLOW)) {
            this.createTreeViewers(xWidget.getControl().getParent());
            this.dropViewer = (XListDropViewer)xWidget;
            if (this.defaultTeamWorkflow != null) {
                this.dropViewer.setInput((Object)this.defaultTeamWorkflow);
            }
            this.dropViewer.addXModifiedListener((XModifiedListener)new DropListener());
            Control control = this.dropViewer.getControl();
            GridData data = new GridData(4, 0, true, false);
            data.heightHint = 20;
            control.setLayoutData((Object)data);
        }
    }

    private void createTreeViewers(Composite parent) {
        Composite treeComp = new Composite(parent, 2048);
        treeComp.setLayout((Layout)new GridLayout(3, true));
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 300;
        treeComp.setLayoutData((Object)data);
        Label wfLabel = new Label(treeComp, 0x1000001);
        wfLabel.setText("This Workflow's Actionable Items\n(select to add to this workflow)");
        Label otherLabel = new Label(treeComp, 0x1000001);
        otherLabel.setText("Actionable Items in other Team Workflows\n(readonly)");
        Label newLabel = new Label(treeComp, 0x1000001);
        newLabel.setText("New Workflows\n(select to create new workflows)");
        this.wfTree = new FilteredCheckboxTree(treeComp, 2850);
        this.wfAiProvider = new WorkflowsActiveAisContentProvider(this.defaultTeamWorkflow == null ? null : this.defaultTeamWorkflow, Active.Active);
        this.wfTree.getViewer().setContentProvider((IContentProvider)this.wfAiProvider);
        this.wfTree.getViewer().setLabelProvider((IBaseLabelProvider)new AtsObjectLabelProvider());
        this.wfTree.getViewer().setComparator((ViewerComparator)new AtsObjectNameSorter());
        this.wfTree.setLayoutData((Object)data);
        this.wfTree.getViewer().addPostSelectionChangedListener((ISelectionChangedListener)new ModificationListener());
        this.otherTree = new FilteredCheckboxTree(treeComp, 2824);
        this.otherTree.getViewer().setContentProvider((IContentProvider)new ArrayTreeContentProvider());
        this.otherTree.getViewer().setLabelProvider((IBaseLabelProvider)new AtsObjectLabelProvider());
        this.otherTree.getViewer().setComparator((ViewerComparator)new AtsObjectNameSorter());
        this.otherTree.setLayoutData((Object)data);
        this.otherTree.setEnabled(false);
        this.newTree = new FilteredCheckboxTree(treeComp, 2850);
        this.newTree.getViewer().setContentProvider((IContentProvider)new AITreeContentProvider(Active.Active));
        this.newTree.getViewer().setLabelProvider((IBaseLabelProvider)new AtsObjectLabelProvider());
        this.newTree.getViewer().setComparator((ViewerComparator)new AtsObjectNameSorter());
        this.newTree.setLayoutData((Object)data);
        this.newTree.getViewer().addPostSelectionChangedListener((ISelectionChangedListener)new ModificationListener());
        this.resultsText = new XText("Results if run");
        this.resultsText.setVerticalLabel(true);
        GridData data2 = new GridData(4, 0, true, false);
        data2.heightHint = 100;
        this.resultsText.setFillHorizontally(true);
        this.resultsText.setFillVertically(true);
        this.resultsText.createWidgets(parent, 1);
        this.resultsText.getStyledText().setLayoutData((Object)data2);
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayout((Layout)new GridLayout(2, true));
        buttonComp.setLayoutData((Object)new GridData(4, 0, true, false));
        Button executeButton = new Button(buttonComp, 16392);
        executeButton.setText("Run");
        executeButton.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.RUN_EXC));
        executeButton.setLayoutData((Object)new GridData(0, 0, true, false));
        executeButton.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                ModifyActionableItemsBlam.this.runOperation(null, null);
            }
        });
        Button advancedDuplicate = new Button(buttonComp, 131080);
        advancedDuplicate.setText("Open Advanced Duplicate Workflow");
        advancedDuplicate.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.DUPLICATE));
        advancedDuplicate.setLayoutData((Object)new GridData(0, 0, true, false));
        advancedDuplicate.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                TeamWorkFlowArtifact teamWf = ModifyActionableItemsBlam.this.getDroppedTeamWf();
                ArrayList<TeamWorkFlowArtifact> teams = new ArrayList<TeamWorkFlowArtifact>();
                if (teamWf != null) {
                    teams.add(teamWf);
                }
                new DuplicateWorkflowAction(teams).run();
            }
        });
        if (this.defaultTeamWorkflow != null) {
            this.refreshTables(this.defaultTeamWorkflow);
        }
    }

    private void refreshTables(final TeamWorkFlowArtifact teamWf) {
        final WorkflowsActiveAisContentProvider fWfAiProvider = this.wfAiProvider;
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (teamWf == null) {
                    ModifyActionableItemsBlam.this.clearTables();
                } else {
                    try {
                        fWfAiProvider.setTeamWf(teamWf);
                        ModifyActionableItemsBlam.this.wfTree.getViewer().setInput((Object)teamWf);
                        Set<IAtsActionableItem> actionableItems = teamWf.getActionableItems();
                        ModifyActionableItemsBlam.this.wfTree.setInitalChecked(actionableItems);
                        HashSet ais = new HashSet();
                        for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemServiceIde().getTeams(teamWf.getParentAction())) {
                            if (!team.notEqual((Id)teamWf)) continue;
                            ais.addAll(team.getActionableItems());
                        }
                        ModifyActionableItemsBlam.this.otherTree.getViewer().setInput(ais);
                        ModifyActionableItemsBlam.this.newTree.getViewer().setInput((Object)AtsApiService.get().getActionableItemService().getTopLevelActionableItems(Active.Active));
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
                ModifyActionableItemsBlam.this.refreshResultsArea(teamWf);
            }
        });
    }

    private void clearTables() {
        List emptyList = Collections.emptyList();
        this.wfTree.getViewer().setInput(emptyList);
        this.wfTree.clearChecked();
        this.otherTree.getViewer().setInput(emptyList);
        this.newTree.getViewer().setInput(emptyList);
        this.newTree.clearChecked();
    }

    private void refreshResultsArea(TeamWorkFlowArtifact teamWf) {
        XResultData results = new XResultData(false);
        this.performModification(teamWf, results, true);
        this.resultsText.setText(results.toString());
    }

    private TeamWorkFlowArtifact getDroppedTeamWf() {
        TeamWorkFlowArtifact teamWf = null;
        List artifacts = this.dropViewer.getArtifacts();
        if (artifacts.size() == 1) {
            teamWf = (TeamWorkFlowArtifact)((Object)artifacts.iterator().next());
        }
        return teamWf;
    }

    private void performModification(TeamWorkFlowArtifact teamWf, XResultData results, boolean logOnly) {
        if (teamWf == null) {
            AWorkbench.popup((String)"Must drop a Team Workflow to modify");
            return;
        }
        try {
            this.currAIsForAllWfs = new HashSet<IAtsActionableItem>();
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemServiceIde().getTeams(teamWf.getParentAction())) {
                this.currAIsForAllWfs.addAll(team.getActionableItems());
            }
            this.currWorkflowDesiredAIs = org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.wfTree.getChecked());
            this.newAIs = org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.newTree.getChecked());
            AtsUser modifiedBy = AtsApiService.get().getUserService().getCurrentUser();
            ModifyActionableItems job = new ModifyActionableItems(results, (IAtsTeamWorkflow)teamWf, this.currAIsForAllWfs, this.currWorkflowDesiredAIs, this.newAIs, modifiedBy, (ITeamDefinitionUtility)new TeamDefinitionUtility(), (AtsApi)AtsApiService.get());
            job.performModification();
            if (!logOnly) {
                if (results.isErrors()) {
                    AWorkbench.popup((String)"Must resolve all errors before running");
                    return;
                }
                ModifyActionableItemOperation op = new ModifyActionableItemOperation(teamWf, results, job);
                Operations.executeAsJob((IOperation)op, (boolean)false, (int)20, (IJobChangeListener)new ModifyActionableItemListener(op));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    List artifacts = ModifyActionableItemsBlam.this.dropViewer.getArtifacts();
                    if (artifacts.isEmpty()) {
                        AWorkbench.popup((String)"ERROR", (String)"Must drag in a Team Workflow to duplicate.");
                        return;
                    }
                    if (artifacts.size() != 1 || !(artifacts.iterator().next() instanceof IAtsTeamWorkflow)) {
                        AWorkbench.popup((String)"ERROR", (String)"Only one Team Workflow can be processed at a time");
                    }
                    XResultData data = new XResultData(false);
                    TeamWorkFlowArtifact teamWf = (TeamWorkFlowArtifact)((Object)artifacts.iterator().next());
                    ModifyActionableItemsBlam.this.performModification(teamWf, data, false);
                    if (data.isErrors()) {
                        XResultDataUI.report((XResultData)data, (String)ModifyActionableItemsBlam.this.getName());
                    }
                    ModifyActionableItemsBlam.this.clearTables();
                    ModifyActionableItemsBlam.this.refreshTables(teamWf);
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
    }

    public boolean showExecuteSection() {
        return false;
    }

    public String getXWidgetsXml() {
        return "<xWidgets><XWidget xwidgetType=\"XListDropViewer\" displayName=\"Team Workflow (drop here)\" /></xWidgets>";
    }

    public String getDescriptionUsage() {
        return "Add, remove or modify actionable items impacted in this Action.";
    }

    public void setDefaultTeamWorkflow(TeamWorkFlowArtifact team) {
        this.defaultTeamWorkflow = team;
    }

    public String getName() {
        return "Modify Actionable Items";
    }

    public Collection<String> getCategories() {
        return Arrays.asList("ATS");
    }

    public void execute(OperationLogger logger, VariableMap variableMap, IJobChangeListener jobChangeListener) {
        this.runOperation(null, null);
    }

    public String getTabTitle() {
        return this.getName();
    }

    public String getTitle() {
        return this.getName();
    }

    public Image getImage() {
        return ImageManager.getImage((KeyedImage)AtsImage.ACTIONABLE_ITEM);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)AtsImage.ACTIONABLE_ITEM);
    }

    public int getWorkflowTreeItemCount() {
        return this.wfTree.getViewer().getTree().getItemCount();
    }

    public int getOtherTreeItemCount() {
        return this.otherTree.getViewer().getTree().getItemCount();
    }

    public int getNewTreeItemCount() {
        return this.newTree.getViewer().getTree().getItemCount();
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }

    private class DropListener
    implements XModifiedListener {
        private DropListener() {
        }

        public void widgetModified(XWidget widget) {
            ModifyActionableItemsBlam.this.refreshTables(ModifyActionableItemsBlam.this.getDroppedTeamWf());
        }
    }

    private class ModificationListener
    implements ISelectionChangedListener {
        private ModificationListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ModifyActionableItemsBlam.this.refreshResultsArea(ModifyActionableItemsBlam.this.getDroppedTeamWf());
        }
    }

    public class ModifyActionableItemListener
    extends JobChangeAdapter {
        private final ModifyActionableItemOperation op;

        public ModifyActionableItemListener(ModifyActionableItemOperation op) {
            this.op = op;
        }

        public void done(IJobChangeEvent event) {
            super.done(event);
            List<IAtsTeamWorkflow> newTeamWfs = this.op.getNewTeamWfs();
            ModifyActionableItemsBlam.this.refreshTables(this.op.getTeamWf());
            if (!newTeamWfs.isEmpty()) {
                AtsEditors.openInAtsWorldEditor("New Team Workflows", newTeamWfs);
            }
        }
    }

    public class ModifyActionableItemOperation
    extends AbstractOperation {
        private final ModifyActionableItems job;
        List<IAtsTeamWorkflow> newTeamWfs;
        private final TeamWorkFlowArtifact teamWf;
        private final XResultData results;

        public TeamWorkFlowArtifact getTeamWf() {
            return this.teamWf;
        }

        public ModifyActionableItemOperation(TeamWorkFlowArtifact teamWf, XResultData results, ModifyActionableItems job) {
            super("Modify Actionable Items", "org.eclipse.osee.ats.ide");
            this.newTeamWfs = new ArrayList<IAtsTeamWorkflow>();
            this.teamWf = teamWf;
            this.results = results;
            this.job = job;
        }

        protected void doWork(IProgressMonitor monitor) throws Exception {
            IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getName());
            Date createdDate = new Date();
            for (CreateTeamData data : this.job.getTeamDatas()) {
                IAtsTeamWorkflow newTeamWf = AtsApiService.get().getActionService().createTeamWorkflow(this.teamWf.getParentAction(), data.getTeamDef(), data.getActionableItems(), new LinkedList(data.getAssignees()), changes, createdDate, data.getCreatedBy(), null, data.getCreateTeamOption());
                this.newTeamWfs.add(newTeamWf);
            }
            for (IAtsActionableItem checkedAi : this.job.getAddAis()) {
                this.results.logf("Actionable Item [%s] will be added to this workflow\n", new Object[]{checkedAi});
                AtsApiService.get().getActionableItemService().addActionableItem((IAtsWorkItem)this.teamWf, checkedAi, changes);
            }
            for (IAtsActionableItem currAi : this.job.getRemoveAis()) {
                this.results.logf("Actionable Item [%s] will be removed from this workflow\n", new Object[]{currAi});
                AtsApiService.get().getActionableItemService().removeActionableItem((IAtsWorkItem)this.teamWf, currAi, changes);
                changes.add((Object)this.teamWf);
            }
            if (!changes.isEmpty()) {
                changes.execute();
            }
        }

        public List<IAtsTeamWorkflow> getNewTeamWfs() {
            return this.newTeamWfs;
        }
    }
}

