/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.SearchNavigateItem;
import org.eclipse.osee.ats.ide.search.AtsSearchWorkflowSearchItem;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.world.AtsWorldEditorItems;
import org.eclipse.osee.ats.ide.world.IAtsWorldEditorItem;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class SavedActionSearchNavigateItem
extends XNavigateItem {
    private static SavedActionSearchNavigateItem topNavigateItem;

    public SavedActionSearchNavigateItem() {
        super(null, null, null);
    }

    public SavedActionSearchNavigateItem(XNavigateItem parent) {
        super(parent, "Saved Action Searches", (KeyedImage)AtsImage.SEARCH);
        topNavigateItem = this;
        this.refresh();
    }

    public void refresh() {
        if (topNavigateItem != null) {
            Thread refresh = new Thread(((Object)((Object)topNavigateItem)).getClass().getSimpleName()){

                @Override
                public void run() {
                    super.run();
                    topNavigateItem.getChildren().clear();
                    SavedActionSearchNavigateItem.this.load();
                    if (SavedActionSearchNavigateItem.this.refresher != null) {
                        Displays.ensureInDisplayThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                SavedActionSearchNavigateItem.this.refresher.refresh((XNavigateItem)topNavigateItem);
                            }
                        });
                    }
                }
            };
            refresh.start();
        }
    }

    public static void refreshItems() {
        topNavigateItem.refresh();
    }

    private void load() {
        try {
            AtsApiIde atsApi = AtsApiService.get();
            AtsUser currentUser = atsApi.getConfigService().getCurrentUserByLoginId();
            if (topNavigateItem.getChildren() != null) {
                topNavigateItem.getChildren().clear();
            }
            HashSet<Long> ids = new HashSet<Long>();
            for (IAtsWorldEditorItem worldEditorItem : AtsWorldEditorItems.getItems()) {
                for (AtsSearchWorkflowSearchItem item : worldEditorItem.getSearchWorkflowSearchItems()) {
                    ArrayList savedSearches = atsApi.getQueryService().getSavedSearches(currentUser, item.getNamespace());
                    for (AtsSearchData data : savedSearches) {
                        if (ids.contains(data.getId())) continue;
                        AtsSearchWorkflowSearchItem searchItem = item.copy();
                        searchItem.setSavedData(data);
                        SearchNavigateItem navItem = new SearchNavigateItem(topNavigateItem, searchItem);
                        navItem.setName(String.valueOf(item.getShortNamePrefix()) + ": " + data.getSearchName());
                        ids.add(data.getId());
                    }
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(SavedActionSearchNavigateItem.class, (Level)Level.WARNING, (String)"Error populating searches", (Throwable)ex);
        }
    }
}

