/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.core.workflow.util.ChangeTypeUtil;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.config.version.VersionMetrics;
import org.eclipse.osee.ats.ide.config.version.VersionTeamMetrics;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionDialog;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.result.Manipulations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class FirstTimeQualityMetricReportItem
extends XNavigateItemAction {
    private static final String[] HEADER_STRINGS = new String[]{"Version", "StartDate", "RelDate", "Num 1 + 2 Orig During Next Release Cycle", "Num Non-Support Released", "Ratio Orig 1 and 2 Bugs/Number Released"};

    public FirstTimeQualityMetricReportItem(XNavigateItem parent) {
        super(parent, "First Time Quality Metric Report", (KeyedImage)AtsImage.REPORT);
    }

    public String getDescription() {
        return "This report will genereate a metric comprised of:\n\n# of priority 1 and 2 OSEE problem actions orginated between release\n__________________________________\n# of non-support actions in that released";
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        IAtsTeamDefinition useTeamDef = null;
        TeamDefinitionDialog dialog = new TeamDefinitionDialog(this.getName(), this.getName());
        Set teamReleaseableDefinitions = null;
        try {
            teamReleaseableDefinitions = AtsApiService.get().getTeamDefinitionService().getTeamReleaseableDefinitions(Active.Both);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Error loading team definitions", (Throwable)ex);
        }
        dialog.setInput(teamReleaseableDefinitions);
        int result = dialog.open();
        if (result == 0) {
            if (dialog.getSelectedFirst() == null) {
                AWorkbench.popup((String)"ERROR", (String)"You must select a team to operate against.");
                return;
            }
        } else {
            return;
        }
        useTeamDef = (IAtsTeamDefinition)dialog.getSelectedFirst();
        ReportJob job = new ReportJob(this.getName(), useTeamDef);
        job.setUser(true);
        job.setPriority(30);
        job.schedule();
    }

    public static String getTeamWorkflowReport(String title, IAtsTeamDefinition teamDef, IProgressMonitor monitor) {
        StringBuilder sb = new StringBuilder();
        sb.append(AHTML.heading((int)3, (String)title));
        sb.append(AHTML.beginMultiColumnTable((int)100, (int)1));
        sb.append(AHTML.addRowSpanMultiColumnTable((String)"This report shows the ratio of 1+2 problem workflows created during next release cycle due to current release over the total non-support workflows during this release.", (int)HEADER_STRINGS.length));
        sb.append(AHTML.addHeaderRowMultiColumnTable((String[])HEADER_STRINGS));
        VersionTeamMetrics teamMet = new VersionTeamMetrics(teamDef);
        List<VersionMetrics> verMets = teamMet.getReleasedOrderedVersions();
        monitor.beginTask("Processing Versions", verMets.size());
        for (VersionMetrics verMet : verMets) {
            Date thisReleaseStartDate = verMet.getReleaseStartDate();
            Date thisReleaseEndDate = AtsApiService.get().getVersionService().getReleaseDate(verMet.getVerArt());
            Date nextReleaseStartDate = null;
            Date nextReleaseEndDate = null;
            VersionMetrics nextVerMet = verMet.getNextVerMetViaReleaseDate();
            if (nextVerMet != null) {
                nextReleaseStartDate = nextVerMet.getReleaseStartDate();
                nextReleaseEndDate = AtsApiService.get().getVersionService().getReleaseDate(nextVerMet.getVerArt());
            }
            Integer numOrigDurningNextReleaseCycle = 0;
            if (nextReleaseStartDate != null && nextReleaseEndDate != null) {
                Collection<TeamWorkFlowArtifact> arts = teamMet.getWorkflowsOriginatedBetween(nextReleaseStartDate, nextReleaseEndDate);
                for (TeamWorkFlowArtifact team : arts) {
                    String priorityStr = (String)team.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Priority, "");
                    if (team.isCancelled() || ChangeTypeUtil.getChangeType((IAtsWorkItem)team, (AtsApi)AtsApiService.get()) != ChangeType.Problem || !priorityStr.equals("1") && !priorityStr.equals("2")) continue;
                    numOrigDurningNextReleaseCycle = numOrigDurningNextReleaseCycle + 1;
                }
            }
            Integer numNonSupportReleased = null;
            if (thisReleaseEndDate != null) {
                numNonSupportReleased = 0;
                for (TeamWorkFlowArtifact team : verMet.getTeamWorkFlows(ChangeType.Problem, ChangeType.Improvement)) {
                    if (team.isCancelled()) continue;
                    numNonSupportReleased = numNonSupportReleased + 1;
                }
            }
            sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{verMet.getVerArt().getName(), DateUtil.getMMDDYY((Date)thisReleaseStartDate), DateUtil.getMMDDYY((Date)thisReleaseEndDate), numOrigDurningNextReleaseCycle == 0 ? "N/A" : String.valueOf(numOrigDurningNextReleaseCycle), numNonSupportReleased == null ? "N/A" : String.valueOf(numNonSupportReleased), numOrigDurningNextReleaseCycle == 0 || numNonSupportReleased == null || numNonSupportReleased == 0 ? "N/A" : AtsUtil.doubleToI18nString((double)((double)numOrigDurningNextReleaseCycle.intValue() / (double)numNonSupportReleased.intValue()))}));
            monitor.worked(1);
        }
        sb.append(AHTML.endMultiColumnTable());
        return sb.toString();
    }

    private static class ReportJob
    extends Job {
        private final IAtsTeamDefinition teamDef;

        public ReportJob(String title, IAtsTeamDefinition teamDef) {
            super(title);
            this.teamDef = teamDef;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                XResultData resultData = new XResultData();
                String html = FirstTimeQualityMetricReportItem.getTeamWorkflowReport(this.getName(), this.teamDef, monitor);
                resultData.addRaw(html);
                XResultDataUI.report((XResultData)resultData, (String)this.getName(), (Manipulations[])new Manipulations[]{Manipulations.RAW_HTML});
            }
            catch (Exception ex) {
                return new Status(4, "org.eclipse.osee.ats.ide", -1, ex.toString(), (Throwable)ex);
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

