/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.section;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.access.IAtsAccessService;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WfeDetailsSection
extends SectionPart {
    private Browser browser;
    private final WorkflowEditor editor;
    private boolean sectionCreated = false;

    public WfeDetailsSection(WorkflowEditor editor, Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style | 2 | 0x100);
        this.editor = editor;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        Section section = this.getSection();
        section.setText("Details");
        section.setLayout((Layout)new GridLayout());
        section.setExpanded(false);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        section.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                WfeDetailsSection.this.createSection();
            }
        });
    }

    private synchronized void createSection() {
        if (!this.sectionCreated) {
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            Composite composite = toolkit.createComposite((Composite)this.getSection(), toolkit.getBorderStyle() | 0x40);
            composite.setLayout((Layout)ALayout.getZeroMarginLayout());
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (Widgets.isAccessible((Widget)WfeDetailsSection.this.browser)) {
                        WfeDetailsSection.this.browser.dispose();
                    }
                }
            });
            this.browser = new Browser(composite, 0);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 200;
            gd.heightHint = 300;
            this.browser.setLayoutData((Object)gd);
            this.getSection().setClient((Control)composite);
            toolkit.paintBordersFor(composite);
            this.sectionCreated = true;
        }
        this.refresh();
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this.browser)) {
            AbstractWorkflowArtifact workItem = this.editor.getWorkItem();
            try {
                Map smaDetails = Artifacts.getDetailsKeyValues((Artifact)((Artifact)workItem.getStoreObject()));
                this.addSMADetails(workItem, smaDetails);
                FontData systemFont = this.browser.getDisplay().getSystemFont().getFontData()[0];
                String formattedDetails = Artifacts.getDetailsFormText((Map)smaDetails, (String)systemFont.getName(), (int)systemFont.getHeight());
                this.browser.setText(formattedDetails);
            }
            catch (Exception ex) {
                this.browser.setText(Lib.exceptionToString((Exception)ex));
            }
            this.getManagedForm().reflow(true);
        }
    }

    private void addSMADetails(IAtsWorkItem workItem, Map<String, String> details) {
        details.put("Workflow Definition", workItem.getWorkDefinition().getName());
        IAtsAction parentAction = workItem.getParentAction();
        if (parentAction == null) {
            details.put("Action Id", "No Parent Action");
        } else {
            details.put("Action Id", parentAction.getAtsId());
        }
        if (!workItem.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow}) && workItem.getParentTeamWorkflow() != null) {
            details.put("Parent Team Workflow Id", workItem.getParentTeamWorkflow().getAtsId());
        }
        if (workItem.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            details.put("Working Branch Access Context Id", this.getAccessContextId((TeamWorkFlowArtifact)workItem));
        }
    }

    private String getAccessContextId(TeamWorkFlowArtifact workflow) {
        String message;
        IAtsAccessService accessService = AtsApiService.get().getAtsAccessService();
        BranchToken workingBranch = null;
        try {
            workingBranch = workflow.getWorkingBranch();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        Collection ids = null;
        if (workingBranch == null) {
            try {
                ids = accessService.getFromWorkflow((IAtsTeamWorkflow)workflow);
                message = ids.toString();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                message = String.format("Error getting context id [%s]", ex.getMessage());
            }
        } else {
            try {
                ids = accessService.getContextIds((BranchId)workingBranch);
                message = ids.toString();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                message = String.format("Error getting context id [%s]", ex.getMessage());
            }
        }
        return message;
    }

    public boolean isDisposed() {
        return this.browser == null || this.browser.isDisposed();
    }
}

