/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.review.AbstractReviewArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WfeRelationsHyperlinkComposite
extends Composite {
    private static RelationTypeSide[] sides = new RelationTypeSide[]{AtsRelationTypes.TeamWorkflowToReview_Review, AtsRelationTypes.TeamWorkflowToReview_TeamWorkflow, CoreRelationTypes.Supercedes_SupercededBy, CoreRelationTypes.Supercedes_Supercedes, CoreRelationTypes.SupportingInfo_IsSupportedBy, CoreRelationTypes.SupportingInfo_SupportingInfo, AtsRelationTypes.Derive_From, AtsRelationTypes.Derive_To, CoreRelationTypes.Dependency_Artifact, CoreRelationTypes.Dependency_Dependency};
    private final WorkflowEditor editor;
    private final IAtsWorkItem workItem;
    private final HashCollection<Long, Hyperlink> relIdToHyperlink = new HashCollection();
    private final Map<Long, Label> relIdToLabel = new HashMap<Long, Label>();
    private final Set<Long> existingRels = new HashSet<Long>();

    public WfeRelationsHyperlinkComposite(Composite parent, int style, WorkflowEditor editor) {
        super(parent, style);
        this.editor = editor;
        this.workItem = editor.getWorkItem();
    }

    public void create() {
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.setLayoutData(gd);
        this.editor.getToolkit().adapt((Composite)this);
        this.createUpdateLinks();
    }

    private void createUpdateLinks() {
        AbstractWorkflowArtifact workItemArt = (AbstractWorkflowArtifact)this.workItem;
        this.existingRels.addAll(this.relIdToHyperlink.keySet());
        if (workItemArt.isTeamWorkflow() && workItemArt.getWorkDefinition().getHeaderDef().isShowSiblingLinks()) {
            for (RelationLink relation : ((Artifact)workItemArt.getParentAction()).getRelations(AtsRelationTypes.ActionToWorkflow_TeamWorkflow)) {
                if (relation.getArtifactB().equals((Object)workItemArt)) continue;
                if (this.existingRels.contains(relation.getId())) {
                    this.existingRels.remove(relation.getId());
                    continue;
                }
                this.createLink((Artifact)workItemArt, " has sibling ", relation.getArtifactB(), AtsRelationTypes.ActionToWorkflow_TeamWorkflow, relation, OpenType.Open);
            }
        }
        this.createLink((Artifact)workItemArt, "is reviewed by", AtsRelationTypes.TeamWorkflowToReview_Review, OpenType.Open);
        this.createLink((Artifact)workItemArt, "reviews", AtsRelationTypes.TeamWorkflowToReview_TeamWorkflow, OpenType.Open);
        this.createLink((Artifact)workItemArt, "is superceded by", CoreRelationTypes.Supercedes_SupercededBy, OpenType.Open);
        this.createLink((Artifact)workItemArt, "supercedes", CoreRelationTypes.Supercedes_Supercedes, OpenType.Open);
        this.createLink((Artifact)workItemArt, "depends on", CoreRelationTypes.Dependency_Dependency, OpenType.Open);
        this.createLink((Artifact)workItemArt, "is dependency of", CoreRelationTypes.Dependency_Artifact, OpenType.Open);
        this.createLink((Artifact)workItemArt, "is derived from", AtsRelationTypes.Derive_From, OpenType.Open);
        this.createLink((Artifact)workItemArt, "derived", AtsRelationTypes.Derive_To, OpenType.Open);
        this.createLink((Artifact)workItemArt, "is supported info for", CoreRelationTypes.SupportingInfo_IsSupportedBy, OpenType.Read, OpenType.Edit, OpenType.Delete);
        this.createLink((Artifact)workItemArt, "has supporting info", CoreRelationTypes.SupportingInfo_SupportingInfo, OpenType.Read, OpenType.Edit, OpenType.Delete);
        if (!this.existingRels.isEmpty()) {
            this.removeRelations(this.existingRels);
        }
        this.layout(true, true);
        this.getParent().layout(true, true);
        this.editor.getWorkFlowTab().getManagedForm().reflow(true);
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this)) {
            this.createUpdateLinks();
        }
    }

    private void removeRelations(final Set<Long> existingRels) {
        final WfeRelationsHyperlinkComposite fComp = this;
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Widgets.isAccessible((Widget)fComp) && WfeRelationsHyperlinkComposite.this.relIdToHyperlink != null) {
                    for (Long relationId : existingRels) {
                        if (WfeRelationsHyperlinkComposite.this.relIdToHyperlink.getValues((Object)relationId) == null) continue;
                        for (Hyperlink link : (List)WfeRelationsHyperlinkComposite.this.relIdToHyperlink.getValues((Object)relationId)) {
                            if (link == null) continue;
                            link.dispose();
                        }
                        WfeRelationsHyperlinkComposite.this.relIdToHyperlink.removeValues((Object)relationId);
                        Label label = (Label)WfeRelationsHyperlinkComposite.this.relIdToLabel.get(relationId);
                        if (label != null) {
                            label.dispose();
                        }
                        WfeRelationsHyperlinkComposite.this.relIdToLabel.remove(relationId);
                    }
                }
            }
        });
    }

    public static boolean relationExists(AbstractWorkflowArtifact workItem) {
        if (workItem.isTeamWorkflow()) {
            boolean siblings;
            boolean bl = siblings = ((IAtsTeamWorkflow)workItem).getParentAction().getTeamWorkflows().size() > 1;
            if (siblings) {
                return true;
            }
        }
        RelationTypeSide[] relationTypeSideArray = sides;
        int n = sides.length;
        int n2 = 0;
        while (n2 < n) {
            RelationTypeSide side = relationTypeSideArray[n2];
            if (workItem.getRelatedArtifacts(side).size() > 0) {
                return true;
            }
            ++n2;
        }
        return workItem instanceof AbstractReviewArtifact && AtsApiService.get().getActionableItemService().hasActionableItems((IAtsWorkItem)workItem);
    }

    private String getCompletedCancelledString(Artifact art) {
        if (art instanceof AbstractWorkflowArtifact && ((AbstractWorkflowArtifact)art).isCompletedOrCancelled()) {
            return " " + ((AbstractWorkflowArtifact)art).getStateMgr().getCurrentStateName() + " ";
        }
        return "";
    }

    public void createLink(Artifact thisArt, String action, RelationTypeSide relationSide, OpenType ... openType) {
        for (RelationLink relation : thisArt.getRelations(relationSide)) {
            if (this.existingRels.contains(relation.getId())) {
                this.existingRels.remove(relation.getId());
                continue;
            }
            Artifact thatArt = relation.getArtifactA();
            if (relation.getArtifactA().equals((Object)thisArt)) {
                thatArt = relation.getArtifactB();
            }
            this.createLink(thisArt, action, thatArt, relationSide, relation, openType);
        }
    }

    private void createLink(final Artifact thisArt, final String action, final Artifact thatArt, RelationTypeSide relationSide, final RelationLink relation, final OpenType ... openType) {
        final WfeRelationsHyperlinkComposite fComp = this;
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Hyperlink link;
                    Composite lComp = new Composite(fComp, 0);
                    lComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)4, (boolean)false));
                    GridData gd = new GridData(768);
                    gd.widthHint = 500;
                    lComp.setLayoutData((Object)gd);
                    WfeRelationsHyperlinkComposite.this.editor.getToolkit().adapt(lComp);
                    lComp.setBackground(Displays.getSystemColor((int)1));
                    String labelStr = "This " + action + WfeRelationsHyperlinkComposite.this.getCompletedCancelledString(thatArt) + " \"" + WfeRelationsHyperlinkComposite.this.getObjectTeamOrType(thatArt) + "\" " + thatArt.toStringWithId(60);
                    Label label = WfeRelationsHyperlinkComposite.this.editor.getToolkit().createLabel(lComp, labelStr);
                    Set openTypes = Collections.asHashSet((Object[])openType);
                    if (openTypes.contains((Object)OpenType.Read)) {
                        link = WfeRelationsHyperlinkComposite.createReadHyperlink(thisArt, thatArt, lComp, WfeRelationsHyperlinkComposite.this.editor, OpenType.Read.name());
                        WfeRelationsHyperlinkComposite.this.relIdToLabel.put(Long.valueOf(relation.getId()), label);
                        WfeRelationsHyperlinkComposite.this.relIdToHyperlink.put((Object)relation.getId(), (Object)link);
                    }
                    if (openTypes.contains((Object)OpenType.Open)) {
                        link = WfeRelationsHyperlinkComposite.createReadHyperlink(thisArt, thatArt, lComp, WfeRelationsHyperlinkComposite.this.editor, OpenType.Open.name());
                        WfeRelationsHyperlinkComposite.this.relIdToLabel.put(Long.valueOf(relation.getId()), label);
                        WfeRelationsHyperlinkComposite.this.relIdToHyperlink.put((Object)relation.getId(), (Object)link);
                    }
                    if (openTypes.contains((Object)OpenType.Edit)) {
                        link = WfeRelationsHyperlinkComposite.createEditHyperlink(thatArt, lComp, WfeRelationsHyperlinkComposite.this.editor);
                        WfeRelationsHyperlinkComposite.this.relIdToHyperlink.put((Object)relation.getId(), (Object)link);
                        WfeRelationsHyperlinkComposite.this.relIdToLabel.put(Long.valueOf(relation.getId()), label);
                    }
                    if (openTypes.contains((Object)OpenType.Delete)) {
                        link = WfeRelationsHyperlinkComposite.createDeleteHyperlink(thisArt, thatArt, relation, lComp, WfeRelationsHyperlinkComposite.this.editor);
                        WfeRelationsHyperlinkComposite.this.relIdToHyperlink.put((Object)relation.getId(), (Object)link);
                        WfeRelationsHyperlinkComposite.this.relIdToLabel.put(Long.valueOf(relation.getId()), label);
                    }
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        });
    }

    private String getObjectTeamOrType(Artifact art) {
        if (art instanceof IAtsTeamWorkflow) {
            return ((IAtsTeamWorkflow)art).getTeamDefinition().getName();
        }
        return art.getArtifactTypeName();
    }

    public static Hyperlink createDeleteHyperlink(final Artifact thisArt, final Artifact thatArt, final RelationLink relation, Composite lComp, WorkflowEditor editor) {
        Hyperlink link = editor.getToolkit().createHyperlink(lComp, "Delete", 0);
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                Artifact delArt = thatArt;
                if (thatArt instanceof IAtsWorkItem) {
                    delArt = thisArt;
                }
                List<ArtifactToken> related = Arrays.asList(thatArt);
                if (thatArt instanceof IAtsObject) {
                    if (MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Delete Related", (String)"You do not have permissions to delete ATS Objects.  Would you Like to Un-Relate?")) {
                        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Delete Relation");
                        changes.deleteRelation((RelationId)relation);
                        changes.execute();
                    }
                    return;
                }
                XResultData results = AtsApiService.get().getAccessControlService().isDeleteable(related, new XResultData());
                if (results.isErrors()) {
                    AWorkbench.popup((String)results.toString());
                    return;
                }
                if (MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Delete Related", (String)("Are you sure you want to delete related artifact\n\n" + delArt.toStringWithId() + " ?"))) {
                    IAtsChangeSet changes = AtsApiService.get().createChangeSet("Delete Related Artifact");
                    changes.deleteArtifact((ArtifactId)delArt);
                    changes.execute();
                }
            }
        });
        return link;
    }

    public static Hyperlink createEditHyperlink(final Artifact thatArt, Composite lComp, WorkflowEditor editor) {
        Hyperlink link = editor.getToolkit().createHyperlink(lComp, "Edit", 0);
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                if (AtsObjects.isAtsWorkItemOrAction((Object)thatArt)) {
                    AtsEditors.openATSAction((ArtifactToken)thatArt, AtsOpenOption.OpenOneOrPopupSelect);
                } else {
                    try {
                        RendererManager.open((Artifact)thatArt, (PresentationType)PresentationType.SPECIALIZED_EDIT);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            }
        });
        return link;
    }

    public static Hyperlink createReadHyperlink(Artifact thisArt, final Artifact thatArt, Composite lComp, WorkflowEditor editor, String label) {
        Hyperlink link = editor.getToolkit().createHyperlink(lComp, label, 0);
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                if (AtsObjects.isAtsWorkItemOrAction((Object)thatArt)) {
                    AtsEditors.openATSAction((ArtifactToken)thatArt, AtsOpenOption.OpenOneOrPopupSelect);
                } else {
                    try {
                        RendererManager.open((Artifact)thatArt, (PresentationType)PresentationType.DEFAULT_OPEN);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            }
        });
        return link;
    }

    public static enum OpenType {
        Open,
        Read,
        Edit,
        Delete,
        ArtifactEditor;

    }
}

