/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.note.NoteItem;
import org.eclipse.osee.ats.core.workflow.WorkflowManagerCore;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeActionableItemHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeActionableItemReviewHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeAssigneesHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeBlockedWorkflowHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeCustomHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeDragAndDrop;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeHoldWorkflowHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeMetricsHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeRelationsHyperlinkComposite;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeStateCreatedOrigHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeTargetedVersionHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeTeamAndIdsHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeTitleHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeTransitionHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeWorkPackage;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.DuplicateWidgetUpdateResolver;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workdef.StateXWidgetPage;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.WorkflowManager;
import org.eclipse.osee.ats.ide.workflow.hooks.IAtsWorkItemHookIde;
import org.eclipse.osee.ats.ide.workflow.review.AbstractReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.XFormToolkit;
import org.eclipse.osee.framework.ui.skynet.artifact.annotation.AnnotationComposite;
import org.eclipse.osee.framework.ui.skynet.artifact.annotation.AttributeAnnotationManager;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactStoredWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class WfeHeaderComposite
extends Composite {
    private final WorkflowEditor editor;
    private final IAtsWorkItem workItem;
    private WfeRelationsHyperlinkComposite relationsComposite;
    private WfeActionableItemHeader actionableItemHeader;
    private WfeMetricsHeader metricsHeader;
    private final StateXWidgetPage currentStateXWidgetPage;
    private static Color LIGHT_GREY;
    private final IManagedForm managedForm;
    private WfeCustomHeader customHeader;
    private WfeTitleHeader titleHeader;
    private WfeTransitionHeader transitionHeader;
    private WfeStateCreatedOrigHeader stateHeader;
    private WfeTeamAndIdsHeader teamHeader;
    private WfeTargetedVersionHeader versionHeader;
    private WfeAssigneesHeader assigneeHeader;
    private WfeWorkPackage workPackageHeader;
    private WfeActionableItemReviewHeader aiReviewHeader;
    final XModifiedListener xModListener = new XModifiedListener(){

        public void widgetModified(XWidget xWidget) {
            try {
                if (AtsApiService.get().getStoreService().isDeleted((IAtsObject)WfeHeaderComposite.this.workItem)) {
                    return;
                }
                for (IAtsWorkItemHookIde item : AtsApiService.get().getWorkItemServiceIde().getWorkItemHooksIde()) {
                    try {
                        item.widgetModified(xWidget, (FormToolkit)WfeHeaderComposite.this.editor.getToolkit(), WfeHeaderComposite.this.workItem.getStateDefinition(), (Artifact)WfeHeaderComposite.this.workItem, WorkflowManagerCore.isEditable((AtsUser)AtsApiService.get().getUserService().getCurrentUser(), (IAtsWorkItem)WfeHeaderComposite.this.workItem, (IAtsStateDefinition)WfeHeaderComposite.this.workItem.getStateDefinition(), (IAtsUserService)AtsApiService.get().getUserService()));
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
                DuplicateWidgetUpdateResolver.updateDuplicateWidgets(WfeHeaderComposite.this.managedForm, (AbstractWorkflowArtifact)WfeHeaderComposite.this.workItem, xWidget);
                WfeHeaderComposite.this.editor.onDirtied();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    };
    private WfeBlockedWorkflowHeader blockedWfHeader;
    private WfeHoldWorkflowHeader holdWfHeader;

    public WfeTransitionHeader getWfeTransitionComposite() {
        return this.transitionHeader;
    }

    public WfeHeaderComposite(Composite parent, int style, WorkflowEditor editor, StateXWidgetPage currentStateXWidgetPage, IManagedForm managedForm) {
        super(parent, style);
        this.editor = editor;
        this.currentStateXWidgetPage = currentStateXWidgetPage;
        this.managedForm = managedForm;
        this.workItem = editor.getWorkItem();
    }

    public void refresh() {
        if (this.titleHeader != null) {
            this.titleHeader.refresh();
        }
        if (this.stateHeader != null) {
            this.stateHeader.refresh();
        }
        if (this.teamHeader != null) {
            this.teamHeader.refresh();
        }
        if (this.versionHeader != null) {
            this.versionHeader.refresh();
        }
        if (this.assigneeHeader != null) {
            this.assigneeHeader.refresh();
        }
        if (this.actionableItemHeader != null) {
            this.actionableItemHeader.refresh();
        }
        if (this.metricsHeader != null) {
            this.metricsHeader.refresh();
        }
        if (this.workPackageHeader != null) {
            this.workPackageHeader.refresh();
        }
        if (this.relationsComposite != null) {
            this.relationsComposite.refresh();
        }
        if (this.transitionHeader != null) {
            this.transitionHeader.refresh();
        }
        if (this.blockedWfHeader != null) {
            this.blockedWfHeader.refresh();
        }
        if (this.holdWfHeader != null) {
            this.holdWfHeader.refresh();
        }
        if (this.aiReviewHeader != null) {
            this.aiReviewHeader.refresh();
        }
        if (this.customHeader != null) {
            this.customHeader.refresh();
        }
    }

    public void create() {
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        this.setLayoutData(gd);
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        try {
            this.titleHeader = new WfeTitleHeader(this, 0, this.workItem, this.editor, this.xModListener);
            this.stateHeader = new WfeStateCreatedOrigHeader(this, 0, this.workItem, this.editor);
            this.teamHeader = new WfeTeamAndIdsHeader(this, 0, this.workItem, this.editor);
            this.createTargetVersionAndAssigneeHeader(this, this.currentStateXWidgetPage, this.editor.getToolkit());
            this.createLatestHeader(this, this.editor.getToolkit());
            if (this.workItem.isTeamWorkflow()) {
                this.actionableItemHeader = new WfeActionableItemHeader(this, this.editor.getToolkit(), this.workItem, this.editor);
            }
            if (this.workItem.getWorkDefinition().getHeaderDef().isShowMetricsHeader()) {
                this.metricsHeader = new WfeMetricsHeader(this, this.editor.getToolkit(), this.workItem, this.editor, this.managedForm);
            }
            int workPackageNumColumns = 2;
            if (this.workItem.getWorkDefinition().getHeaderDef().isShowWorkPackageHeader()) {
                this.createWorkPacakageHeader(this, this.editor.getToolkit(), workPackageNumColumns, this.editor);
            }
            int numColumns = 4;
            WfeHeaderComposite.createWorkDefHeader(this, this.editor.getToolkit(), this.workItem, numColumns);
            this.blockedWfHeader = new WfeBlockedWorkflowHeader(this, 0, this.workItem, this.editor);
            this.holdWfHeader = new WfeHoldWorkflowHeader(this, 0, this.workItem, this.editor);
            this.customHeader = this.createCustomHeader(this, this.editor.getToolkit(), this.workItem, this.editor, this.managedForm);
            this.createSMANotesHeader(this, this.editor.getToolkit(), numColumns);
            WfeHeaderComposite.createStateNotesHeader(this, this.workItem, this.editor.getToolkit(), numColumns, null);
            this.createAnnotationsHeader(this, this.editor.getToolkit());
            if (WfeRelationsHyperlinkComposite.relationExists((AbstractWorkflowArtifact)this.workItem)) {
                this.relationsComposite = new WfeRelationsHyperlinkComposite(this, 0, this.editor);
                this.relationsComposite.create();
            }
            if (WfeActionableItemReviewHeader.isApplicable(this.workItem)) {
                this.aiReviewHeader = new WfeActionableItemReviewHeader(this, this.editor.getToolkit(), (AbstractReviewArtifact)this.workItem, this.editor);
            }
            boolean isEditable = WorkflowManagerCore.isEditable((AtsUser)AtsApiService.get().getUserService().getCurrentUser(), (IAtsWorkItem)this.workItem, (IAtsStateDefinition)this.workItem.getStateDefinition(), (IAtsUserService)AtsApiService.get().getUserService());
            this.transitionHeader = new WfeTransitionHeader(this, this.editor, isEditable);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private WfeCustomHeader createCustomHeader(Composite comp, XFormToolkit toolkit, IAtsWorkItem workItem, WorkflowEditor editor, IManagedForm managedForm) {
        return new WfeCustomHeader(comp, 0, managedForm, workItem, editor);
    }

    public static void createWorkDefHeader(Composite comp, XFormToolkit toolkit, IAtsWorkItem workItem, int horizontalSpan) {
        Composite headerComp = new Composite(comp, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        headerComp.setLayoutData((Object)gridData);
        int numColumns = 5;
        headerComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)numColumns, (boolean)false));
        toolkit.adapt(headerComp);
        IAtsWorkDefinition workDef = workItem.getWorkDefinition();
        Label label = FormsUtil.createLabelValue((XFormToolkit)toolkit, (Composite)headerComp, (String)"Work Definition: ", (String)workDef.getName());
        label.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                IWorkbenchPage page = AWorkbench.getActivePage();
                try {
                    page.showView("org.eclipse.ui.views.ContentOutline", null, 1);
                }
                catch (PartInitException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
        Label dragDropLabel = new Label(headerComp, 0);
        dragDropLabel.setText("Drag/Drop Related Here: ");
        FormsUtil.setLabelFonts((Control)dragDropLabel, (Font)FontManager.getDefaultLabelFont());
        dragDropLabel.setLayoutData((Object)new GridData());
        toolkit.adapt((Control)dragDropLabel, true, true);
        Label dragDropBox = new Label(headerComp, 2048);
        new WfeDragAndDrop((Control)dragDropBox, (AbstractWorkflowArtifact)workItem.getStoreObject(), "org.eclipse.osee.ats.ide.editor.WorkflowEditor");
        dragDropBox.setText("                             ");
        dragDropBox.setLayoutData((Object)new GridData(768));
        toolkit.adapt((Control)dragDropBox, true, true);
        dragDropBox.setBackground(WfeHeaderComposite.getLightGreyColor());
    }

    public void createSMANotesHeader(Composite comp, XFormToolkit toolkit, int horizontalSpan) {
        String note = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.WorkflowNotes, (Object)"");
        if (!note.equals("")) {
            FormsUtil.createLabelOrHyperlink((Composite)comp, (XFormToolkit)toolkit, (int)horizontalSpan, (String)("Note: " + note));
        }
    }

    public static void createStateNotesHeader(Composite comp, IAtsWorkItem workItem, XFormToolkit toolkit, int horizontalSpan, String forStateName) {
        for (NoteItem noteItem : AtsApiService.get().getWorkItemService().getNotes(workItem).getNoteItems()) {
            if (forStateName != null && !noteItem.getState().equals(forStateName)) continue;
            FormsUtil.createLabelOrHyperlink((Composite)comp, (XFormToolkit)toolkit, (int)horizontalSpan, (String)noteItem.toString());
        }
    }

    public void createWorkPacakageHeader(Composite parent, XFormToolkit toolkit, int horizontalSpan, WorkflowEditor editor) {
        boolean show;
        boolean bl = show = this.workItem.isTeamWorkflow() && ((IAtsTeamWorkflow)this.workItem).getTeamDefinition().hasWorkPackages();
        if (show) {
            Composite comp = toolkit.createContainer(parent, 6);
            comp.setLayoutData((Object)new GridData(768));
            comp.setLayout((Layout)ALayout.getZeroMarginLayout((int)6, (boolean)false));
            this.workPackageHeader = new WfeWorkPackage(comp, 0, (IAtsTeamWorkflow)this.workItem, editor);
        }
    }

    private void createLatestHeader(Composite comp, XFormToolkit toolkit) {
        if (AtsApiService.get().getStoreService().isHistorical((IAtsObject)this.workItem)) {
            Label label = toolkit.createLabel(comp, "This is a historical version of this " + this.workItem.getArtifactTypeName() + " and can not be edited; Select \"Open Latest\" to view/edit latest version.");
            label.setForeground(Displays.getSystemColor((int)3));
        }
    }

    private void createAnnotationsHeader(Composite comp, XFormToolkit toolkit) {
        try {
            if (AttributeAnnotationManager.getAnnotations((Artifact)((Artifact)this.workItem.getStoreObject())).size() > 0) {
                new AnnotationComposite((FormToolkit)toolkit, comp, 0, (Artifact)this.workItem.getStoreObject());
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Exception resolving annotations", (Throwable)ex);
        }
    }

    private void createTargetVersionAndAssigneeHeader(Composite parent, StateXWidgetPage page, XFormToolkit toolkit) {
        boolean isShowTargetedVersion = this.isShowTargetedVersion();
        boolean isCurrentNonCompleteCanceledState = page.isCurrentNonCompleteCancelledState((AbstractWorkflowArtifact)this.workItem.getStoreObject());
        if (!isShowTargetedVersion && !isCurrentNonCompleteCanceledState) {
            return;
        }
        Composite comp = toolkit.createContainer(parent, 6);
        comp.setLayoutData((Object)new GridData(768));
        comp.setLayout((Layout)ALayout.getZeroMarginLayout((int)6, (boolean)false));
        if (isShowTargetedVersion) {
            this.versionHeader = new WfeTargetedVersionHeader(comp, 0, (IAtsTeamWorkflow)this.workItem, this.editor);
            toolkit.createLabel(comp, "    ");
        }
        if (isCurrentNonCompleteCanceledState) {
            boolean editable = WorkflowManager.isAssigneeEditable((AbstractWorkflowArtifact)this.workItem.getStoreObject());
            this.assigneeHeader = new WfeAssigneesHeader(comp, 0, this.workItem, editable, this.editor);
        }
    }

    public boolean isShowTargetedVersion() {
        if (!this.workItem.isTeamWorkflow()) {
            return false;
        }
        return AtsApiService.get().getVersionService().isTeamUsesVersions(((TeamWorkFlowArtifact)this.workItem).getTeamDefinition());
    }

    private static Color getLightGreyColor() {
        if (LIGHT_GREY == null) {
            LIGHT_GREY = Displays.getColor((int)240, (int)240, (int)240);
        }
        return LIGHT_GREY;
    }

    public void dispose() {
        if (this.customHeader != null) {
            this.customHeader.dispose();
        }
        if (this.actionableItemHeader != null) {
            this.actionableItemHeader.dispose();
        }
        if (this.metricsHeader != null) {
            this.metricsHeader.dispose();
        }
    }

    public XResultData isXWidgetDirty(XResultData rd) {
        if (this.titleHeader != null) {
            this.titleHeader.isXWidgetDirty(rd);
        }
        if (this.customHeader != null) {
            this.customHeader.isXWidgetDirty(rd);
        }
        return rd;
    }

    public void getDirtyIArtifactWidgets(List<ArtifactStoredWidget> artWidgets) {
        if (this.titleHeader != null) {
            this.titleHeader.getDirtyIArtifactWidgets(artWidgets);
        }
        if (this.customHeader != null) {
            this.customHeader.getDirtyIArtifactWidgets(artWidgets);
        }
    }

    public Result isXWidgetSavable() {
        Result result;
        if (this.titleHeader != null && (result = this.titleHeader.isXWidgetSavable()).isTrue()) {
            return result;
        }
        if (this.customHeader != null) {
            return this.customHeader.isXWidgetSavable();
        }
        return Result.FalseResult;
    }

    public Collection<XWidget> getXWidgets(ArrayList<XWidget> widgets) {
        this.titleHeader.getXWidgets(widgets);
        this.customHeader.getXWidgets(widgets);
        return widgets;
    }
}

