/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.ide.column.AssigneeColumnUI;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WfeAssigneesHeader
extends Composite {
    private static final String TARGET_VERSION = "Assignee(s):";
    Label valueLabel;
    private final IAtsWorkItem workItem;

    public WfeAssigneesHeader(Composite parent, int style, final IAtsWorkItem workItem, final boolean isEditable, final WorkflowEditor editor) {
        super(parent, style);
        this.workItem = workItem;
        this.setLayoutData(new GridData());
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
        editor.getToolkit().adapt((Composite)this);
        if (!workItem.isCancelled() && !workItem.isCompleted()) {
            Hyperlink link = editor.getToolkit().createHyperlink((Composite)this, TARGET_VERSION, 0);
            link.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        if (editor.isDirty()) {
                            editor.doSave(null);
                        }
                        if (!(isEditable || workItem.getStateMgr().getAssignees().contains(AtsCoreUsers.UNASSIGNED_USER) || workItem.getStateMgr().getAssignees().contains(AtsApiService.get().getUserService().getCurrentUser()))) {
                            AWorkbench.popup((String)"ERROR", (String)"You must be assigned to modify assignees.\nContact current Assignee.");
                            return;
                        }
                        if (AssigneeColumnUI.promptChangeAssignees(workItem, false)) {
                            editor.doSave(null);
                        }
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            });
        } else {
            Label origLabel = editor.getToolkit().createLabel((Composite)this, TARGET_VERSION);
            origLabel.setLayoutData((Object)new GridData());
        }
        this.valueLabel = editor.getToolkit().createLabel((Composite)this, "Not Set");
        this.valueLabel.setLayoutData((Object)new GridData());
        this.refresh();
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this.valueLabel)) {
            String value = "";
            try {
                if (this.workItem.getStateMgr().getAssignees().isEmpty()) {
                    value = "Error: State has no assignees";
                } else {
                    this.valueLabel.setToolTipText(this.workItem.getStateMgr().getAssigneesStr());
                    value = this.workItem.getStateMgr().getAssigneesStr();
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                value = ex.getLocalizedMessage();
                this.valueLabel.setToolTipText(value);
            }
            this.valueLabel.setText(Strings.truncate((String)value, (int)150, (boolean)true));
            this.valueLabel.getParent().layout(true);
            this.valueLabel.getParent().getParent().layout(true);
        }
    }
}

