/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.help.ui.AtsHelpContext;
import org.eclipse.osee.ats.ide.config.AtsBulkLoad;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.WfeAbstractTab;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeHeaderComposite;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.WfeDetailsSection;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.WfeHistorySection;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.WfeOperationsSection;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.WfeRelationsSection;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.WfeUndefinedStateSection;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.WfeWorkflowSection;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workdef.StateXWidgetPage;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.WorkflowManager;
import org.eclipse.osee.ats.ide.world.IWorldViewerEventHandler;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.HelpContext;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.HelpUtil;
import org.eclipse.osee.framework.ui.skynet.artifact.editor.parts.MessageSummaryNote;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.skynet.util.LoadingComposite;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactStoredWidget;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ExceptionComposite;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.progress.UIJob;

public class WfeWorkFlowTab
extends WfeAbstractTab
implements IWorldViewerEventHandler {
    private final AbstractWorkflowArtifact awa;
    private final List<WfeWorkflowSection> stateSections = new ArrayList<WfeWorkflowSection>();
    private final List<StateXWidgetPage> statePages = new ArrayList<StateXWidgetPage>();
    private IManagedForm managedForm;
    private Composite bodyComp;
    private Composite atsBody;
    private LoadingComposite loadingComposite;
    public static final String ID = "ats.workflow.tab";
    private final WorkflowEditor editor;
    private final List<WfeUndefinedStateSection> undefinedStateSections = new ArrayList<WfeUndefinedStateSection>();
    private WfeDetailsSection detailsSection;
    private WfeRelationsSection relationsSection;
    private WfeHistorySection historySection;
    private final Map<String, Pair<StateXWidgetPage, Composite>> stateNameToPageAndComposite = new HashMap<String, Pair<StateXWidgetPage, Composite>>();
    private WfeHeaderComposite headerComp;

    public WfeWorkFlowTab(WorkflowEditor editor, AbstractWorkflowArtifact awa) {
        super(editor, ID, awa, "Workflow");
        this.editor = editor;
        this.awa = awa;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.managedForm = managedForm;
        try {
            this.updateTitleBar(managedForm);
            this.bodyComp = managedForm.getForm().getBody();
            GridLayout gridLayout = new GridLayout(1, false);
            this.bodyComp.setLayout((Layout)gridLayout);
            GridData gd = new GridData(16384, 16384, true, false);
            gd.widthHint = 300;
            this.bodyComp.setLayoutData((Object)gd);
            this.setLoading(true);
            if (this.awa.isTypeEqual((ArtifactTypeId)AtsArtifactTypes.DecisionReview)) {
                HelpUtil.setHelp((Control)managedForm.getForm(), (HelpContext)AtsHelpContext.DECISION_REVIEW);
            } else if (this.awa.isTypeEqual((ArtifactTypeId)AtsArtifactTypes.PeerToPeerReview)) {
                HelpUtil.setHelp((Control)managedForm.getForm(), (HelpContext)AtsHelpContext.PEER_TO_PEER_REVIEW);
            } else {
                HelpUtil.setHelp((Control)managedForm.getForm(), (HelpContext)AtsHelpContext.WORKFLOW_EDITOR__WORKFLOW_TAB);
            }
            ArrayList<IOperation> ops = new ArrayList<IOperation>();
            ops.addAll(AtsBulkLoad.getConfigLoadingOperations());
            IOperation operation = Operations.createBuilder((String)"Load Workflow Tab").addAll(ops).build();
            Operations.executeAsJob((IOperation)operation, (boolean)false, (int)30, (IJobChangeListener)new ReloadJobChangeAdapter(this.editor));
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void showBusy(boolean busy) {
        super.showBusy(busy);
        IManagedForm managedForm = this.getManagedForm();
        if (managedForm != null && Widgets.isAccessible((Widget)this.getManagedForm().getForm())) {
            this.getManagedForm().getForm().getForm().setBusy(busy);
        }
    }

    @Override
    public void handleException(Exception ex) {
        this.setLoading(false);
        if (Widgets.isAccessible((Widget)this.atsBody)) {
            this.atsBody.dispose();
        }
        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        new ExceptionComposite(this.bodyComp, ex);
        this.bodyComp.layout();
    }

    @Override
    public void setLoading(boolean set) {
        if (set) {
            this.loadingComposite = new LoadingComposite(this.bodyComp);
            this.bodyComp.layout();
        } else if (Widgets.isAccessible((Widget)this.loadingComposite)) {
            this.loadingComposite.dispose();
        }
        this.showBusy(set);
    }

    private void createAtsBody() {
        if (Widgets.isAccessible((Widget)this.atsBody)) {
            if (this.getManagedForm() != null && this.getManagedForm().getMessageManager() != null) {
                this.getManagedForm().getMessageManager().removeAllMessages();
            }
            this.atsBody.dispose();
        }
        this.atsBody = this.editor.getToolkit().createComposite(this.bodyComp);
        this.atsBody.setLayoutData((Object)new GridData(1808));
        this.atsBody.setLayout((Layout)new GridLayout(1, false));
        StateXWidgetPage page = WorkflowManager.getCurrentAtsWorkPage(this.awa);
        if (page == null) {
            OseeLog.logf(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't retrieve current page from current state [%s] of work definition [%s]", (Object[])new Object[]{this.awa.getCurrentStateName(), this.awa.getWorkDefinition().getName()});
        }
        this.headerComp = new WfeHeaderComposite(this.atsBody, 0, this.editor, WorkflowManager.getCurrentAtsWorkPage(this.awa), this.managedForm);
        this.headerComp.create();
        this.createPageSections();
        this.createUndefinedStateSections();
        this.createHistorySection();
        this.createRelationsSection();
        this.createOperationsSection();
        this.createDetailsSection();
        this.atsBody.layout();
        this.atsBody.setFocus();
    }

    private void createDetailsSection() {
        try {
            this.detailsSection = new WfeDetailsSection(this.editor, this.atsBody, (FormToolkit)this.editor.getToolkit(), 0);
            this.managedForm.addPart((IFormPart)this.detailsSection);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createOperationsSection() {
        try {
            WfeOperationsSection smaOperationsSection = new WfeOperationsSection(this.editor, this.atsBody, (FormToolkit)this.editor.getToolkit(), 0);
            this.managedForm.addPart((IFormPart)smaOperationsSection);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createRelationsSection() {
        try {
            this.relationsSection = new WfeRelationsSection(this.editor, this.atsBody, (FormToolkit)this.editor.getToolkit(), 0);
            this.managedForm.addPart((IFormPart)this.relationsSection);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createUndefinedStateSections() {
        try {
            if (WfeUndefinedStateSection.hasUndefinedStates(this.editor.getWorkItem())) {
                for (String stateName : WfeUndefinedStateSection.getUndefinedStateNames(this.awa)) {
                    WfeUndefinedStateSection section = new WfeUndefinedStateSection(stateName, this.editor, this.atsBody, (FormToolkit)this.editor.getToolkit(), 0);
                    this.managedForm.addPart((IFormPart)section);
                    this.undefinedStateSections.add(section);
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createHistorySection() {
        try {
            this.historySection = new WfeHistorySection(this.editor, this.atsBody, (FormToolkit)this.editor.getToolkit(), 0);
            this.managedForm.addPart((IFormPart)this.historySection);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createPageSections() {
        try {
            Composite sectionsComp = this.editor.getToolkit().createComposite(this.atsBody);
            GridData gd = new GridData(768);
            gd.widthHint = 100;
            sectionsComp.setLayoutData((Object)gd);
            sectionsComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
            for (StateXWidgetPage statePage : WorkflowManager.getStatePagesOrderedByOrdinal(this.awa)) {
                try {
                    if (this.awa.isInState(statePage) || this.awa.getStateMgr().isStateVisited((IStateToken)statePage)) {
                        this.createStateSection(sectionsComp, statePage);
                        continue;
                    }
                    Composite placeHolderComp = this.editor.getToolkit().createComposite(sectionsComp);
                    gd = new GridData(768);
                    gd.widthHint = 100;
                    placeHolderComp.setLayoutData((Object)gd);
                    placeHolderComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
                    this.stateNameToPageAndComposite.put(statePage.getName(), (Pair<StateXWidgetPage, Composite>)new Pair((Object)statePage, (Object)placeHolderComp));
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createStateSection(Composite sectionsComp, StateXWidgetPage statePage) {
        WfeWorkflowSection section = new WfeWorkflowSection(sectionsComp, 0, statePage, this.awa, this.editor);
        this.managedForm.addPart((IFormPart)section);
        this.stateSections.add(section);
        this.statePages.add(statePage);
    }

    private void addMessageDecoration(ScrolledForm form) {
        form.getForm().addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String title = e.getLabel();
                Object href = e.getHref();
                if (href instanceof IMessage[]) {
                    Point noteLocation = ((Control)e.widget).toDisplay(0, 0);
                    noteLocation.x += 10;
                    noteLocation.y += 10;
                    MessageSummaryNote note = new MessageSummaryNote(WfeWorkFlowTab.this.getManagedForm(), title, (IMessage[])href);
                    note.setLocation(noteLocation);
                    note.open();
                }
            }
        });
    }

    public XResultData isXWidgetDirty(XResultData rd) {
        if (Widgets.isAccessible((Widget)this.headerComp)) {
            rd.log("======> WFE - Header\n");
            this.headerComp.isXWidgetDirty(rd);
        }
        for (WfeWorkflowSection section : this.stateSections) {
            rd.logf("======> WFE Section - %s\n", new Object[]{section.getStatePage().getName()});
            section.isXWidgetDirty(rd);
        }
        return rd;
    }

    public Result isXWidgetSavable() {
        Result result = null;
        if (Widgets.isAccessible((Widget)this.headerComp)) {
            result = this.headerComp.isXWidgetSavable();
        }
        for (WfeWorkflowSection section : this.stateSections) {
            result = section.isXWidgetSavable();
            if (!result.isFalse()) continue;
            return result;
        }
        return Result.TrueResult;
    }

    public void saveXWidgetToArtifact() {
        ArrayList<ArtifactStoredWidget> artWidgets = new ArrayList<ArtifactStoredWidget>();
        this.headerComp.getDirtyIArtifactWidgets(artWidgets);
        for (WfeWorkflowSection section : this.stateSections) {
            section.getDirtyIArtifactWidgets(artWidgets);
        }
        for (ArtifactStoredWidget widget : artWidgets) {
            widget.saveToArtifact();
        }
    }

    public void dispose() {
        if (Widgets.isAccessible((Widget)this.headerComp)) {
            this.headerComp.dispose();
        }
        if (this.detailsSection != null) {
            this.detailsSection.dispose();
        }
        for (WfeUndefinedStateSection wfeUndefinedStateSection : this.undefinedStateSections) {
            wfeUndefinedStateSection.dispose();
        }
        if (this.historySection != null) {
            this.historySection.dispose();
        }
        if (this.relationsSection != null) {
            this.relationsSection.dispose();
        }
        for (WfeWorkflowSection wfeWorkflowSection : this.stateSections) {
            wfeWorkflowSection.dispose();
        }
    }

    public WfeWorkflowSection getCurrentStateSection() {
        for (WfeWorkflowSection section : this.stateSections) {
            if (!section.getPage().getName().equals(this.editor.getWorkItem().getCurrentStateName())) continue;
            return section;
        }
        return null;
    }

    public void refresh() {
        if (this.editor != null && Widgets.isAccessible((Widget)this.headerComp)) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Pair pageAndComp;
                    String stateName = WfeWorkFlowTab.this.awa.getCurrentStateName();
                    boolean found = false;
                    for (WfeWorkflowSection section : WfeWorkFlowTab.this.stateSections) {
                        if (!section.getPage().getName().equals(stateName)) continue;
                        found = true;
                    }
                    WfeWorkFlowTab.this.headerComp.refresh();
                    if (!found && (pageAndComp = (Pair)WfeWorkFlowTab.this.stateNameToPageAndComposite.get(stateName)) != null) {
                        StateXWidgetPage statePage = (StateXWidgetPage)pageAndComp.getFirst();
                        WfeWorkFlowTab.this.createStateSection((Composite)pageAndComp.getSecond(), statePage);
                    }
                    for (WfeWorkflowSection section : WfeWorkFlowTab.this.stateSections) {
                        section.refresh();
                    }
                    WfeWorkFlowTab.this.refreshExpandStates();
                    WfeWorkFlowTab.this.relationsSection.refresh();
                    WfeWorkFlowTab.this.historySection.refresh();
                    WfeWorkFlowTab.this.detailsSection.refresh();
                }
            });
        }
    }

    public void refreshExpandStates() {
        for (WfeWorkflowSection wfeSection : this.stateSections) {
            if (!Widgets.isAccessible((Widget)wfeSection.getMainComp())) continue;
            boolean isCurrentState = wfeSection.isCurrentState();
            if (isCurrentState) {
                wfeSection.expand();
                continue;
            }
            if (!Widgets.isAccessible((Widget)wfeSection.getSection())) continue;
            wfeSection.getSection().setExpanded(false);
        }
        if (Widgets.isAccessible((Widget)this.bodyComp)) {
            this.bodyComp.layout(true, true);
            this.bodyComp.getParent().layout(true, true);
        }
    }

    @Override
    public void relationsModifed(Collection<Artifact> relModifiedArts, Collection<Artifact> goalMemberReordered, Collection<Artifact> sprintMemberReordered) {
        if (relModifiedArts.contains((Object)this.awa)) {
            this.refresh();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.editor.isDisposed();
    }

    public WfeHeaderComposite getHeader() {
        return this.headerComp;
    }

    public List<StateXWidgetPage> getStatePages() {
        return this.statePages;
    }

    public void computeSizeAndReflow() {
        for (WfeWorkflowSection section : this.stateSections) {
            section.computeTextSizesAndReflow();
        }
    }

    private final class ReloadJobChangeAdapter
    extends JobChangeAdapter {
        private final WorkflowEditor editor;

        private ReloadJobChangeAdapter(WorkflowEditor editor) {
            this.editor = editor;
            WfeWorkFlowTab.this.showBusy(true);
        }

        public void done(IJobChangeEvent event) {
            super.done(event);
            UIJob job = new UIJob("Draw Workflow Tab"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        try {
                            if (WfeWorkFlowTab.this.managedForm != null && Widgets.isAccessible((Widget)WfeWorkFlowTab.this.managedForm.getForm())) {
                                WfeWorkFlowTab.this.updateTitleBar(WfeWorkFlowTab.this.managedForm);
                                WfeWorkFlowTab.this.createToolbar(WfeWorkFlowTab.this.managedForm);
                                WfeWorkFlowTab.this.setLoading(false);
                                WfeWorkFlowTab.this.createAtsBody();
                                WfeWorkFlowTab.this.addMessageDecoration(WfeWorkFlowTab.this.managedForm.getForm());
                                FormsUtil.addHeadingGradient((FormToolkit)ReloadJobChangeAdapter.this.editor.getToolkit(), (ScrolledForm)WfeWorkFlowTab.this.managedForm.getForm(), (boolean)true);
                                ReloadJobChangeAdapter.this.editor.onDirtied();
                            }
                        }
                        catch (OseeCoreException ex) {
                            WfeWorkFlowTab.this.handleException((Exception)((Object)ex));
                            WfeWorkFlowTab.this.showBusy(false);
                        }
                    }
                    finally {
                        WfeWorkFlowTab.this.showBusy(false);
                    }
                    return Status.OK_STATUS;
                }
            };
            Operations.scheduleJob((Job)job, (boolean)false, (int)20, null);
        }
    }
}

