/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab;

import java.util.logging.Level;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.AtsArtifactImageProvider;
import org.eclipse.osee.ats.ide.actions.AddNoteAction;
import org.eclipse.osee.ats.ide.actions.CopyActionDetailsAction;
import org.eclipse.osee.ats.ide.actions.EmailActionAction;
import org.eclipse.osee.ats.ide.actions.FavoriteAction;
import org.eclipse.osee.ats.ide.actions.OpenInArtifactEditorAction;
import org.eclipse.osee.ats.ide.actions.OpenInAtsWorldAction;
import org.eclipse.osee.ats.ide.actions.OpenInBrowserAction;
import org.eclipse.osee.ats.ide.actions.OpenParentAction;
import org.eclipse.osee.ats.ide.actions.OpenTeamDefinitionAction;
import org.eclipse.osee.ats.ide.actions.OpenVersionArtifactAction;
import org.eclipse.osee.ats.ide.actions.ResourceHistoryAction;
import org.eclipse.osee.ats.ide.actions.ShowChangeReportAction;
import org.eclipse.osee.ats.ide.actions.ShowContextChangeReportAction;
import org.eclipse.osee.ats.ide.actions.ShowMergeManagerAction;
import org.eclipse.osee.ats.ide.actions.ShowWordChangeReportAction;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.util.WfeReloadAction;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.walker.action.OpenActionViewAction;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.duplicate.CloneWorkflowAction;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.ArtifactImageManager;
import org.eclipse.osee.framework.ui.skynet.util.LoadingComposite;
import org.eclipse.osee.framework.ui.swt.ExceptionComposite;
import org.eclipse.osee.framework.ui.swt.IDirtiableEditor;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;

public abstract class WfeAbstractTab
extends FormPage {
    protected final IAtsWorkItem workItem;
    protected final WorkflowEditor editor;
    protected final String tabName;
    protected LoadingComposite loadingComposite;
    protected Composite bodyComp;

    public WfeAbstractTab(WorkflowEditor editor, String id, IAtsWorkItem workItem, String tabName) {
        super((FormEditor)editor, id, tabName);
        this.editor = editor;
        this.workItem = workItem;
        this.tabName = tabName;
    }

    public void updateTitleBar(IManagedForm managedForm) {
        if (managedForm != null && Widgets.isAccessible((Widget)managedForm.getForm())) {
            String titleString = this.editor.getTitleStr();
            String displayableTitle = Strings.escapeAmpersands((String)titleString);
            managedForm.getForm().setToolTipText(displayableTitle);
            String artifactTypeName = this.workItem.isTeamWorkflow() ? "Team Workflow" : this.workItem.getArtifactTypeName();
            String formTitle = this.getFormTitle(managedForm, artifactTypeName);
            managedForm.getForm().setText(formTitle);
            if (AtsApiService.get().getAgileService().isBacklog((Object)this.workItem)) {
                managedForm.getForm().setImage(ImageManager.getImage((KeyedImage)AtsArtifactImageProvider.getKeyedImage(AtsArtifactImages.AGILE_BACKLOG)));
            } else {
                managedForm.getForm().setImage(ArtifactImageManager.getImage((Artifact)((Artifact)this.workItem.getStoreObject())));
            }
        }
    }

    protected String getFormTitle(IManagedForm managedForm, String artifactTypeName) {
        String formTitle = Strings.isValid((String)this.tabName) ? String.valueOf(this.tabName) + " - " : "";
        formTitle = this.workItem.getParentTeamWorkflow() != null ? String.valueOf(formTitle) + String.format("%s - %s", this.workItem.getParentTeamWorkflow().getTeamDefinition(), artifactTypeName) : String.valueOf(formTitle) + String.format("%s", artifactTypeName);
        return formTitle;
    }

    public void showBusy(boolean busy) {
        super.showBusy(busy);
        IManagedForm managedForm = this.getManagedForm();
        if (managedForm != null && Widgets.isAccessible((Widget)this.getManagedForm().getForm())) {
            this.getManagedForm().getForm().getForm().setBusy(busy);
        }
    }

    public IToolBarManager createToolbar(IManagedForm managedForm) {
        IToolBarManager toolBarMgr = managedForm.getForm().getToolBarManager();
        AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)this.workItem;
        if (awa.isTeamWorkflow() && (AtsApiService.get().getBranchService().isCommittedBranchExists((IAtsTeamWorkflow)((TeamWorkFlowArtifact)awa)) || AtsApiService.get().getBranchService().isWorkingBranchInWork((IAtsTeamWorkflow)((TeamWorkFlowArtifact)awa)))) {
            toolBarMgr.add((IAction)new ShowMergeManagerAction((TeamWorkFlowArtifact)awa));
            toolBarMgr.add((IAction)new ShowChangeReportAction((TeamWorkFlowArtifact)awa));
            toolBarMgr.add((IAction)new ShowWordChangeReportAction((TeamWorkFlowArtifact)awa));
            toolBarMgr.add((IAction)new ShowContextChangeReportAction((TeamWorkFlowArtifact)awa));
        }
        toolBarMgr.add((IAction)new FavoriteAction(this.editor));
        if (awa.getParentAWA() != null) {
            toolBarMgr.add((IAction)new OpenParentAction(awa));
        }
        toolBarMgr.add((IAction)new EmailActionAction(this.editor));
        toolBarMgr.add((IAction)new AddNoteAction(awa, (IDirtiableEditor)this.editor));
        toolBarMgr.add((IAction)new OpenInAtsWorldAction(awa));
        toolBarMgr.add((IAction)new OpenActionViewAction());
        if (AtsApiService.get().getUserService().isAtsAdmin()) {
            toolBarMgr.add((IAction)new OpenInArtifactEditorAction(this.editor));
        }
        toolBarMgr.add((IAction)new OpenVersionArtifactAction(awa));
        if (awa instanceof TeamWorkFlowArtifact) {
            toolBarMgr.add((IAction)new OpenTeamDefinitionAction((TeamWorkFlowArtifact)awa));
        }
        toolBarMgr.add((IAction)new CopyActionDetailsAction(awa, AtsApiService.get()));
        toolBarMgr.add((IAction)new OpenInBrowserAction(awa));
        toolBarMgr.add((IAction)new ResourceHistoryAction(awa));
        if (awa.isTeamWorkflow()) {
            toolBarMgr.add((IAction)new CloneWorkflowAction((TeamWorkFlowArtifact)awa, null));
        }
        this.addRefreshAction(toolBarMgr);
        managedForm.getForm().updateToolBar();
        return toolBarMgr;
    }

    public void addRefreshAction(IToolBarManager toolBarMgr) {
        toolBarMgr.add((IAction)new WfeReloadAction((AbstractWorkflowArtifact)this.workItem, this.editor));
    }

    public void handleException(Exception ex) {
        this.setLoading(false);
        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        new ExceptionComposite(this.bodyComp, ex);
        this.bodyComp.layout();
    }

    public void setLoading(boolean set) {
        if (set) {
            this.loadingComposite = new LoadingComposite(this.bodyComp);
            this.bodyComp.layout();
        } else if (Widgets.isAccessible((Widget)this.loadingComposite)) {
            this.loadingComposite.dispose();
        }
        this.showBusy(set);
    }
}

