/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.version;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.artifact.massEditor.MassArtifactEditor;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class MassEditTeamVersionItem
extends XNavigateItemAction {
    private IAtsTeamDefinition selectedTeamDef;

    public MassEditTeamVersionItem(String name, XNavigateItem parent, KeyedImage oseeImage) {
        super(parent, name, oseeImage);
    }

    private IAtsTeamDefinition getTeamDefinition() {
        if (this.selectedTeamDef != null) {
            return this.selectedTeamDef;
        }
        TeamDefinitionDialog dialog = new TeamDefinitionDialog();
        dialog.setInput(AtsApiService.get().getTeamDefinitionService().getTeamReleaseableDefinitions(Active.Active));
        int result = dialog.open();
        if (result == 0) {
            return (IAtsTeamDefinition)dialog.getSelectedFirst();
        }
        return null;
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        try {
            this.selectedTeamDef = this.getTeamDefinition();
            if (this.selectedTeamDef == null) {
                return;
            }
            if (AtsApiService.get().getTeamDefinitionService().getTeamDefHoldingVersions(this.selectedTeamDef) == null) {
                AWorkbench.popup((String)"ERROR", (String)"Team is not configured to use versions.");
                return;
            }
            MassArtifactEditor.editArtifacts((String)this.getName(), this.getResults(), (XNavigateComposite.TableLoadOption[])new XNavigateComposite.TableLoadOption[0]);
            this.selectedTeamDef = null;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public List<Artifact> getResults() {
        Collection versions = AtsApiService.get().getVersionService().getVersionsFromTeamDefHoldingVersions(this.selectedTeamDef);
        Collection verArtToks = AtsApiService.get().getQueryService().getArtifactsFromObjects(versions);
        return Collections.castAll((Collection)verArtToks);
    }

    public void setSelectedTeamDef(IAtsTeamDefinition selectedTeamDef) {
        this.selectedTeamDef = selectedTeamDef;
    }
}

