/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.plugin.util.StringLabelProvider;
import org.eclipse.osee.framework.ui.skynet.util.StringNameComparator;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class WorkPackageFilterTreeDialog
extends FilteredTreeDialog {
    private IAtsWorkPackage selection;
    XCheckBox showAll = new XCheckBox("Show All Work Packages");
    private boolean removeFromWorkPackage;
    private boolean showRemoveCheckbox = true;
    private final IWorkPackageProvider workPackageProvider;

    public WorkPackageFilterTreeDialog(String title, String message, IWorkPackageProvider workPackageProvider) {
        super(title, message, (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new StringLabelProvider());
        this.workPackageProvider = workPackageProvider;
    }

    protected Control createDialogArea(Composite container) {
        Control comp = super.createDialogArea(container);
        try {
            this.getTreeViewer().getViewer().setComparator((ViewerComparator)new StringNameComparator());
            this.getTreeViewer().getViewer().addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)WorkPackageFilterTreeDialog.this.getTreeViewer().getViewer().getSelection();
                    if (sel.isEmpty()) {
                        WorkPackageFilterTreeDialog.this.selection = null;
                    } else {
                        WorkPackageFilterTreeDialog.this.selection = (IAtsWorkPackage)sel.getFirstElement();
                    }
                    WorkPackageFilterTreeDialog.this.updateStatusLabel();
                }
            });
            GridData gd = new GridData(1808);
            gd.heightHint = 500;
            this.getTreeViewer().getViewer().getTree().setLayoutData((Object)gd);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        Composite comp1 = new Composite(comp.getParent(), 0);
        comp1.setLayout((Layout)new GridLayout(2, false));
        comp1.setLayoutData((Object)new GridData(1808));
        this.showAll.createWidgets(comp1, 2);
        this.showAll.set(false);
        this.showAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkPackageFilterTreeDialog.this.setInput();
            }
        });
        if (this.showRemoveCheckbox) {
            this.createRemoveCheckbox(comp1);
        }
        return comp1;
    }

    private void createRemoveCheckbox(Composite parent) {
        final XCheckBox checkbox = new XCheckBox("Remove from TeamDefinitionToWorkPackage");
        checkbox.setFillHorizontally(true);
        checkbox.set(this.removeFromWorkPackage);
        checkbox.createWidgets(parent, 2);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkPackageFilterTreeDialog.this.removeFromWorkPackage = checkbox.isSelected();
                WorkPackageFilterTreeDialog.this.updateStatusLabel();
            }
        };
        checkbox.addSelectionListener((SelectionListener)selectionListener);
    }

    protected Result isComplete() {
        try {
            if (this.selection == null && !this.removeFromWorkPackage) {
                return new Result("A Work Package or \"Remove From TeamDefinitionToWorkPackage\" must be selected.");
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return Result.TrueResult;
    }

    public IAtsWorkPackage getSelection() {
        return this.selection;
    }

    public void setInput() {
        try {
            if (this.showAll != null && this.showAll.isChecked()) {
                super.setInput(this.workPackageProvider.getAllWorkPackages());
            } else {
                super.setInput(this.workPackageProvider.getActiveWorkPackages());
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public boolean isRemoveFromWorkPackage() {
        return this.removeFromWorkPackage;
    }

    public void setShowRemoveCheckbox(boolean showRemoveCheckbox) {
        this.showRemoveCheckbox = showRemoveCheckbox;
    }

    public static interface IWorkPackageProvider {
        public Collection<IAtsWorkPackage> getActiveWorkPackages();

        public Collection<IAtsWorkPackage> getAllWorkPackages();
    }
}

