/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.config.AtsAttributeValueColumn;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionPageAttributeFactory;
import org.eclipse.osee.ats.api.workflow.INewActionPageAttributeFactoryProvider;
import org.eclipse.osee.ats.core.column.AtsColumnToken;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.PromptChangeUtil;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeValueColumn;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class PriorityColumnUI
extends XViewerAtsAttributeValueColumn {
    public static PriorityColumnUI instance = null;
    private final AtsAttributeValueColumn colToken;
    private final AttributeTypeEnum<?> attrToken;

    public static PriorityColumnUI getInstance() {
        if (instance == null) {
            for (INewActionPageAttributeFactoryProvider provider : AtsApiService.get().getAttributeProviders()) {
                for (INewActionPageAttributeFactory factory : provider.getNewActionAttributeFactory()) {
                    if (!factory.useFactory()) continue;
                    instance = new PriorityColumnUI(factory.getPrioirtyColumnToken(), factory.getPrioirtyAttrToken());
                    return instance;
                }
            }
            instance = new PriorityColumnUI(AtsColumnToken.PriorityColumn, (AttributeTypeEnum<?>)AtsAttributeTypes.Priority);
        }
        return instance;
    }

    private PriorityColumnUI(AtsAttributeValueColumn priColToken, AttributeTypeEnum<?> priAttrToken) {
        super(priColToken);
        this.colToken = priColToken;
        this.attrToken = priAttrToken;
    }

    @Override
    public PriorityColumnUI copy() {
        PriorityColumnUI newXCol = new PriorityColumnUI(this.colToken, this.attrToken);
        super.copy(this, newXCol);
        return newXCol;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean promptChangePriority(Collection<? extends TeamWorkFlowArtifact> teams, AttributeTypeToken attrTypeToken, boolean persist) {
        try {
            TeamWorkFlowArtifact team;
            Iterator<? extends TeamWorkFlowArtifact> iterator = teams.iterator();
            do {
                if (!iterator.hasNext()) {
                    PromptChangeUtil.promptChangeAttribute(teams, attrTypeToken, persist, false);
                    return true;
                }
                team = iterator.next();
            } while (!AtsApiService.get().getVersionService().isReleased((IAtsTeamWorkflow)team) && !AtsApiService.get().getVersionService().isVersionLocked((IAtsTeamWorkflow)team));
            AWorkbench.popup((String)"ERROR", (String)("Team Workflow\n \"" + team.getName() + "\"\n version is locked or already released."));
            return false;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't change priority", (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        block10: {
            Artifact useArt;
            block13: {
                block12: {
                    block11: {
                        block9: {
                            Artifact artifact = (Artifact)treeItem.getData();
                            if (artifact.getArtifactType().getMax(this.getAttributeType()) == 1) break block9;
                            return false;
                        }
                        if (!(treeItem.getData() instanceof Artifact)) break block10;
                        useArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                        if (!useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) break block11;
                        if (AtsApiService.get().getWorkItemService().getTeams((Object)useArt).size() == 1) {
                            useArt = AtsApiService.get().getQueryServiceIde().getArtifact(AtsApiService.get().getWorkItemService().getFirstTeam((Object)useArt));
                            break block11;
                        }
                        return false;
                    }
                    if (useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) break block12;
                    return false;
                }
                TeamWorkFlowArtifact team = (TeamWorkFlowArtifact)useArt;
                if (!AtsApiService.get().getVersionService().isReleased((IAtsTeamWorkflow)team) && !AtsApiService.get().getVersionService().isVersionLocked((IAtsTeamWorkflow)team)) break block13;
                AWorkbench.popup((String)"ERROR", (String)("Team Workflow\n \"" + team.getName() + "\"\n version is locked or already released."));
                return false;
            }
            try {
                boolean modified = PriorityColumnUI.promptChangePriority(Arrays.asList((TeamWorkFlowArtifact)useArt), this.attrToken, this.isPersistViewer());
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                if (modified && this.isPersistViewer(xViewer)) {
                    useArt.persist("persist priority via alt-left-click");
                }
                if (modified) {
                    xViewer.update((Object)useArt, null);
                    return true;
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return false;
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        HashSet<TeamWorkFlowArtifact> awas = new HashSet<TeamWorkFlowArtifact>();
        for (TreeItem item : treeItems) {
            if (!(item.getData() instanceof Artifact)) continue;
            Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(item);
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
            awas.add((TeamWorkFlowArtifact)art);
        }
        if (awas.isEmpty()) {
            AWorkbench.popup((String)"Must select Team Workflow(s)");
            return;
        }
        PriorityColumnUI.promptChangePriority(awas, this.attrToken, true);
    }
}

