/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.branch.internal;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.branch.BranchData;
import org.eclipse.osee.ats.api.commit.CommitConfigItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.core.util.AbstractAtsBranchService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.model.cache.BranchFilter;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class AtsBranchServiceImpl
extends AbstractAtsBranchService {
    public AtsBranchServiceImpl(AtsApi atsApi, ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy) {
        super(atsApi, teamWorkflowProvidersLazy);
    }

    public BranchToken getWorkingBranchExcludeStates(IAtsTeamWorkflow teamWf, BranchState ... negatedBranchStates) {
        BranchFilter branchFilter = new BranchFilter(new BranchType[]{BranchType.WORKING, BranchType.BASELINE});
        branchFilter.setNegatedBranchStates(negatedBranchStates);
        branchFilter.setAssociatedArtifact(teamWf.getStoreObject());
        return BranchManager.getBranch((Predicate)branchFilter);
    }

    public BranchToken getCommittedWorkingBranch(IAtsTeamWorkflow teamWf) {
        BranchFilter branchFilter = new BranchFilter(new BranchType[]{BranchType.WORKING});
        branchFilter.setBranchStates(new BranchState[]{BranchState.COMMITTED});
        branchFilter.setAssociatedArtifact(teamWf.getStoreObject());
        return BranchManager.getBranch((Predicate)branchFilter);
    }

    public BranchType getBranchType(BranchId branch) {
        return BranchManager.getType((BranchId)branch);
    }

    public BranchState getBranchState(BranchId branch) {
        return BranchManager.getState((BranchId)branch);
    }

    public Collection<TransactionRecord> getCommittedArtifactTransactionIds(IAtsTeamWorkflow teamWf) {
        return TransactionManager.getCommittedArtifactTransactionIds((ArtifactId)teamWf.getStoreObject());
    }

    public boolean isMergeBranchExists(IAtsTeamWorkflow teamWf, BranchId workingBranch, BranchId destinationBranch) {
        if (workingBranch.isInvalid()) {
            return false;
        }
        return BranchManager.doesMergeBranchExist((BranchId)workingBranch, (BranchId)destinationBranch);
    }

    public boolean isArchived(BranchId branch) {
        return BranchManager.isArchived((BranchId)branch);
    }

    public void archiveBranch(BranchId branch) {
        BranchManager.archiveUnArchiveBranch((BranchId)branch, (BranchArchivedState)BranchArchivedState.ARCHIVED);
    }

    public BranchId getParentBranch(BranchId branch) {
        return BranchManager.getParentBranch((BranchId)branch);
    }

    public TransactionToken getBaseTransaction(BranchId branch) {
        return BranchManager.getBaseTransaction((BranchId)branch);
    }

    public void setBranchName(BranchToken branch, String name) {
        BranchManager.setName((BranchId)branch, (String)name);
    }

    public String getBranchName(BranchId branch) {
        return BranchManager.getBranchName((BranchId)branch);
    }

    public boolean branchExists(BranchId branch) {
        return BranchManager.branchExists((BranchId)branch);
    }

    public Result moveWorkingBranch(IAtsTeamWorkflow fromTeamWf, IAtsTeamWorkflow toTeamWf, String newBranchName) {
        if (this.isCommittedBranchExists(fromTeamWf)) {
            return new Result(false, "Can not move a branch that has commits");
        }
        BranchToken workingBranch = this.getWorkingBranch(fromTeamWf);
        if (workingBranch == null) {
            return new Result(false, "Working Branch does not exist for workflow " + toTeamWf.toStringWithId());
        }
        if (this.getWorkingBranch(toTeamWf).isValid()) {
            return new Result(false, String.format("Can not move Working Branch to workflow %s; It already has a working branch.", toTeamWf.toStringWithId()));
        }
        try {
            BranchManager.setAssociatedArtifactId((BranchId)workingBranch, (ArtifactId)toTeamWf.getStoreObject());
        }
        catch (Exception exception) {
            return new Result(false, String.format("Failure setting new associated artifact %s for branch [%s] ", toTeamWf.toStringWithId(), workingBranch));
        }
        String log = String.format("Working Branch [%s] moved from %s to %s.", workingBranch, fromTeamWf.toStringWithId(), toTeamWf.toStringWithId());
        try {
            BranchManager.setName((BranchId)workingBranch, (String)newBranchName);
        }
        catch (Exception exception) {
            return new Result(false, String.format("Failure setting new branch name [%s] for branch [%s] ", newBranchName, workingBranch));
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet(log);
        fromTeamWf.getLog().addLog(LogType.Note, fromTeamWf.getStateMgr().getCurrentStateName(), log, this.atsApi.getUserService().getCurrentUserId());
        changes.add((Object)fromTeamWf);
        toTeamWf.getLog().addLog(LogType.Note, toTeamWf.getStateMgr().getCurrentStateName(), log, this.atsApi.getUserService().getCurrentUserId());
        changes.add((Object)toTeamWf);
        changes.execute();
        return Result.TrueResult;
    }

    public Collection<BranchId> getBranches(BranchArchivedState archivedState, BranchType branchTypes) {
        return Collections.castAll((Collection)BranchManager.getBranches((BranchArchivedState)archivedState, (BranchType[])new BranchType[]{branchTypes}));
    }

    public ArtifactId getAssociatedArtifactId(BranchId branch) {
        return BranchManager.getAssociatedArtifactId((BranchId)branch);
    }

    public List<ChangeItem> getChangeData(BranchId branch) {
        return this.atsApi.getServerEndpoints().getActionEndpoint().getBranchChangeData(branch);
    }

    public List<ChangeItem> getChangeData(TransactionId transaction) {
        return this.atsApi.getServerEndpoints().getActionEndpoint().getTransactionChangeData(transaction);
    }

    public void setAssociatedArtId(BranchId branch, ArtifactId artifact) {
        BranchManager.setAssociatedArtifactId((BranchId)branch, (ArtifactId)artifact);
    }

    public boolean isBaselinBranchConfigured(CommitConfigItem commitConfigItem) {
        return false;
    }

    public BranchToken getBranch(BranchId branch) {
        return BranchManager.getBranchToken((BranchId)branch);
    }

    public XResultData deleteBranch(BranchId branch) {
        XResultData rd = new XResultData();
        try {
            BranchManager.deleteBranch((BranchId)branch);
        }
        catch (Exception exception) {
            rd.errorf("Exception deleting branch %s", new Object[]{branch.toString()});
        }
        return rd;
    }

    public BranchData createBranch(BranchData branchData) {
        return this.atsApi.getServerEndpoints().getConfigEndpoint().createBranch(branchData);
    }
}

