/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile;

import java.net.URL;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XButton;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabel;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public abstract class AbstractXOpenSprintBurnupButton
extends XButton
implements ArtifactWidget {
    protected IAgileSprint sprint;
    private final boolean editable = false;
    public static final String WIDGET_ID = AbstractXOpenSprintBurnupButton.class.getSimpleName();
    private final String id;
    XModifiedListener listener = new XModifiedListener(){

        public void widgetModified(XWidget widget) {
            try {
                AbstractXOpenSprintBurnupButton.this.openInternally();
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    };

    public AbstractXOpenSprintBurnupButton(String name, String id) {
        super(name);
        this.id = id;
        this.setImage(ImageManager.getImage((KeyedImage)AtsImage.REPORT));
        this.setToolTip("Click to run Open Report");
        this.addXModifiedListener(this.listener);
    }

    public Artifact getArtifact() {
        return AtsApiService.get().getQueryServiceIde().getArtifact(this.sprint);
    }

    protected Artifact getAgileTeam() {
        return AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)AtsApiService.get().getRelationResolver().getRelatedOrNull((IAtsObject)this.sprint, AtsRelationTypes.AgileTeamToSprint_AgileTeam));
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        XHyperlinkLabel external = new XHyperlinkLabel("Open Externally", this.getUrl(), true);
        external.createWidgets(this.bComp, horizontalSpan);
        external.getControl().setForeground(Displays.getSystemColor((int)9));
        external.addXModifiedListener(new XModifiedListener(){

            public void widgetModified(XWidget widget) {
                AbstractXOpenSprintBurnupButton.this.openExternally();
            }
        });
    }

    public void openExternally() {
        String url = this.getUrl();
        Program.launch((String)url);
    }

    public void openInternally() {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = browserSupport.createBrowser(String.valueOf(this.id) + this.sprint.getIdString());
            String url = this.getUrl();
            browser.openURL(new URL(url));
        }
        catch (Exception ex) {
            OseeLog.log(AbstractXOpenSprintBurnupButton.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    abstract String getUrl();

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void revert() {
    }

    public void saveToArtifact() {
    }

    public void setArtifact(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
            this.sprint = (IAgileSprint)artifact;
        }
    }

    public boolean isEditable() {
        return false;
    }
}

