/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.demo.DemoAis;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.ide.actions.wizard.IAtsWizardItem;
import org.eclipse.osee.ats.ide.actions.wizard.NewActionJob;
import org.eclipse.osee.ats.ide.actions.wizard.NewActionPage1;
import org.eclipse.osee.ats.ide.actions.wizard.NewActionPage2;
import org.eclipse.osee.ats.ide.actions.wizard.NewActionPage3;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XDate;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewActionWizard
extends Wizard
implements INewWizard {
    protected NewActionPage1 page1;
    protected NewActionPage2 page2;
    protected NewActionPage3 page3;
    private Collection<IAtsActionableItem> initialAias;
    private Collection<IAtsActionableItem> selectableAis;
    private String initialDescription;
    private NewActionJob job = null;
    private INewActionListener newActionListener;
    private boolean openOnComplete = true;

    public boolean performFinish() {
        block5: {
            try {
                Result result = this.isActionValid();
                if (!result.isFalse()) break block5;
                AWorkbench.popup((Result)result);
                return false;
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                return false;
            }
        }
        ArrayList<INewActionListener> listeners = new ArrayList<INewActionListener>();
        if (this.newActionListener != null) {
            listeners.add(this.newActionListener);
        }
        if (this.page2.getNewActionListener() != null) {
            listeners.add(this.page2.getNewActionListener());
        }
        this.job = new NewActionJob(this.getTitle(), this.getDescription(), this.getChangeType(), this.getPriority(), this.getNeedBy(), this.getValidation(), this.getSelectedIAtsActionableItems(), this, listeners);
        this.job.setUser(true);
        this.job.setOpenOnComplete(this.openOnComplete);
        this.job.setPriority(30);
        this.job.schedule();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.page1 = new NewActionPage1(this);
        this.addPage((IWizardPage)this.page1);
        this.page2 = this.createNewActionPage2();
        this.addPage((IWizardPage)this.page2);
    }

    public NewActionPage2 createNewActionPage2() {
        for (IAtsWizardItem item : NewActionPage3.getWizardXWidgetExtensions()) {
            try {
                NewActionPage2 page2 = item.getNewActionPage2(this);
                if (page2 == null) continue;
                return page2;
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return new NewActionPage2(this);
    }

    public boolean canFinish() {
        return this.isTestAction() || this.page3 == null ? this.page2.isPageComplete() : this.page3.isPageComplete();
    }

    public void createPage3IfNecessary() {
        if (this.page3 == null && NewActionPage3.isPage3Necesary(this.getSelectedIAtsActionableItems())) {
            this.page3 = new NewActionPage3(this);
            this.addPage((IWizardPage)this.page3);
        }
    }

    public boolean isTestAction() {
        return this.getTitle().equals(DemoAis.TEST_Action);
    }

    public String getTitle() {
        return ((XText)this.page1.getXWidget("Title")).get();
    }

    public Set<IAtsActionableItem> getSelectedIAtsActionableItems() {
        return this.page1.getSelectedIAtsActionableItems();
    }

    public String getDescription() {
        return ((XText)this.page2.getXWidget("Description")).get();
    }

    public String getPriority() {
        return ((XCombo)this.page2.getXWidget("Priority")).get();
    }

    public ChangeType getChangeType() {
        return ChangeType.getChangeType((Object)((XCombo)this.page2.getXWidget("Change Type")).get());
    }

    public boolean getValidation() {
        if (this.page2.addValidation()) {
            return ((XCheckBox)this.page2.getXWidget("Validation Required")).isChecked();
        }
        return false;
    }

    public Date getNeedBy() {
        if (this.page2.hasNeedByDate()) {
            return ((XDate)this.page2.getXWidget("Deadline")).getDate();
        }
        return null;
    }

    public void notifyAtsWizardItemExtensions(ActionResult actionResult, IAtsChangeSet changes) {
        if (this.page3 != null) {
            this.page3.notifyAtsWizardItemExtensions(actionResult, changes);
        }
    }

    public XWidget getExtendedXWidget(String attrName) {
        if (this.page3 == null) {
            return null;
        }
        return this.page3.getXWidget(attrName);
    }

    public Result isActionValid() {
        if (this.page3 == null) {
            return Result.TrueResult;
        }
        return this.page3.isActionValid();
    }

    public String getInitialDescription() {
        return this.initialDescription;
    }

    public void setInitialDescription(String initialDescription) {
        this.initialDescription = initialDescription;
    }

    public Collection<IAtsActionableItem> getInitialAias() {
        return this.initialAias;
    }

    public void setInitialAias(Collection<IAtsActionableItem> initialAias) {
        this.initialAias = initialAias;
    }

    public INewActionListener getNewActionListener() {
        return this.newActionListener;
    }

    public void setNewActionListener(INewActionListener newActionListener) {
        this.newActionListener = newActionListener;
    }

    public void setOpenOnComplete(boolean openOnComplete) {
        this.openOnComplete = openOnComplete;
    }

    public void getSelectableAis(Collection<IAtsActionableItem> ais) {
        this.selectableAis = ais;
    }

    public Collection<IAtsActionableItem> getSelectableAis() {
        return this.selectableAis;
    }
}

