/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.demo.DemoAis;
import org.eclipse.osee.ats.help.ui.AtsHelpContext;
import org.eclipse.osee.ats.ide.actions.wizard.NewActionWizard;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AITreeContentProvider;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AtsObjectNameSorter;
import org.eclipse.osee.ats.ide.workflow.ATSXWidgetOptionResolver;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.HelpContext;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.HelpUtil;
import org.eclipse.osee.framework.ui.skynet.util.IsEnabled;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.CheckBoxStateFilteredTreeViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.CheckBoxStateTreeLabelProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.ICheckBoxStateTreeListener;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.ICheckBoxStateTreeViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NewActionPage1
extends WizardPage
implements IsEnabled {
    private final NewActionWizard wizard;
    private XWidgetPage page;
    protected CheckBoxStateFilteredTreeViewer<IAtsActionableItem> treeViewer;
    private Text descriptionLabel;
    private boolean debugPopulated = false;
    private static List<IAtsActionableItem> testAis;
    protected static final String TITLE = "Title";
    private final AtsApi atsApi;
    private final XModifiedListener xModListener = new XModifiedListener(){

        public void widgetModified(XWidget widget) {
            NewActionPage1.this.getContainer().updateButtons();
        }
    };

    protected NewActionPage1(NewActionWizard actionWizard) {
        super("Create new ATS Action", "Create ATS Action", null);
        this.setMessage("Enter title and select impacted items.");
        this.wizard = actionWizard;
        this.atsApi = AtsApiService.get();
    }

    protected String getWidgetXml() {
        return "<WorkPage><XWidget displayName=\"Title\" storageName=\"Name\" required=\"true\" xwidgetType=\"XText\" toolTip=\"" + AtsAttributeTypes.Title.getDescription() + "\"/>" + "</WorkPage>";
    }

    public void createControl(Composite parent) {
        try {
            String xWidgetXml = this.getWidgetXml();
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new GridLayout(1, false));
            comp.setLayoutData((Object)new GridData(4, 4, true, true));
            this.page = new XWidgetPage(xWidgetXml, (IXWidgetOptionResolver)ATSXWidgetOptionResolver.getInstance());
            this.page.createBody(null, comp, null, this.xModListener, true);
            ((XText)this.getXWidget(TITLE)).getLabelWidget().addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    if (event.button == 3) {
                        NewActionPage1.this.handlePopulateWithDebugInfo();
                    }
                }
            });
            Pair<CheckBoxStateFilteredTreeViewer<IAtsActionableItem>, Text> results = NewActionPage1.createActionableItemTreeViewer(comp, this.wizard.getSelectableAis());
            this.treeViewer = (CheckBoxStateFilteredTreeViewer)results.getFirst();
            this.treeViewer.setEnabledChecker((IsEnabled)this);
            this.descriptionLabel = (Text)results.getSecond();
            this.treeViewer.addCheckListener(new ICheckBoxStateTreeListener(){

                public void checkStateNodesChanged() {
                    NewActionPage1.this.getContainer().updateButtons();
                }
            });
            this.treeViewer.addCheckListener((ICheckBoxStateTreeListener)new CheckStateListener());
            this.setControl((Control)comp);
            this.setHelpContexts();
            if (this.wizard.getInitialAias() != null) {
                this.treeViewer.setChecked(this.wizard.getInitialAias());
            }
            ((XText)this.getXWidget(TITLE)).setFocus();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public static Pair<CheckBoxStateFilteredTreeViewer<IAtsActionableItem>, Text> createActionableItemTreeViewer(Composite comp, Collection<IAtsActionableItem> selectableAis) {
        Composite aiComp = new Composite(comp, 0);
        aiComp.setLayout((Layout)new GridLayout(1, false));
        aiComp.setLayoutData((Object)new GridData(1808));
        new Label(aiComp, 0).setText("Select Actionable Items:");
        final CheckBoxStateFilteredTreeViewer treeViewer = new CheckBoxStateFilteredTreeViewer(aiComp, 2824);
        treeViewer.getViewer().getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.getViewer().setContentProvider((IContentProvider)new AITreeContentProvider(Active.Active));
        treeViewer.getViewer().setLabelProvider((IBaseLabelProvider)new AITreeLabelProvider((ICheckBoxStateTreeViewer)treeViewer));
        try {
            if (selectableAis == null) {
                LinkedList<ActionableItem> activeActionableItemTree = new LinkedList<ActionableItem>();
                AtsConfigurations configs = AtsApiService.get().getConfigService().getConfigurations();
                for (Long aiId : ((ActionableItem)configs.getIdToAi().get(configs.getTopActionableItem().getId())).getChildren()) {
                    ActionableItem ai = (ActionableItem)configs.getIdToAi().get(aiId);
                    if (!ai.isActive()) continue;
                    activeActionableItemTree.add(ai);
                }
                treeViewer.getViewer().setInput(activeActionableItemTree);
                if (activeActionableItemTree.size() == 1) {
                    treeViewer.expandOneLevel();
                }
            } else {
                treeViewer.getViewer().setInput(selectableAis);
                if (selectableAis.size() == 1) {
                    treeViewer.expandOneLevel();
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        treeViewer.getViewer().setComparator((ViewerComparator)new AtsObjectNameSorter());
        GridData gridData1 = new GridData(1808);
        gridData1.heightHint = 400;
        treeViewer.setLayoutData((Object)gridData1);
        new Label(aiComp, 0).setText("Description of highlighted Actionable Item (if any):");
        Text descriptionLabel = new Text(aiComp, 2112);
        gridData1 = new GridData(1808);
        gridData1.heightHint = 15;
        descriptionLabel.setLayoutData((Object)gridData1);
        descriptionLabel.setEnabled(false);
        Button deselectAll = new Button(aiComp, 8);
        deselectAll.setText("De-Select All");
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                treeViewer.deSelectAll();
            }
        });
        return new Pair((Object)treeViewer, (Object)descriptionLabel);
    }

    private void handlePopulateWithDebugInfo() {
        if (this.debugPopulated) {
            return;
        }
        try {
            ((XText)this.getXWidget(TITLE)).set(DemoAis.TEST_Action);
            if (testAis == null) {
                testAis = new ArrayList<IAtsActionableItem>();
                for (ArtifactToken art : this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.ActionableItem}).andTag(new String[]{DemoAis.TEST_AI}).getArtifacts()) {
                    ActionableItem ai = this.atsApi.getActionableItemService().getActionableItemById((ArtifactId)art);
                    if (ai == null) continue;
                    testAis.add((IAtsActionableItem)ai);
                }
            }
            if (!testAis.isEmpty()) {
                for (IAtsActionableItem ai : testAis) {
                    this.treeViewer.setChecked((Object)ai, true);
                }
                this.treeViewer.getViewer().setSelection((ISelection)new StructuredSelection(Arrays.asList(testAis)));
            }
            this.getContainer().updateButtons();
            this.debugPopulated = true;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private void setHelpContexts() {
        HelpUtil.setHelp((Control)this.getControl(), (HelpContext)AtsHelpContext.NEW_ACTION_PAGE_1);
    }

    public Set<IAtsActionableItem> getSelectedIAtsActionableItems() {
        HashSet<IAtsActionableItem> selected = new HashSet<IAtsActionableItem>();
        for (Object obj : this.treeViewer.getChecked()) {
            if (obj instanceof IAtsActionableItem) {
                selected.add((IAtsActionableItem)obj);
                continue;
            }
            if (!(obj instanceof ActionableItem)) continue;
            ActionableItem ai = (ActionableItem)obj;
            selected.add((IAtsActionableItem)this.atsApi.getQueryService().getConfigItem(ai.getId()));
        }
        return selected;
    }

    public XWidget getXWidget(String attrName) {
        Conditions.checkNotNull((Object)this.page, (String)"WorkPage");
        return this.page.getLayoutData(attrName).getXWidget();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPageComplete() {
        if (this.wizard.isTestAction()) {
            return true;
        }
        if (this.treeViewer.getChecked().isEmpty()) {
            return false;
        }
        try {
            IAtsActionableItem aia;
            Iterator<IAtsActionableItem> iterator = this.getSelectedIAtsActionableItems().iterator();
            do {
                if (iterator.hasNext()) continue;
                Collection teamDefs = this.atsApi.getTeamDefinitionService().getImpactedTeamDefs(this.getSelectedIAtsActionableItems());
                if (!teamDefs.isEmpty()) return this.page.isPageComplete().isTrue();
                AWorkbench.popup((String)"ERROR", (String)"No Teams Associated with selected Actionable Items");
                return false;
            } while ((aia = iterator.next()).isActionable() && this.userActionCreationEnabled(aia));
            AWorkbench.popup((String)"ERROR", (String)this.atsApi.getActionableItemService().getNotActionableItemError((IAtsConfigObject)aia));
            this.treeViewer.setChecked((Object)aia, false);
            return false;
        }
        catch (Exception ex) {
            AWorkbench.popup((String)"ERROR", (String)ex.getLocalizedMessage());
            return false;
        }
    }

    protected boolean userActionCreationEnabled(IAtsActionableItem aia) {
        return aia.isAllowUserActionCreation();
    }

    public CheckBoxStateFilteredTreeViewer<IAtsActionableItem> getTreeViewer() {
        return this.treeViewer;
    }

    public boolean isEnabled(Object obj) {
        if (obj instanceof IAtsActionableItem) {
            return ((IAtsActionableItem)obj).isActive() && ((IAtsActionableItem)obj).isActionable();
        }
        return false;
    }

    public static class AITreeLabelProvider
    extends CheckBoxStateTreeLabelProvider {
        public AITreeLabelProvider(ICheckBoxStateTreeViewer treeViewer) {
            super(treeViewer);
        }

        protected boolean isEnabled(Object element) {
            IAtsActionableItem ai;
            boolean enabled = false;
            if (element instanceof IAtsActionableItem && (ai = (IAtsActionableItem)element).isActionable()) {
                enabled = true;
            }
            return enabled;
        }
    }

    private class CheckStateListener
    implements ICheckBoxStateTreeListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(Object obj) {
            if (NewActionPage1.this.descriptionLabel != null) {
                Collection checked = NewActionPage1.this.treeViewer.getChecked();
                if (checked.isEmpty()) {
                    NewActionPage1.this.descriptionLabel.setText("");
                } else {
                    IAtsActionableItem ai = (IAtsActionableItem)checked.iterator().next();
                    NewActionPage1.this.descriptionLabel.setText(ai.getDescription());
                }
            }
        }
    }
}

