/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.actions.RevertDuplicateAtsTransitionByIdAction;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.CheckBoxDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class RevertDuplicateAtsTransitionsAction
extends Action {
    private static String DUPLICATE_TRANSITION_QUERY = "select art_id, transaction_id from     (SELECT        art.art_id, attr.attr_id, attr.value, attr.gamma_id, txs.tx_current,       txs.transaction_id, count(distinct attr.attr_id) over (partition by art.art_id) attr_id_cnt     FROM        osee_artifact art, osee_attribute attr, osee_txs txs     WHERE       txs.branch_id = ? and txs.gamma_id = attr.gamma_id and art.art_id =      attr.art_id and attr.attr_type_id = ? and        txs.tx_current = 1) t1 where t1.attr_id_cnt > 1";

    public RevertDuplicateAtsTransitionsAction() {
        this("Revert Duplicate ATS Transitions");
    }

    public RevertDuplicateAtsTransitionsAction(String name) {
        super(name);
        this.setToolTipText(this.getText());
    }

    public void run() {
        String title = this.getText();
        CheckBoxDialog dialog = new CheckBoxDialog(title, "Fix all duplicate transitions?", "Persist");
        if (dialog.open() == 0) {
            final boolean persist = dialog.isChecked();
            AbstractOperation operation = new AbstractOperation(title, "org.eclipse.osee.ats.ide"){

                protected void doWork(IProgressMonitor monitor) throws Exception {
                    List<ArtifactId> artIds = RevertDuplicateAtsTransitionsAction.this.getArtIdsWithDuplicateTransitions();
                    XResultData results = new XResultData();
                    SkynetTransaction trans = TransactionManager.createTransaction((BranchId)AtsApiService.get().getAtsBranch(), (String)this.getName());
                    boolean changed = false;
                    for (Artifact art : ArtifactQuery.getArtifactListFrom(artIds, (BranchId)AtsApiService.get().getAtsBranch())) {
                        results.logf("\n\nReverting transition for %s\n\n", new Object[]{art.toStringWithId()});
                        if (RevertDuplicateAtsTransitionByIdAction.revertTransition(art, results, persist, trans)) {
                            changed = true;
                            continue;
                        }
                        results.log("Nothing to change.");
                    }
                    if (persist && !results.isErrors() && changed) {
                        trans.execute();
                    }
                    if (!changed) {
                        results.error("Nothing changed");
                    }
                    XResultDataUI.report((XResultData)results, (String)this.getName());
                    if (results.isErrors()) {
                        AWorkbench.popup((String)"Errors found, search Error in results.  Restart before re-running if you persisted");
                    }
                }
            };
            Operations.executeAsJob((IOperation)operation, (boolean)true);
        }
    }

    protected List<ArtifactId> getArtIdsWithDuplicateTransitions() {
        LinkedList<ArtifactId> artIds = new LinkedList<ArtifactId>();
        for (AttributeTypeId attributeTypeId : Arrays.asList(AtsAttributeTypes.CompletedDate, AtsAttributeTypes.CancelledDate)) {
            for (IAtsWorkItem workItem : AtsApiService.get().getQueryService().getWorkItemsFromQuery(DUPLICATE_TRANSITION_QUERY, new Object[]{AtsApiService.get().getAtsBranch().getId(), attributeTypeId.getId()})) {
                artIds.add(ArtifactId.valueOf((Long)workItem.getId()));
            }
        }
        return artIds;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)AtsImage.TASK);
    }
}

