/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.AtsColumnToken;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.util.widgets.dialog.ActionableItemListDialog;
import org.eclipse.osee.ats.ide.world.WorldXViewerFactory;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryCheckDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class OpenOrphanedTasks
extends Action {
    public OpenOrphanedTasks() {
        this("Open Orphaned Tasks");
    }

    public OpenOrphanedTasks(String name) {
        super(name);
        this.setToolTipText(this.getText());
    }

    public void run() {
        EntryCheckDialog dialog = new EntryCheckDialog("Search Orphaned Tasks", "Search Orphaned Tasks", "Add to New Team Workflow");
        if (dialog.open() == 0) {
            IAtsActionableItem ai = null;
            if (dialog.isChecked()) {
                ActionableItemListDialog dialog2 = new ActionableItemListDialog(Active.Active, "Select AI for Action");
                if (dialog2.open() == 0) {
                    ai = dialog2.getSelected().iterator().next();
                } else {
                    return;
                }
            }
            final IAtsActionableItem fAi = ai;
            AbstractOperation operation = new AbstractOperation("Search Orphaned Tasks", "org.eclipse.osee.ats.ide"){

                protected void doWork(IProgressMonitor monitor) throws Exception {
                    List ids = ArtifactQuery.createQueryBuilder((BranchId)AtsApiService.get().getAtsBranch()).andIsOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task}).andNotExists(AtsRelationTypes.TeamWfToTask_Task).getIds();
                    if (ids.isEmpty()) {
                        AWorkbench.popup((String)"No Orphaned Tasks Found");
                    } else {
                        XViewerColumn col;
                        List artifacts = ArtifactQuery.getArtifactListFrom((Collection)ids, (BranchId)AtsApiService.get().getAtsBranch());
                        CustomizeData data = new CustomizeData();
                        data.setGuid(GUID.create());
                        data.setName("Orphaned Task View");
                        data.setPersonal(true);
                        data.setNameSpace("WorldXViewer");
                        List<String> visibleColIds = Arrays.asList(AtsColumnToken.TypeColumn.getId(), AtsColumnToken.TitleColumn.getId(), AtsColumnToken.CreatedDateColumn.getId(), "framework.lastModBy", "framework.lastModDate");
                        for (String visibleId : visibleColIds) {
                            XViewerColumn visCol = null;
                            XViewerColumn[] xViewerColumnArray = WorldXViewerFactory.getWorldViewColumns();
                            int n = xViewerColumnArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                col = xViewerColumnArray[n2];
                                if (col.getId().equals(visibleId)) {
                                    visCol = col.copy();
                                    visCol.setShow(true);
                                    break;
                                }
                                ++n2;
                            }
                            if (visCol == null) continue;
                            data.getColumnData().getColumns().add(visCol);
                        }
                        col = WorldXViewerFactory.getWorldViewColumns();
                        int visCol = ((XViewerColumn[])col).length;
                        int n = 0;
                        while (n < visCol) {
                            XViewerColumn col2 = col[n];
                            if (!visibleColIds.contains(col2.getId())) {
                                XViewerColumn cCol = col2.copy();
                                cCol.setShow(false);
                                data.getColumnData().getColumns().add(cCol);
                            }
                            ++n;
                        }
                        if (fAi == null) {
                            AtsEditors.openInAtsWorldEditor("Orphaned Tasks", artifacts, data);
                        } else {
                            AtsUser asUser = AtsApiService.get().getUserService().getCurrentUser();
                            IAtsChangeSet changes = AtsApiService.get().getStoreService().createAtsChangeSet(this.getName(), asUser);
                            ActionResult results = AtsApiService.get().getActionService().createAction(asUser, this.getName(), this.getName(), ChangeType.Support, "3", false, null, Arrays.asList(fAi), new Date(), asUser, null, changes);
                            IAtsTeamWorkflow teamWf = results.getFirstTeam();
                            for (Artifact taskArt : artifacts) {
                                changes.relate((Object)teamWf, AtsRelationTypes.TeamWfToTask_Task, (Object)taskArt);
                            }
                            changes.execute();
                            AtsEditors.openATSAction(teamWf.getStoreObject(), AtsOpenOption.OpenOneOrPopupSelect);
                        }
                    }
                }
            };
            Operations.executeAsJob((IOperation)operation, (boolean)true);
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)AtsImage.TASK);
    }
}

