/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.FavoritesManager;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class FavoriteAction
extends AbstractAtsAction {
    private final ISelectedAtsArtifacts selectedAtsArtifacts;
    private boolean prompt;

    public FavoriteAction(ISelectedAtsArtifacts selectedAtsArtifacts) {
        this.selectedAtsArtifacts = selectedAtsArtifacts;
        this.prompt = true;
        this.updateEnablement();
    }

    public void updateEnablement() {
        String title = "Favorite";
        try {
            Collection<AbstractWorkflowArtifact> workflows = this.getSelectedFavoritableArts();
            this.setEnabled(!workflows.isEmpty());
            title = workflows.size() == 1 ? (FavoritesManager.amIFavorite(workflows.iterator().next()) ? "Remove Favorite" : "Add as Favorite") : "Toggle Favorites";
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            this.setEnabled(false);
        }
        this.setText(title);
        this.setToolTipText(title);
    }

    public Collection<AbstractWorkflowArtifact> getSelectedFavoritableArts() {
        ArrayList<AbstractWorkflowArtifact> favoritableArts = new ArrayList<AbstractWorkflowArtifact>();
        for (Artifact art : this.selectedAtsArtifacts.getSelectedWorkflowArtifacts()) {
            if (!(art instanceof AbstractWorkflowArtifact)) continue;
            favoritableArts.add((AbstractWorkflowArtifact)art);
        }
        return favoritableArts;
    }

    @Override
    public void runWithException() {
        new FavoritesManager(this.getSelectedFavoritableArts()).toggleFavorite(this.prompt);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)AtsImage.FAVORITE);
    }

    public void setPrompt(boolean prompt) {
        this.prompt = prompt;
    }
}

