/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.FavoritesManager;
import org.eclipse.osee.ats.ide.util.SubscribeManager;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactImage;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.ArtifactImageManager;
import org.eclipse.osee.framework.ui.skynet.ArtifactImageProvider;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.util.CoreImage;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.OverlayImage;

public class AtsArtifactImageProvider
extends ArtifactImageProvider {
    private static final Map<ArtifactImage, KeyedImage> keyedImageMap = new HashMap<ArtifactImage, KeyedImage>();
    private static AtsArtifactImageProvider provider = new AtsArtifactImageProvider();
    private static AtomicBoolean initRan = new AtomicBoolean(false);

    public void init() {
        if (!initRan.getAndSet(true)) {
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.DecisionReview, (KeyedImage)AtsImage.DECISION_REVIEW, (ArtifactImageProvider)this);
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.Action, (KeyedImage)AtsImage.ACTION, (ArtifactImageProvider)this);
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.Version, (KeyedImage)FrameworkImage.VERSION, (ArtifactImageProvider)this);
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.Task, (KeyedImage)AtsImage.TASK, (ArtifactImageProvider)this);
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.ActionableItem, (KeyedImage)AtsImage.ACTIONABLE_ITEM, (ArtifactImageProvider)this);
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.TeamDefinition, (KeyedImage)AtsImage.TEAM_DEFINITION, (ArtifactImageProvider)this);
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.RuleDefinition, (KeyedImage)AtsImage.RULE_DEFINITION, (ArtifactImageProvider)this);
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.WorkDefinition, (KeyedImage)AtsImage.WORK_DEFINITION, (ArtifactImageProvider)this);
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.Goal, (KeyedImage)AtsImage.GOAL, (ArtifactImageProvider)this);
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.PeerToPeerReview, (KeyedImage)AtsImage.PEER_REVIEW, (ArtifactImageProvider)this);
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.Program, (KeyedImage)AtsImage.PROGRAM, (ArtifactImageProvider)this);
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.Insertion, (KeyedImage)AtsImage.INSERTION, (ArtifactImageProvider)this);
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.InsertionActivity, (KeyedImage)AtsImage.INSERTION_ACTIVITY, (ArtifactImageProvider)this);
            ArtifactImageManager.registerBaseImage((ArtifactTypeToken)AtsArtifactTypes.WorkPackage, (KeyedImage)AtsImage.WORK_PACKAGE, (ArtifactImageProvider)this);
            for (ArtifactImage artImage : AtsArtifactImages.getImages()) {
                CoreImage keyedImage = new CoreImage("org.eclipse.osee.ats.ide", artImage.getImageName());
                keyedImageMap.put(artImage, (KeyedImage)keyedImage);
                ArtifactImageManager.registerBaseImage((ArtifactTypeToken)artImage.getArtifactType(), (KeyedImage)keyedImage, (ArtifactImageProvider)this);
            }
            ArtifactImageManager.registerOverrideImageProvider((ArtifactImageProvider)this, (ArtifactTypeToken)AtsArtifactTypes.Version);
            ArtifactImageManager.registerOverrideImageProvider((ArtifactImageProvider)this, (ArtifactTypeToken)AtsArtifactTypes.Task);
            ArtifactImageManager.registerOverrideImageProvider((ArtifactImageProvider)this, (ArtifactTypeToken)AtsArtifactTypes.PeerToPeerReview);
            ArtifactImageManager.registerOverrideImageProvider((ArtifactImageProvider)this, (ArtifactTypeToken)AtsArtifactTypes.DecisionReview);
            ArtifactImageManager.registerOverrideImageProvider((ArtifactImageProvider)this, (ArtifactTypeToken)AtsArtifactTypes.Goal);
            ArtifactImageManager.registerOverrideImageProvider((ArtifactImageProvider)this, (ArtifactTypeToken)AtsArtifactTypes.AgileBacklog);
            ArtifactImageManager.registerOverrideImageProvider((ArtifactImageProvider)this, (ArtifactTypeToken)AtsArtifactTypes.AgileSprint);
            for (ArtifactTypeToken artifactType : AtsArtifactTypes.TeamWorkflow.getAllDescendantTypes()) {
                ArtifactImageManager.registerOverrideImageProvider((ArtifactImageProvider)this, (ArtifactTypeToken)artifactType);
            }
        }
    }

    public static KeyedImage getKeyedImage(ArtifactImage artifactImage) {
        provider.init();
        return provider.getImage(artifactImage);
    }

    public KeyedImage getImage(ArtifactImage artifactImage) {
        return keyedImageMap.get(artifactImage);
    }

    public String setupImage(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Version})) {
            if (((Boolean)artifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.NextVersion, (Object)false)).booleanValue()) {
                return ArtifactImageManager.setupImage((Artifact)artifact, (KeyedImage)AtsImage.NEXT, (OverlayImage.Location)OverlayImage.Location.BOT_RIGHT);
            }
            if (((Boolean)artifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Released, (Object)false)).booleanValue()) {
                return ArtifactImageManager.setupImage((Artifact)artifact, (KeyedImage)AtsImage.RELEASED, (OverlayImage.Location)OverlayImage.Location.TOP_RIGHT);
            }
            if (((Boolean)artifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.VersionLocked, (Object)false)).booleanValue() && !((Boolean)artifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Released, (Object)false)).booleanValue()) {
                return ArtifactImageManager.setupImage((Artifact)artifact, (KeyedImage)AtsImage.VERSION_LOCKED, (OverlayImage.Location)OverlayImage.Location.BOT_RIGHT);
            }
        }
        if (artifact instanceof AbstractWorkflowArtifact) {
            AbstractWorkflowArtifact stateMachine = (AbstractWorkflowArtifact)artifact;
            if (SubscribeManager.isSubscribed(stateMachine, AtsApiService.get().getUserService().getCurrentUser())) {
                return ArtifactImageManager.setupImage((Artifact)artifact, (KeyedImage)AtsImage.SUBSCRIBED_OVERLAY, (OverlayImage.Location)OverlayImage.Location.BOT_RIGHT);
            }
            if (FavoritesManager.isFavorite(stateMachine, AtsApiService.get().getUserService().getCurrentUser())) {
                return ArtifactImageManager.setupImage((Artifact)artifact, (KeyedImage)AtsImage.FAVORITE_OVERLAY, (OverlayImage.Location)OverlayImage.Location.TOP_RIGHT);
            }
        }
        return super.setupImage(artifact);
    }
}

