/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.lifecycle;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.lifecycle.AbstractLifecycleVisitor;
import org.eclipse.osee.framework.lifecycle.ILifecycleService;
import org.eclipse.osee.framework.lifecycle.LifecycleHandler;

public class LifecycleServiceImpl
implements ILifecycleService {
    private final HashCollection<AbstractLifecycleVisitor.Type<?>, LifecycleHandler> handlersByType = new HashCollection();

    @Override
    public Collection<AbstractLifecycleVisitor.Type<?>> getHandlerTypes() {
        return this.handlersByType.keySet();
    }

    private <H> ArrayList<H> get(AbstractLifecycleVisitor.Type<H> type) {
        return (ArrayList)this.handlersByType.getValues(type);
    }

    @Override
    public <H extends LifecycleHandler> IStatus dispatch(IProgressMonitor monitor, AbstractLifecycleVisitor<H> visitor, String sourceId) {
        AbstractLifecycleVisitor.Type<H> type = visitor.getAssociatedType();
        Status status = null;
        ArrayList<H> handlers = this.get(type);
        if (handlers != null) {
            for (LifecycleHandler handler : handlers) {
                status = visitor.dispatch(monitor, handler, sourceId);
                if (status.isOK()) {
                    continue;
                }
                break;
            }
        } else {
            status = new Status(4, this.getClass().getName(), String.format("Error handler [%s] not found.", type));
        }
        return status;
    }

    @Override
    public int getHandlerCount(AbstractLifecycleVisitor.Type<?> type) {
        ArrayList<?> handlers = this.get(type);
        return handlers == null ? 0 : handlers.size();
    }

    @Override
    public <H extends LifecycleHandler> void addHandler(AbstractLifecycleVisitor.Type<H> type, H handler) {
        Conditions.checkNotNull(type, (String)"handler type");
        Conditions.checkNotNull(handler, (String)"handler");
        this.handlersByType.put(type, handler);
    }

    @Override
    public <H extends LifecycleHandler> void removeHandler(AbstractLifecycleVisitor.Type<H> type, H handler) {
        Conditions.checkNotNull(type, (String)"handler type");
        Conditions.checkNotNull(handler, (String)"handler");
        this.handlersByType.removeValue(type, handler);
    }
}

